/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.items;

import ivorius.ivtoolkit.tools.IvInventoryHelper;
import ivorius.psychedelicraft.entities.DrugHelper;
import ivorius.psychedelicraft.entities.DrugInfluence;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemSmokingPipe
extends Item {
    public ArrayList<ItemSmokingPipeConsumable> consumables = new ArrayList();

    public ItemSmokingPipe() {
        this.func_77656_e(50);
        this.func_77625_d(1);
    }

    public void addConsumable(ItemSmokingPipeConsumable consumable) {
        this.consumables.add(consumable);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        DrugHelper drugHelper;
        ItemSmokingPipeConsumable usedConsumable = this.getUsedConsumable(player);
        if (usedConsumable != null && IvInventoryHelper.consumeInventoryItem((InventoryPlayer)player.field_71071_by, (ItemStack)usedConsumable.consumedItem) && (drugHelper = DrugHelper.getDrugHelper((Entity)player)) != null) {
            for (DrugInfluence influence : usedConsumable.drugInfluences) {
                drugHelper.addToDrug(influence.clone());
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            drugHelper.startBreathingSmoke(10 + world.field_73012_v.nextInt(10), usedConsumable.smokeColor);
        }
        return super.func_77654_b(stack, world, player);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        DrugHelper drugHelper = DrugHelper.getDrugHelper((Entity)player);
        if (drugHelper != null && drugHelper.timeBreathingSmoke <= 0 && this.getUsedConsumable(player) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public ItemSmokingPipeConsumable getUsedConsumable(EntityPlayer player) {
        for (ItemSmokingPipeConsumable consumable : this.consumables) {
            if (!player.field_71071_by.func_70431_c(consumable.consumedItem)) continue;
            return consumable;
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 25;
    }

    public boolean func_77629_n_() {
        return true;
    }

    public static class ItemSmokingPipeConsumable {
        public ItemStack consumedItem;
        public DrugInfluence[] drugInfluences;
        public float[] smokeColor;

        public ItemSmokingPipeConsumable(ItemStack consumedItem, DrugInfluence[] drugInfluences) {
            this(consumedItem, drugInfluences, new float[]{1.0f, 1.0f, 1.0f});
        }

        public ItemSmokingPipeConsumable(ItemStack consumedItem, DrugInfluence[] drugInfluences, float[] smokeColor) {
            this.consumedItem = consumedItem;
            this.drugInfluences = drugInfluences;
            this.smokeColor = smokeColor;
        }
    }
}

