/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GeneratorGeneric
implements IWorldGenerator {
    public WorldGenerator generator;
    public List<Entry> biomeEntries;

    public GeneratorGeneric(WorldGenerator worldGen, Entry ... biomeEntries) {
        this.generator = worldGen;
        this.biomeEntries = Arrays.asList(biomeEntries);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biomeGen = world.func_72807_a(chunkX * 16 + 8, chunkZ * 16 + 8);
        int generate = 0;
        for (Entry biomeEntry : this.biomeEntries) {
            generate += biomeEntry.numberGenerated(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider, biomeGen);
        }
        for (int i = 0; i < generate; ++i) {
            int genX = chunkX * 16 + random.nextInt(16) + 8;
            int genZ = chunkZ * 16 + random.nextInt(16) + 8;
            int genY = world.func_72976_f(genX, genZ);
            this.generator.func_76484_a(world, random, genX, genY, genZ);
        }
    }

    public static Entry[] simpleEntryList(float chance, int number, BiomeGenBase ... biomes) {
        Entry[] list = new Entry[biomes.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new EntryDefault(biomes[i], chance, number);
        }
        return list;
    }

    public static class EntryDefault
    implements Entry {
        private BiomeGenBase biome;
        private float chance;
        public int number;

        public EntryDefault(BiomeGenBase biome, float chance) {
            this(biome, chance, 1);
        }

        public EntryDefault(BiomeGenBase biome, float chance, int number) {
            this.biome = biome;
            this.chance = chance;
            this.number = number;
        }

        @Override
        public int numberGenerated(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider, BiomeGenBase biomeGen) {
            return this.getBiome() == biomeGen && random.nextFloat() < this.getChance() ? this.number : 0;
        }

        public float getChance() {
            return this.chance;
        }

        public BiomeGenBase getBiome() {
            return this.biome;
        }
    }

    public static interface Entry {
        public int numberGenerated(Random var1, int var2, int var3, World var4, IChunkProvider var5, IChunkProvider var6, BiomeGenBase var7);
    }
}

