/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.ec.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.lomeli.ec.entity.ai.EntityAIFriendlyCreeperSwell;
import net.lomeli.ec.entity.explosion.ExplosionFriendly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityFriendlyCreeper
extends EntityTameable {
    protected EntityLivingBase owner;
    protected ItemStack armor;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    protected int fuseTime = 30;
    protected int explosionRadius = 3;
    protected int coolDownTime;
    protected boolean explosionSound;
    private float field_70926_e;
    private float field_70924_f;
    public boolean useExplosion;

    public EntityFriendlyCreeper(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFriendlyCreeperSwell(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 0.25, (double)0.3f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.func_70624_b(null);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        super.func_70624_b(par1EntityLivingBase);
        if (par1EntityLivingBase == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)-1);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)new Float(this.func_110143_aJ()));
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean par1) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    protected String func_70621_aR() {
        return "mob.creeper.say";
    }

    protected String func_70673_aS() {
        return "mob.creeper.death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                if (!this.field_70170_p.field_72995_K) {
                    boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                    this.doFriendlyExplosion(flag);
                }
            }
        }
        if (this.func_70906_o()) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70125_A = 45.0f;
        }
        super.func_70071_h_();
        this.field_70924_f = this.field_70926_e;
        this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
        if (this.func_70922_bv()) {
            this.field_70700_bx = 10;
        }
    }

    public void doFriendlyExplosion(boolean flag) {
        if (!this.useExplosion) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius, flag);
            this.func_70106_y();
        } else if (++this.coolDownTime == 30) {
            this.createFriendlyExplosion(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius);
            this.coolDownTime = 0;
        }
    }

    public ExplosionFriendly createFriendlyExplosion(double x, double y, double z, float strength) {
        ExplosionFriendly explosion = new ExplosionFriendly(this.field_70170_p, this, x, y, z, strength);
        explosion.field_77286_a = false;
        explosion.field_82755_b = true;
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntitySkeleton) {
            Item[] records = new Item[]{Items.field_151086_cn, Items.field_151096_cd, Items.field_151094_cf, Items.field_151093_ce, Items.field_151091_cg, Items.field_151092_ch, Items.field_151089_ci, Items.field_151090_cj, Items.field_151087_ck, Items.field_151088_cl, Items.field_151084_co, Items.field_151085_cm};
            this.func_145779_a(records[this.field_70146_Z.nextInt(records.length)], 1);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = par1DamageSource.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public boolean func_70652_k(Entity par1Entity) {
        int i = this.func_70909_n() ? 4 : 2;
        return par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)i);
    }

    public void func_70903_f(boolean par1) {
        super.func_70903_f(par1);
        if (par1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            if (itemstack != null) {
                if (itemstack.func_77973_b() instanceof ItemFood) {
                    ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                    if (this.func_110143_aJ() < 20.0f) {
                        if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                        this.func_70691_i(itemfood.func_150906_h(itemstack));
                        if (itemstack.field_77994_a <= 0) {
                            par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                        }
                        return true;
                    }
                }
            } else if (par1EntityPlayer.getDisplayName().equalsIgnoreCase(this.func_70905_p())) {
                this.func_70904_g(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.func_70784_b(null);
                this.func_70624_b(null);
            }
        } else if (itemstack != null && itemstack.func_77973_b().equals(Items.field_151016_H) && !this.isAngry()) {
            if (!par1EntityPlayer.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            if (itemstack.field_77994_a <= 0) {
                par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b((EntityLivingBase)((EntityLiving)null));
                    this.func_70910_a(par1EntityPlayer.getDisplayName());
                    this.owner = par1EntityPlayer;
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.useExplosion = true;
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return par1ItemStack != null && (par1ItemStack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150328_O)) || par1ItemStack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150327_N)));
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntityFriendlyCreeper)) {
            return false;
        }
        EntityFriendlyCreeper entityCreeper = (EntityFriendlyCreeper)par1EntityAnimal;
        return !entityCreeper.func_70909_n() ? false : (entityCreeper.func_70906_o() ? false : this.func_70880_s() && entityCreeper.func_70880_s());
    }

    public boolean func_70922_bv() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    public EntityLivingBase func_70902_q() {
        return this.field_70170_p.func_72924_a(this.func_70905_p());
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        EntityFriendlyCreeper entity = new EntityFriendlyCreeper(this.field_70170_p);
        String s = this.func_70905_p();
        if (s != null && s.trim().length() > 0) {
            entity.func_70910_a(s);
            entity.owner = this.func_70902_q();
            entity.func_70903_f(true);
        }
        return entity;
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)par1));
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        par1NBTTagCompound.func_74768_a("coolDown", this.coolDownTime);
        par1NBTTagCompound.func_74757_a("useExplosion", this.useExplosion);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Fuse")) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_74764_b("ExplosionRadius")) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
        if (par1NBTTagCompound.func_74764_b("coolDown")) {
            this.coolDownTime = par1NBTTagCompound.func_74762_e("coolDown");
        }
        if (par1NBTTagCompound.func_74764_b("useExplosion")) {
            this.useExplosion = par1NBTTagCompound.func_74767_n("useExplosion");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float par1) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * par1) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public String tamedTexture() {
        return this.func_70909_n() ? "textures/entities/friendlycreeper1.png" : "textures/entities/friendlycreeper0.png";
    }

    public ItemStack getArmorSlot() {
        return this.armor;
    }

    private void setArmorSlot(EntityPlayer player) {
        ItemStack itemstack = player.func_71045_bC();
        if (itemstack != null) {
            if (this.armor != null) {
                EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.armor);
                this.field_70170_p.func_72838_d((Entity)item);
                this.armor = null;
            } else {
                ItemStack copy = itemstack.func_77946_l();
                copy.field_77994_a = 1;
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                }
                this.armor = copy;
            }
        } else if (this.armor != null) {
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.armor);
            this.field_70170_p.func_72838_d((Entity)item);
            this.armor = null;
        }
    }

    public void setArmor(ItemStack stack) {
        if (this.armor != null) {
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.armor);
            this.field_70170_p.func_72838_d((Entity)item);
            this.armor = null;
        }
        this.armor = stack;
    }
}

