/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.ec.core;

import java.io.File;
import net.lomeli.ec.lib.ECVars;
import net.minecraftforge.common.config.Configuration;

public class Config {
    public static Configuration config;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        Config.loadID();
        Config.loadCreeperOptions();
        Config.loadSpawnRates();
        Config.loadBlastRadius();
        config.save();
    }

    private static void loadID() {
        ECVars.useStaticIds = config.get("general", "useStaticIDs", false, "Set specific ids for the creepers. If false (which is recommended), the creepers will get a unique ID on mod loading.").getBoolean(false);
        ECVars.fireCreeperID = config.get("general", "fireCreeperID", 121, "Creeper IDs - Can be between -127 to 127, check for http://minecraft.gamepedia.com/Data_values/Entity_IDs open IDs").getInt(121);
        ECVars.waterCreeperID = Config.setGetInt("waterCreeperID", 122);
        ECVars.electricCreeperID = Config.setGetInt("electricCreeperID", 123);
        ECVars.cookieCreeperID = Config.setGetInt("cookieCreeperID", 124);
        ECVars.darkCreeperID = Config.setGetInt("darkCreeperID", 125);
        ECVars.lightCreeperID = Config.setGetInt("lightCreeperID", 126);
        ECVars.earthCreeperID = Config.setGetInt("earthCreeperID", 127);
        ECVars.magmaCreeperID = Config.setGetInt("magmaCreeperID", 101);
        ECVars.reverseCreeperID = Config.setGetInt("reverseCreeperID", 102);
        ECVars.iceCreeperID = Config.setGetInt("iceCreeperID", 103);
        ECVars.friendlyCreeperID = Config.setGetInt("friendlyCreeperID", 104);
        ECVars.ghostCreeperID = Config.setGetInt("ghostCreeperID", 105);
        ECVars.illusionCreeperID = Config.setGetInt("illusionCreeperID", 107);
        ECVars.psychicCreeperID = Config.setGetInt("psychicCreeperID", 108);
        ECVars.spiderCreeperID = Config.setGetInt("spiderCreeperID", 106);
        ECVars.windCreeperID = Config.setGetInt("windCreeperID", 114);
        ECVars.hydrogenCreeperID = Config.setGetInt("hydrogenCreperID", 115);
        ECVars.enderCreeperID = Config.setGetInt("enderCreeperID", 116);
        ECVars.stoneCreeperID = Config.setGetInt("stoneCreeperID", 117);
        ECVars.euCreeperID = Config.setGetInt("euCreeperID", 118);
        ECVars.rfCreeperID = Config.setGetInt("rfCreeperID", 119);
        ECVars.solarCreeperID = Config.setGetInt("solarCreeperID", 120);
        ECVars.mjCreeperID = Config.setGetInt("mjCreeperID", 121);
    }

    private static void loadCreeperOptions() {
        ECVars.cookieCreeperAmount = config.get("general", "cookiesDropped", 5, "The number of cookies a Cookie Creeper drops").getInt(5);
    }

    private static void loadSpawnRates() {
        ECVars.fireCreeperSpawn = config.get("general", "fireCreeperSpawn", 10, "Creeper Spawn Rates").getInt(10);
        ECVars.waterCreeperSpawn = Config.setGetInt("waterCreeperSpawn", 10);
        ECVars.electricCreeperSpawn = Config.setGetInt("electricCreeperSpawn", 10);
        ECVars.cookieCreeperSpawn = Config.setGetInt("cookieCreeperSpawn", 10);
        ECVars.darkCreeperSpawn = Config.setGetInt("darkCreeperSpawn", 2);
        ECVars.lightCreeperSpawn = Config.setGetInt("lightCreeperSpawn", 4);
        ECVars.earthCreeperSpawn = Config.setGetInt("earthCreeperSpawn", 10);
        ECVars.magmaCreeperSpawn = Config.setGetInt("magmaCreeperSpawn", 6);
        ECVars.reverseCreeperSpawn = Config.setGetInt("reverseCreeperSpawn", 6);
        ECVars.iceCreeperSpawn = Config.setGetInt("iceCreeperSpawn", 10);
        ECVars.psychicCreeperSpawn = Config.setGetInt("psychicCreeperSpawn", 10);
        ECVars.illusionCreeperSpawn = Config.setGetInt("illusionCreeperSpawn", 6);
        ECVars.spiderCreeperSpawn = Config.setGetInt("spiderCreeperSpawn", 8);
        ECVars.friendlyCreeperSpawn = Config.setGetInt("friendlyCreeperSpawn", 1);
        ECVars.windCreeperSpawn = Config.setGetInt("windCreeperSpawn", 10);
        ECVars.hydrogenCreeperSpawn = Config.setGetInt("hydrogenCreeperSpawn", 1);
        ECVars.enderCreeperSpawn = Config.setGetInt("enderCreeperSpawn", 4);
        ECVars.stoneCreeperSpawn = Config.setGetInt("stoneCreeperSpawn", 10);
        ECVars.solarCreeperSpawn = Config.setGetInt("solarCreeperSpawn", 4);
        ECVars.euCreeperSpawn = Config.setGetInt("euCreeperSpawn", 10);
        ECVars.rfCreeperSpawn = Config.setGetInt("rfCreeperSpawn", 10);
        ECVars.mjCreeperSpawn = Config.setGetInt("mjCreeperSpawn", 10);
    }

    private static void loadBlastRadius() {
        ECVars.waterCreeperRadius = config.get("general", "waterCreeperRadius", 4, "Creeper Explosion Radius").getInt(4);
        ECVars.fireCreeperRadius = Config.setGetInt("fireCreeperRadius", 6);
        ECVars.iceCreeperRadius = Config.setGetInt("iceCreeperRadius", 12);
        ECVars.electricCreeperRadius = Config.setGetInt("electricCreeperRadius", 5);
        ECVars.earthCreeperRadius = Config.setGetInt("earthCreeperRadius", 8);
        ECVars.psychicCreeperPower = Config.setGetInt("psychicCreeperPower", 8);
        ECVars.psychicCreeperRadius = Config.setGetInt("psychicCreeperRadius", 5);
        ECVars.magmaCreeperRadius = Config.setGetInt("magmaCreeperRadius", 3);
        ECVars.ghostCreeperRadius = Config.setGetInt("ghostCreeperRadius", 5);
        ECVars.ghostCreeperChance = Config.setGetInt("ghostCreeperChance", 35);
        ECVars.lightCreeperRadius = Config.setGetInt("lightCreeperRadius", 4);
        ECVars.darkCreeperRadius = Config.setGetInt("darkCreeperRadius", 12);
        ECVars.reverseCreeperRadius = Config.setGetInt("reverseCreeperRadius", 8);
        ECVars.spiderCreeperRadius = Config.setGetInt("spiderCreeperRadius", 12);
        ECVars.windCreeperPower = Config.setGetInt("windCreeperPower", 3);
        ECVars.windCreeperRadius = Config.setGetInt("windCreeperRadius", 5);
        ECVars.hydrogenCreeperRadius = Config.setGetInt("hydrogenCreeperRadius", 64);
        ECVars.stoneCreeperRadius = Config.setGetInt("stoneCreeperRadius", 8);
        ECVars.euCreeperRadius = Config.setGetInt("euCreeperRadius", 3);
        ECVars.rfCreeperRadius = Config.setGetInt("rfCreeperRadius", 3);
        ECVars.mjCreeperRadius = Config.setGetInt("mjCreeperRadius", 3);
    }

    private static int setGetInt(String tag, int id) {
        return config.get("general", tag, id).getInt(id);
    }
}

