/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.ec.core;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.awt.Color;
import net.lomeli.ec.entity.EntityCookieCreeper;
import net.lomeli.ec.entity.EntityDarkCreeper;
import net.lomeli.ec.entity.EntityEarthCreeper;
import net.lomeli.ec.entity.EntityElectricCreeper;
import net.lomeli.ec.entity.EntityEnderCreeper;
import net.lomeli.ec.entity.EntityFireCreeper;
import net.lomeli.ec.entity.EntityFriendlyCreeper;
import net.lomeli.ec.entity.EntityGhostCreeper;
import net.lomeli.ec.entity.EntityHydrogenCreeper;
import net.lomeli.ec.entity.EntityIceCreeper;
import net.lomeli.ec.entity.EntityIllusionCreeper;
import net.lomeli.ec.entity.EntityLightCreeper;
import net.lomeli.ec.entity.EntityMagmaCreeper;
import net.lomeli.ec.entity.EntityPsyhicCreeper;
import net.lomeli.ec.entity.EntityReverseCreeper;
import net.lomeli.ec.entity.EntitySolarCreeper;
import net.lomeli.ec.entity.EntitySpiderCreeper;
import net.lomeli.ec.entity.EntityStoneCreeper;
import net.lomeli.ec.entity.EntityWaterCreeper;
import net.lomeli.ec.entity.EntityWindCreeper;
import net.lomeli.ec.entity.addon.AddonEntities;
import net.lomeli.ec.lib.ECVars;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntityRegistering {
    public static BiomeDictionary.Type[] typeList = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.MOUNTAIN};
    public static int creeperEggGreen = new Color(894731).getRGB();

    public static void loadEntities() {
        EntityRegistering.registerEntity(EntityFireCreeper.class, EntityRegistering.getCreeperName("FireCreeper"), ECVars.fireCreeperID, creeperEggGreen, new Color(227, 111, 24).getRGB());
        EntityRegistering.registerEntity(EntityWaterCreeper.class, EntityRegistering.getCreeperName("WaterCreeper"), ECVars.waterCreeperID, creeperEggGreen, new Color(59, 115, 205).getRGB());
        EntityRegistering.registerEntity(EntityElectricCreeper.class, EntityRegistering.getCreeperName("ElectricCreeper"), ECVars.electricCreeperID, creeperEggGreen, new Color(251, 234, 57).getRGB());
        EntityRegistering.registerEntity(EntityCookieCreeper.class, EntityRegistering.getCreeperName("CookieCreeper"), ECVars.cookieCreeperID, creeperEggGreen, new Color(202, 147, 98).getRGB());
        EntityRegistering.registerEntity(EntityDarkCreeper.class, EntityRegistering.getCreeperName("DarkCreeper"), ECVars.darkCreeperID, creeperEggGreen, new Color(50, 50, 50).getRGB());
        EntityRegistering.registerEntity(EntityLightCreeper.class, EntityRegistering.getCreeperName("LightCreeper"), ECVars.lightCreeperID, creeperEggGreen, new Color(255, 244, 125).getRGB());
        EntityRegistering.registerEntity(EntityEarthCreeper.class, EntityRegistering.getCreeperName("EarthCreeper"), ECVars.earthCreeperID, creeperEggGreen, new Color(93, 50, 0).getRGB());
        EntityRegistering.registerEntity(EntityMagmaCreeper.class, EntityRegistering.getCreeperName("MagmaCreeper"), ECVars.magmaCreeperID, creeperEggGreen, new Color(165, 0, 16).getRGB());
        EntityRegistering.registerEntity(EntityReverseCreeper.class, EntityRegistering.getCreeperName("ReverseCreeper"), ECVars.reverseCreeperID, Color.black.getRGB(), creeperEggGreen);
        EntityRegistering.registerEntity(EntityIceCreeper.class, EntityRegistering.getCreeperName("IceCreeper"), ECVars.iceCreeperID, creeperEggGreen, Color.white.getRGB());
        EntityRegistering.registerEntity(EntityFriendlyCreeper.class, EntityRegistering.getCreeperName("FriendlyCreeper"), ECVars.friendlyCreeperID, creeperEggGreen, new Color(215, 113, 211).getRGB());
        EntityRegistering.registerEntity(EntityGhostCreeper.class, EntityRegistering.getCreeperName("GhostCreeper"), ECVars.ghostCreeperID, 99999, 99999);
        EntityRegistering.registerEntity(EntityIllusionCreeper.class, EntityRegistering.getCreeperName("IllusionCreeper"), ECVars.illusionCreeperID, creeperEggGreen, new Color(158, 158, 158).getRGB());
        EntityRegistering.registerEntity(EntityPsyhicCreeper.class, EntityRegistering.getCreeperName("PsychicCreeper"), ECVars.psychicCreeperID, creeperEggGreen, new Color(121, 51, 142).getRGB());
        EntityRegistering.registerEntity(EntitySpiderCreeper.class, EntityRegistering.getCreeperName("SpiderCreeper"), ECVars.spiderCreeperID, creeperEggGreen, Color.red.getRGB());
        EntityRegistering.registerEntity(EntityWindCreeper.class, EntityRegistering.getCreeperName("WindCreeper"), ECVars.windCreeperID, creeperEggGreen, new Color(95, 250, 203).getRGB());
        EntityRegistering.registerEntity(EntityHydrogenCreeper.class, EntityRegistering.getCreeperName("HydrogenCreeper"), ECVars.hydrogenCreeperID, creeperEggGreen, Color.YELLOW.getRGB());
        EntityRegistering.registerEntity(EntityEnderCreeper.class, EntityRegistering.getCreeperName("EnderCreeper"), ECVars.enderCreeperID, creeperEggGreen, Color.MAGENTA.getRGB());
        EntityRegistering.registerEntity(EntityStoneCreeper.class, EntityRegistering.getCreeperName("StoneCreeper"), ECVars.stoneCreeperID, creeperEggGreen, Color.DARK_GRAY.getRGB());
        EntityRegistering.registerEntity(EntitySolarCreeper.class, EntityRegistering.getCreeperName("SolarCreeper"), ECVars.solarCreeperID, creeperEggGreen, new Color(0, 25, 100).getRGB());
        EntityRegistering.loadSpawn();
        AddonEntities.registerEntities();
    }

    private static void loadSpawn() {
        EntityRegistering.addOverWorldSpawn(EntityFireCreeper.class, ECVars.fireCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityWaterCreeper.class, ECVars.waterCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityElectricCreeper.class, ECVars.electricCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityCookieCreeper.class, ECVars.cookieCreeperSpawn, 1, 2);
        EntityRegistering.addOverWorldSpawn(EntityDarkCreeper.class, ECVars.darkCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityLightCreeper.class, ECVars.lightCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityEarthCreeper.class, ECVars.earthCreeperSpawn, 1, 3);
        EntityRegistering.addNetherSpawn(EntityMagmaCreeper.class, ECVars.magmaCreeperSpawn, 1, 2);
        EntityRegistering.addOverWorldSpawn(EntityReverseCreeper.class, ECVars.reverseCreeperSpawn, 1, 1);
        EntityRegistering.addOverWorldSpawn(EntityIceCreeper.class, ECVars.iceCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityPsyhicCreeper.class, ECVars.psychicCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityIllusionCreeper.class, ECVars.illusionCreeperSpawn, 1, 1);
        EntityRegistering.addOverWorldSpawn(EntitySpiderCreeper.class, ECVars.spiderCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityWindCreeper.class, ECVars.windCreeperSpawn, 1, 2);
        EntityRegistering.addOverWorldSpawn(EntityHydrogenCreeper.class, ECVars.hydrogenCreeperSpawn, 1, 1);
        EntityRegistering.addOverWorldSpawn(EntityEnderCreeper.class, ECVars.enderCreeperSpawn, 1, 2);
        EntityRegistering.addEndSpawn(EntityEnderCreeper.class, ECVars.enderCreeperSpawn * 5, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityStoneCreeper.class, ECVars.stoneCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntitySolarCreeper.class, ECVars.solarCreeperSpawn, 1, 1);
    }

    public static void addOverWorldSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max, EnumCreatureType type) {
        for (int i = 0; i < typeList.length; ++i) {
            EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)type, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]));
        }
    }

    public static void addOverWorldSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        for (int i = 0; i < typeList.length; ++i) {
            EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]));
        }
    }

    public static void addNetherSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
    }

    public static void addEndSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }

    public static String getCreeperName(String mob) {
        return "elementalcreepers:" + mob;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, int bkEggColor, int fgEggColor) {
        int entityID = id;
        if (!ECVars.useStaticIds) {
            entityID = EntityRegistry.findGlobalUniqueEntityId();
        }
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)entityID);
        if (bkEggColor != 99999 && fgEggColor != 99999) {
            EntityList.field_75627_a.put(entityID, new EntityList.EntityEggInfo(entityID, bkEggColor, fgEggColor));
        }
    }
}

