/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.entity.EntityPonyBike;
import noppes.animalbikes.entity.types.EntityRidableFlying;
import noppes.animalbikes.items.ItemPonyBike;

public class EntityPonyFlyingBike
extends EntityRidableFlying {
    int prevX = 0;
    int prevZ = 0;
    int lastBlockX;
    int lastBlockY;
    int lastBlockZ;

    public EntityPonyFlyingBike(World world) {
        super(world);
        this.func_70105_a(0.7f, 1.3f);
    }

    public EntityPonyFlyingBike(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1, d2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    public byte getType() {
        return this.field_70180_af.func_75683_a(18);
    }

    public void setType(byte type) {
        this.field_70180_af.func_75692_b(18, (Object)type);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("PonyType", this.getType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74771_c("PonyType"));
    }

    public boolean standingOnAir() {
        return !this.field_70122_E;
    }

    public double func_70042_X() {
        return 1.1;
    }

    public boolean func_70093_af() {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            return this.field_70153_n.func_70093_af();
        }
        return super.func_70093_af();
    }

    @Override
    public void func_70636_d() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean activate = this.prevZ != z || this.prevX != x;
        activate = this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && activate;
        byte type = this.getType();
        if (activate && (type == 0 || type == 3)) {
            this.earthPony();
        }
        if (activate && (type == 1 || type == 3)) {
            this.unicornPony();
        }
        this.prevX = x;
        this.prevZ = z;
        super.func_70636_d();
    }

    private void unicornPony() {
        if (!this.func_70093_af() && this.field_70170_p.field_72995_K) {
            AnimalBikes.proxy.spawnParticles("rainbow", (EntityLiving)this);
        }
    }

    private void earthPony() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.lastBlockX == x && this.lastBlockY == y && this.lastBlockZ == z) {
            return;
        }
        Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
        if (block == Blocks.field_150346_d) {
            this.field_70170_p.func_147449_b(x, y - 1, z, (Block)Blocks.field_150349_c);
        } else if (block == Blocks.field_150349_c && this.field_70170_p.func_147437_c(x, y, z)) {
            int rand = this.field_70170_p.field_73012_v.nextInt(25);
            if (rand == 0) {
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150328_O);
            }
            if (rand == 12) {
                this.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150327_N);
            }
        }
        this.lastBlockX = x;
        this.lastBlockY = y;
        this.lastBlockZ = z;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item == null || !(item.func_77973_b() instanceof ItemDye) || this.field_70170_p.field_72995_K) {
            return super.func_70085_c(player);
        }
        int i = item.func_77960_j();
        String tex = ItemPonyBike.dyablePonies.get(i);
        if (!ItemPonyBike.textures.contains(tex)) {
            return false;
        }
        int color = ItemPonyBike.textures.indexOf(tex);
        if (this.getColor() == color) {
            return false;
        }
        byte ntype = ItemPonyBike.getType(color);
        byte ctype = this.getType();
        if (ctype < 2 && ntype >= 2) {
            EntityPonyFlyingBike bike = new EntityPonyFlyingBike(this.field_70170_p);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_70109_d(compound);
            bike.func_70020_e(compound);
            bike.setColor(color);
            bike.setType(ntype);
            this.field_70128_L = true;
            this.field_70170_p.func_72838_d((Entity)bike);
        } else if (ctype >= 2 && ntype < 2) {
            EntityPonyBike bike = new EntityPonyBike(this.field_70170_p);
            NBTTagCompound compound = new NBTTagCompound();
            this.func_70109_d(compound);
            bike.func_70020_e(compound);
            bike.setColor(color);
            bike.setType(ntype);
            this.field_70128_L = true;
            this.field_70170_p.func_72838_d((Entity)bike);
        } else {
            this.setColor(color);
            this.setType(ntype);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        }
        return true;
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }
}

