/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.entity;

import awger.AwgerLogger;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntityBoatPart;
import awger.smallboats.entity.EntitySmallBoat;
import awger.smallboats.network.FireGunPacket;
import awger.smallboats.network.PacketDispatcher;
import awger.smallboats.network.SetFlagPacket;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityBoatGun
extends EntityBoatPart {
    private int Index = 0;
    private int Group = 0;
    private int Bore = 1;
    private int Caliber = 10;
    private float Azimuth = 0.0f;
    private float TargetAzimuth = 0.0f;
    private float MinAzimuth = -15.0f;
    private float MaxAzimuth = 15.0f;
    private float Elevation = 0.0f;
    private float TargetElevation = 0.0f;
    private float MinElevation = -5.0f;
    private float MaxElevation = 45.0f;
    private float Runout = 0.0f;
    private float TargetRunout = 0.0f;
    private float MinRunout = 0.0f;
    private float MaxRunout = 0.5f;
    private float dif_Runout = 0.0625f;
    private float dif_Azimuth = 0.5f;
    private float dif_Elevation = 0.5f;
    private int DoorAngle = 0;
    private int TargetDoorAngle = 0;
    private int MinDoorAngle = 0;
    private int MaxDoorAngle = 135;
    public final int f_Retracted = 1;
    public final int f_Loaded = 2;
    public final int f_InBattery = 4;
    public final int f_Trained = 8;
    public final int f_Primed = 16;
    public final int f_Firing = 32;
    public final int f_Loading = 64;
    public final int f_RunningOut = 128;
    public final int f_Training = 256;
    public final int f_Priming = 512;
    public final int f_Retracting = 1024;
    private int Flags = 1;
    public final int ammo_Shot = 1;
    public final int ammo_Shell = 2;
    public final int ammo_BarShot = 3;
    public final int ammo_Cannister = 4;
    private int Ammo = 0;
    private int count_Swab;
    private int count_RamPowder;
    private int count_RamShot;
    private int count_PrickAndPrime;
    private int delay_Swab = 10;
    private int delay_RamPowder = 10;
    private int delay_RamShot = 10;
    private int delay_PrickAndPrime = 10;
    private int delay_Runout = 5;
    private int delay_Priming = 5;
    private int Pause = 0;
    private int Runout_delay = 5;
    private int Priming_delay = 5;

    public EntityBoatGun(World par1World) {
        super(par1World);
        this.hasGun = true;
        this.Flags = 1;
    }

    public EntityBoatGun(EntitySmallBoat _parent, String _name, int _bore, int _caliber, int _index, int _group, int _modelIndex) {
        super(_parent, _name, _modelIndex);
        this.hasGun = true;
        this.Bore = _bore;
        this.Caliber = _caliber;
        this.Index = _index;
        this.Group = _group;
        this.Flags = 1;
    }

    public void setIndex(int _val) {
        this.Index = _val;
    }

    public int updateInt(int _val, int _delta, int _min, int _max) {
        int i = _val + _delta;
        if (i > _max) {
            i = _max;
        } else if (i < _min) {
            i = _min;
        }
        return i;
    }

    public float updateFloat(float _val, float _delta, float _min, float _max) {
        float f = _val + _delta;
        if (f > _max) {
            f = _max;
        } else if (f < _min) {
            f = _min;
        }
        return f;
    }

    public void setAzimuth(float _azimuth, float _min, float _max) {
        this.MinAzimuth = _min;
        this.MaxAzimuth = _max;
        this.TargetAzimuth = this.Azimuth = this.updateFloat(_azimuth, 0.0f, this.MinAzimuth, this.MaxAzimuth);
    }

    public void OpenDoor() {
        AwgerLogger.log(Level.FINE, "** OpenDoor", new Object[0]);
        this.TargetDoorAngle = this.MaxDoorAngle;
    }

    public void CloseDoor() {
        AwgerLogger.log(Level.FINE, "** CloseDoor", new Object[0]);
        this.TargetDoorAngle = this.MinDoorAngle;
    }

    public void Swab() {
        AwgerLogger.log(Level.FINE, "** Swab", new Object[0]);
        this.count_Swab = this.delay_Swab;
    }

    public void RamPowder(int _count) {
        AwgerLogger.log(Level.FINE, "** RamPowder", new Object[0]);
        this.count_RamPowder = this.delay_RamPowder;
    }

    public void RamShot(int _type) {
        AwgerLogger.log(Level.FINE, "** RamShot", new Object[0]);
        this.count_RamShot = this.delay_RamShot;
        this.Ammo = _type;
    }

    public void Load() {
        AwgerLogger.log(Level.FINE, "** Load", new Object[0]);
        if ((this.Flags & 2) == 0) {
            this.Swab();
            this.Flags |= 0x40;
        }
    }

    public void Unload() {
        AwgerLogger.log(Level.FINE, "** Unload", new Object[0]);
        if ((this.Flags & 2) != 0) {
            this.Swab();
            this.Flags &= 0xFFFFFFBF;
        }
    }

    public void RunOut() {
        AwgerLogger.log(Level.FINE, "** RunOut", new Object[0]);
        this.TargetRunout = this.MaxRunout;
        this.Runout_delay = this.delay_Runout;
        this.Flags |= 0x80;
    }

    public void Retract() {
        AwgerLogger.log(Level.FINE, "** Retract", new Object[0]);
        this.TargetRunout = this.MinRunout;
        this.Runout_delay = this.delay_Runout;
        this.Flags &= 0xFFFFFFFB;
        this.Flags |= 0x400;
    }

    public void Train(float _azimuth, float _elevation) {
        AwgerLogger.log(Level.FINE, "** Train", new Object[0]);
        this.TargetAzimuth = this.updateFloat(this.TargetAzimuth, _azimuth, this.MinAzimuth, this.MaxAzimuth);
        this.TargetElevation = this.updateFloat(this.TargetElevation, _elevation, this.MinElevation, this.MaxElevation);
        this.Flags |= 0x100;
    }

    public void PrickAndPrime() {
        AwgerLogger.log(Level.FINE, "** PrickAndPrime", new Object[0]);
        this.Flags |= 0x200;
    }

    public void MakeReady(int _pause) {
        this.Pause = _pause;
        this.OpenDoor();
        this.Load();
        this.RunOut();
        this.Train(0.0f, 0.0f);
        this.PrickAndPrime();
    }

    public void MakeSafe(int _pause) {
        this.Pause = _pause;
        this.Retract();
        this.Unload();
        this.CloseDoor();
    }

    public void Fire(int _group, int _pause) {
        this.Pause = _pause;
        if (this.Group == _group && this.Flags == 30) {
            AwgerLogger.log(Level.FINE, "** Fire %d", _group);
            this.Flags |= 0x20;
        }
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.ParentPersistentID.getMostSignificantBits());
        buffer.writeLong(this.ParentPersistentID.getLeastSignificantBits());
        if (this.Parent != null) {
            buffer.writeInt(this.Parent.func_145782_y());
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(this.ModelIndex);
        buffer.writeInt(this.Bore);
        buffer.writeInt(this.Caliber);
        buffer.writeInt(this.Group);
        buffer.writeFloat(this.posOfsX);
        buffer.writeFloat(this.posOfsY);
        buffer.writeFloat(this.posOfsZ);
        buffer.writeFloat(this.Azimuth);
        buffer.writeFloat(this.MinAzimuth);
        buffer.writeFloat(this.MaxAzimuth);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        this.ParentPersistentID = new UUID(buffer.readLong(), buffer.readLong());
        AwgerLogger.log(Level.FINE, String.format("** child %d parent is %s", this.func_145782_y(), this.ParentPersistentID.toString()), new Object[0]);
        this.parentId = buffer.readInt();
        if (this.parentId != 0) {
            this.setParent((EntitySmallBoat)this.field_70170_p.func_73045_a(this.parentId));
        } else {
            AwgerLogger.log(Level.FINE, String.format("!! received spawn of child %d with invalid parentId", this.func_145782_y()), new Object[0]);
        }
        this.setModelIndex(buffer.readInt());
        this.setBore(buffer.readInt());
        this.setCaliber(buffer.readInt());
        this.setGroup(buffer.readInt());
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        this.setPositionOffsets(x, y, z);
        x = buffer.readFloat();
        y = buffer.readFloat();
        z = buffer.readFloat();
        this.setAzimuth(x, y, z);
        if (this.Parent != null) {
            this.Parent.addPart(this);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        AwgerLogger.fine(SmallBoats.LogLevel, "%s: EntityBoatGun.writeEntityToNBT() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y());
        super.func_70014_b(par1NBTTagCompound);
        if (this.Parent != null) {
            par1NBTTagCompound.func_74768_a("Bore", this.Bore);
            par1NBTTagCompound.func_74768_a("Caliber", this.Caliber);
            par1NBTTagCompound.func_74768_a("Group", this.Group);
            par1NBTTagCompound.func_74776_a("Azimuth", this.Azimuth);
            par1NBTTagCompound.func_74776_a("MinAzimuth", this.MinAzimuth);
            par1NBTTagCompound.func_74776_a("MaxAzimuth", this.MaxAzimuth);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        AwgerLogger.fine(SmallBoats.LogLevel, "%s: EntityBoatChest.readEntityToNBT() for %d", this.field_70170_p.field_72995_K ? "client" : "server", this.func_145782_y());
        super.func_70037_a(par1NBTTagCompound);
        this.setBore(par1NBTTagCompound.func_74762_e("Bore"));
        this.setCaliber(par1NBTTagCompound.func_74762_e("Caliber"));
        this.setGroup(par1NBTTagCompound.func_74762_e("Group"));
        this.Azimuth = par1NBTTagCompound.func_74760_g("Azimuth");
        this.MinAzimuth = par1NBTTagCompound.func_74760_g("MinAzimuth");
        this.MaxAzimuth = par1NBTTagCompound.func_74760_g("MaxAzimuth");
    }

    public void setBore(int _bore) {
        this.Bore = _bore;
    }

    public void setCaliber(int _caliber) {
        this.Caliber = _caliber;
    }

    public void setGroup(int _group) {
        this.Group = _group;
    }

    @Override
    protected void func_70076_C() {
        super.func_70076_C();
    }

    @Override
    public void func_70071_h_() {
        int idelta = 0;
        super.func_70071_h_();
        if (this.Sibling == null) {
            this.ConnectToDoor();
            return;
        }
        if (this.Parent != null) {
            this.field_70177_z = this.Parent.getCompassHeading() + this.Azimuth;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.Pause > 0) {
                --this.Pause;
                return;
            }
            if ((this.Flags & 1) != 0 && this.DoorAngle != this.TargetDoorAngle) {
                idelta = this.DoorAngle > this.TargetDoorAngle ? -7 : (this.DoorAngle < this.TargetDoorAngle ? 7 : 0);
                if (idelta != 0) {
                    this.DoorAngle = this.updateInt(this.DoorAngle, idelta, this.MinDoorAngle, this.MaxDoorAngle);
                }
            } else if ((this.Flags & 0x40) != 0) {
                if (this.count_Swab > 0) {
                    --this.count_Swab;
                } else if (this.count_Swab == 0) {
                    --this.count_Swab;
                    this.RamPowder(0);
                } else if (this.count_RamPowder > 0) {
                    --this.count_RamPowder;
                } else if (this.count_RamPowder == 0) {
                    --this.count_RamPowder;
                    this.RamShot(1);
                } else if (this.count_RamShot > 0) {
                    --this.count_RamShot;
                } else if (this.count_RamShot == 0) {
                    ++this.count_RamShot;
                    this.Flags &= 0xFFFFFFBF;
                    this.Flags |= 2;
                    AwgerLogger.log(Level.INFO, "%s loaded", this.Name);
                }
            } else if ((this.Flags & 0x80) != 0) {
                if (this.Runout < this.TargetRunout) {
                    this.Flags &= 0xFFFFFFFE;
                    --this.Runout_delay;
                    if (this.Runout_delay == 0) {
                        this.Runout = this.updateFloat(this.Runout, this.dif_Runout, this.MinRunout, this.MaxRunout);
                        this.Runout_delay = this.delay_Runout;
                    }
                } else {
                    this.Flags &= 0xFFFFFF7F;
                    this.Flags |= 4;
                    AwgerLogger.log(Level.INFO, "%s in battery", this.Name);
                }
            } else if ((this.Flags & 0x100) != 0) {
                if (this.Azimuth < this.TargetAzimuth) {
                    this.Azimuth += this.dif_Azimuth;
                } else if (this.Azimuth > this.TargetAzimuth) {
                    this.Azimuth -= this.dif_Azimuth;
                } else if (this.Elevation < this.TargetElevation) {
                    this.Elevation += this.dif_Elevation;
                } else if (this.Elevation > this.TargetElevation) {
                    this.Elevation -= this.dif_Elevation;
                } else {
                    this.Flags &= 0xFFFFFEFF;
                    this.Flags |= 8;
                    AwgerLogger.log(Level.INFO, "%s trained", this.Name);
                }
            } else if ((this.Flags & 0x200) != 0) {
                if (this.Priming_delay > 0) {
                    --this.Priming_delay;
                }
                this.Flags &= 0xFFFFFDFF;
                this.Flags |= 0x10;
                AwgerLogger.log(Level.INFO, "%s primed", this.Name);
            } else if ((this.Flags & 0x20) != 0) {
                if ((this.Flags & 2) != 0) {
                    this.Kaboom();
                    this.Flags &= 0xFFFFFFE1;
                    this.TargetRunout = this.MinRunout;
                }
                if (this.Runout > this.TargetRunout) {
                    this.Runout = this.updateFloat(this.Runout, this.dif_Runout * -3.0f, this.MinRunout, this.MaxRunout);
                } else {
                    this.Flags &= 0xFFFFFFDF;
                    this.Flags |= 1;
                    this.MakeReady(3);
                }
            } else if ((this.Flags & 0x400) != 0) {
                if (this.Runout > this.TargetRunout) {
                    --this.Runout_delay;
                    if (this.Runout_delay == 0) {
                        this.Runout -= this.dif_Runout;
                        this.Runout_delay = this.delay_Runout;
                    }
                } else {
                    this.Flags &= 0xFFFFFBFF;
                    this.Flags |= 1;
                }
            }
        }
    }

    public void ConnectToDoor() {
        if (this.Parent == null) {
            AwgerLogger.log(Level.INFO, "!! no parent", new Object[0]);
        } else {
            float x = this.posOfsX;
            float y = this.posOfsY;
            float z = this.posOfsZ;
            if (this.Azimuth > -45.0f && this.Azimuth < 45.0f) {
                x -= 1.0f;
            } else if (this.Azimuth > -135.0f && this.Azimuth < -45.0f) {
                z -= 1.0f;
            } else if (this.Azimuth > 45.0f && this.Azimuth < 135.0f) {
                z += 1.0f;
            } else {
                x += 1.0f;
            }
            EntityBoatPart part = (EntityBoatPart)this.Parent.getChildByOfs(x, y, z);
            if (part != null) {
                part.Sibling = this;
                this.Sibling = part;
            }
        }
    }

    public float getAzimuth() {
        return this.Azimuth;
    }

    public int getDoorAngle() {
        return this.DoorAngle;
    }

    public float getRunout() {
        return this.Runout;
    }

    private void updateClient(int _flags) {
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendToServer(new SetFlagPacket(this.Parent));
        }
    }

    private void Kaboom() {
        AwgerLogger.log(Level.INFO, "** kaboom", new Object[0]);
        double x = this.Sibling.posOfsX;
        double y = this.Sibling.posOfsY;
        double z = this.Sibling.posOfsZ;
        double distance = 3.0;
        if (this.Azimuth > -45.0f && this.Azimuth < 45.0f) {
            x += distance;
        } else if (this.Azimuth < -135.0f || this.Azimuth > 135.0f) {
            x -= distance;
        } else if (this.Azimuth > -135.0f && this.Azimuth < -45.0f) {
            z -= distance;
        } else if (this.Azimuth > 45.0f && this.Azimuth < 135.0f) {
            z += distance;
        }
        double cos1 = Math.cos((double)this.Parent.field_70177_z * Math.PI / 180.0);
        double sin1 = Math.sin((double)this.Parent.field_70177_z * Math.PI / 180.0);
        double cos2 = Math.cos((double)(this.Parent.field_70177_z + 90.0f) * Math.PI / 180.0);
        double sin2 = Math.sin((double)(this.Parent.field_70177_z + 90.0f) * Math.PI / 180.0);
        double xx = cos1 * x + cos2 * z;
        double zz = sin1 * x + sin2 * z;
        PacketDispatcher.sendToServer(new FireGunPacket(this, this.Sibling.field_70165_t + xx, this.Sibling.field_70163_u + y, this.Sibling.field_70161_v + zz));
    }

    public float getCompassHeading() {
        float yaw;
        for (yaw = this.Parent.field_70177_z + this.Azimuth; yaw < 0.0f; yaw += 360.0f) {
        }
        while (yaw > 360.0f) {
            yaw -= 360.0f;
        }
        if ((yaw += 90.0f) > 360.0f) {
            yaw -= 360.0f;
        }
        return -yaw;
    }

    public float getEffectiveElevation() {
        float elevation = this.Elevation;
        float heel = 0.0f;
        float pitch = 0.0f;
        if (this.Parent != null) {
            heel = this.Parent.getHeel();
            pitch = this.Parent.getPitch();
        }
        if (this.Azimuth > -45.0f && this.Azimuth < 45.0f) {
            elevation += pitch;
        } else if (this.Azimuth < -135.0f || this.Azimuth > 135.0f) {
            elevation -= pitch;
        } else if (this.Azimuth > -135.0f && this.Azimuth < -45.0f) {
            elevation += heel;
        } else if (this.Azimuth > 45.0f && this.Azimuth < 135.0f) {
            elevation -= heel;
        }
        return elevation;
    }
}

