/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.network;

import awger.AwgerLogger;
import awger.network.AbstractClientMessageHandler;
import awger.network.AbstractServerMessageHandler;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntitySmallBoat;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class EmbarkPacket
implements IMessage {
    private String playerName;
    private BoatAction action;
    private int childId;
    private byte flag;
    private int BoatID;
    private EntitySmallBoat boat;

    public EmbarkPacket() {
    }

    public EmbarkPacket(EntityPlayer player, EntitySmallBoat boat) {
        this(player, boat, null, 0);
        this.action = BoatAction.DISEMBARK;
    }

    public EmbarkPacket(EntityPlayer player, EntitySmallBoat boat, Entity child, byte flag) {
        this.playerName = player.func_70005_c_();
        this.boat = boat;
        this.BoatID = boat.func_145782_y();
        this.action = BoatAction.EMBARK;
        this.childId = child != null ? child.func_145782_y() : -1;
        this.flag = flag;
    }

    public void fromBytes(ByteBuf buffer) {
        this.action = BoatAction.values()[buffer.readInt() % BoatAction.values().length];
        this.BoatID = buffer.readInt();
        this.childId = buffer.readInt();
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.flag = buffer.readByte();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.action.ordinal());
        buffer.writeInt(this.BoatID);
        buffer.writeInt(this.childId);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerName);
        buffer.writeByte((int)this.flag);
    }

    void disembark(EntityPlayer player, EntityPlayer actor) {
        if (actor == null) {
            AwgerLogger.log(Level.WARNING, String.format("Disembarking player not found while handling packet %s side!", player.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        } else if (this.boat != null) {
            this.boat.disembark(actor);
        }
    }

    void embark(EntityPlayer player, EntityPlayer actor) {
        if (actor == null) {
            AwgerLogger.log(Level.WARNING, String.format("Embarking player not found while handling packet %s side!", player.field_70170_p.field_72995_K ? "client" : "server"), new Object[0]);
        } else if (this.boat != null) {
            this.boat.embark(this.childId, actor, this.flag);
        }
    }

    public static class ServerMessageHandler
    extends AbstractServerMessageHandler {
        @Override
        public IMessage handleServerMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            EmbarkPacket p = (EmbarkPacket)message;
            EntityPlayer actor = player.field_70170_p.func_72924_a(p.playerName);
            p.boat = (EntitySmallBoat)player.field_70170_p.func_73045_a(p.BoatID);
            switch (p.action) {
                case DISEMBARK: {
                    p.disembark(player, actor);
                    break;
                }
                case EMBARK: {
                    p.embark(player, actor);
                }
            }
            return null;
        }
    }

    public static class ClientMessageHandler
    extends AbstractClientMessageHandler {
        @Override
        public IMessage handleClientMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            EmbarkPacket p = (EmbarkPacket)message;
            EntityPlayer actor = player.field_70170_p.func_72924_a(p.playerName);
            p.boat = (EntitySmallBoat)player.field_70170_p.func_73045_a(p.BoatID);
            switch (p.action) {
                case DISEMBARK: {
                    p.disembark(player, actor);
                    break;
                }
                case EMBARK: {
                    p.embark(player, actor);
                }
            }
            return null;
        }
    }

    public static enum BoatAction {
        DISEMBARK,
        EMBARK;

    }
}

