/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.network;

import awger.network.AbstractClientMessageHandler;
import awger.network.AbstractServerMessageHandler;
import awger.smallboats.SmallBoats;
import awger.smallboats.entity.EntityBoatGun;
import awger.smallboats.entity.EntityGunSolidShot;
import awger.smallboats.network.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;

public class FireGunPacket
implements IMessage {
    private int GunID;
    private EntityBoatGun gun;
    private double X;
    private double Y;
    private double Z;

    public FireGunPacket() {
    }

    public FireGunPacket(EntityBoatGun _gun, double _x, double _y, double _z) {
        this.gun = _gun;
        if (this.gun != null) {
            this.GunID = this.gun.func_145782_y();
            this.X = _x;
            this.Y = _y;
            this.Z = _z;
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.GunID = buffer.readInt();
        this.X = buffer.readDouble();
        this.Y = buffer.readDouble();
        this.Z = buffer.readDouble();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.GunID);
        buffer.writeDouble(this.X);
        buffer.writeDouble(this.Y);
        buffer.writeDouble(this.Z);
    }

    public static class ServerMessageHandler
    extends AbstractServerMessageHandler {
        @Override
        public IMessage handleServerMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            FireGunPacket p = (FireGunPacket)message;
            p.gun = (EntityBoatGun)player.field_70170_p.func_73045_a(p.GunID);
            int x = (int)p.X;
            int y = (int)p.Y;
            int z = (int)p.Z;
            Explosion explosion = new Explosion(player.field_70170_p, (Entity)p.gun, (double)x, (double)y, (double)z, 16.0f);
            explosion.field_77286_a = false;
            explosion.field_82755_b = true;
            explosion.func_77279_a(true);
            PacketDispatcher.sendToAllAround(new FireGunPacket(p.gun, p.X, p.Y, p.Z), player, 128.0);
            EntityGunSolidShot ball = new EntityGunSolidShot(player.field_70170_p, p.X, p.Y, p.Z);
            ball.field_70177_z = p.gun.getCompassHeading();
            ball.field_70125_A = p.gun.getEffectiveElevation();
            float velocity = 4.0f;
            ball.field_70159_w = -MathHelper.func_76126_a((float)(ball.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(ball.field_70125_A / 180.0f * (float)Math.PI)) * velocity;
            ball.field_70179_y = -MathHelper.func_76134_b((float)(ball.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(ball.field_70125_A / 180.0f * (float)Math.PI)) * velocity;
            ball.field_70181_x = -MathHelper.func_76126_a((float)(ball.field_70125_A / 180.0f * (float)Math.PI)) * velocity;
            ball.func_70186_c(ball.field_70159_w, ball.field_70181_x, ball.field_70179_y, velocity, 1.0f);
            player.field_70170_p.func_72838_d((Entity)ball);
            return null;
        }
    }

    public static class ClientMessageHandler
    extends AbstractClientMessageHandler {
        @Override
        public IMessage handleClientMessage(IMessage message, MessageContext ctx) {
            EntityPlayer player = SmallBoats.proxy.getPlayerEntity(ctx);
            FireGunPacket p = (FireGunPacket)message;
            p.gun = (EntityBoatGun)player.field_70170_p.func_73045_a(p.GunID);
            int x = (int)p.X;
            int y = (int)p.Y;
            int z = (int)p.Z;
            Explosion explosion = new Explosion(player.field_70170_p, (Entity)p.gun, (double)x, (double)y, (double)z, 16.0f);
            explosion.field_77286_a = false;
            explosion.field_82755_b = true;
            explosion.func_77279_a(true);
            return null;
        }
    }
}

