/*
 * Decompiled with CFR 0.152.
 */
package awger.smallboats.network;

import awger.AwgerLogger;
import awger.smallboats.entity.EntitySmallBoat;
import awger.smallboats.network.AbstractPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public abstract class SmallBoatBasePacket
extends AbstractPacket {
    protected EntitySmallBoat boat;
    private int entityId;

    public SmallBoatBasePacket() {
    }

    public SmallBoatBasePacket(EntitySmallBoat boat) {
        this.boat = boat;
        this.entityId = boat.func_145782_y();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.entityId);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.entityId = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.entityId);
        if (entity instanceof EntitySmallBoat) {
            this.boat = (EntitySmallBoat)entity;
        } else {
            this.boat = null;
            AwgerLogger.log(Level.FINE, "Small boat not found while handling packet client side; something may be wrong", new Object[0]);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(this.entityId);
        if (entity instanceof EntitySmallBoat) {
            this.boat = (EntitySmallBoat)entity;
        } else {
            this.boat = null;
            AwgerLogger.log(Level.FINE, "Small boat not found while handling packet server side; something may be wrong", new Object[0]);
        }
    }
}

