/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import thehippomaster.MutantCreatures.CreeperMinion;
import thehippomaster.MutantCreatures.packet.AbstractPacket;

public class PacketCMOptions
extends AbstractPacket {
    private byte optionsId;
    private int entityId;
    private short nameLength;
    private String minionName;
    private boolean minionBoolean;

    public PacketCMOptions() {
    }

    public PacketCMOptions(int id, CreeperMinion minion, String name) {
        this.optionsId = (byte)id;
        this.entityId = minion.func_145782_y();
        this.nameLength = (short)name.length();
        this.minionName = name;
    }

    public PacketCMOptions(int id, CreeperMinion minion, boolean flag) {
        this.optionsId = (byte)id;
        this.entityId = minion.func_145782_y();
        this.minionBoolean = flag;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeByte((int)this.optionsId);
        buffer.writeInt(this.entityId);
        if (this.optionsId == 0) {
            buffer.writeShort((int)this.nameLength);
            for (int i = 0; i < this.nameLength; ++i) {
                buffer.writeChar((int)this.minionName.charAt(i));
            }
        } else {
            buffer.writeBoolean(this.minionBoolean);
        }
    }

    @Override
    public void decodeFrom(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.optionsId = buffer.readByte();
        this.entityId = buffer.readInt();
        if (this.optionsId == 0) {
            this.nameLength = buffer.readShort();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.nameLength; ++i) {
                sb.append(buffer.readChar());
            }
            this.minionName = sb.toString();
        } else {
            this.minionBoolean = buffer.readBoolean();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        Entity entity = null;
        WorldServer[] worlds = MinecraftServer.func_71276_C().field_71305_c;
        for (int i = 0; i < worlds.length && (entity = worlds[i].func_73045_a(this.entityId)) == null; ++i) {
        }
        CreeperMinion minion = (CreeperMinion)entity;
        if (this.optionsId == 0) {
            minion.setName(this.minionName);
        } else if (this.optionsId == 1) {
            minion.setDestroyBlocks(this.minionBoolean);
        } else if (this.optionsId == 2) {
            minion.setShowName(this.minionBoolean);
        }
    }
}

