/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.MutantCreatures;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import thehippomaster.MutantCreatures.MCHandler;
import thehippomaster.MutantCreatures.MutantCreatures;
import thehippomaster.MutantCreatures.ZombieChunk;
import thehippomaster.MutantCreatures.ZombieResurrect;
import thehippomaster.MutantCreatures.ai.MCAIAttackOnCollide;
import thehippomaster.MutantCreatures.ai.MCAIZombieAttack;
import thehippomaster.MutantCreatures.ai.MCAIZombieMelee;
import thehippomaster.MutantCreatures.ai.MCAIZombieRoar;
import thehippomaster.MutantCreatures.ai.MCAIZombieThrow;
import thehippomaster.MutantCreatures.packet.PacketZombieAttack;

public class MutantZombie
extends EntityMob {
    public int currentAttackID;
    public int animTick;
    public int throwHitTick;
    public int throwFinishTick;
    public int deathTick;
    public int vanishTick;
    public ArrayList<ZombieChunk> meleeGroundList;
    public ArrayList<ZombieResurrect> resurrectList;
    private EntityLivingBase killer;

    public MutantZombie(World world) {
        super(world);
        this.field_70728_aV = 30;
        this.animTick = 0;
        this.throwHitTick = -1;
        this.throwFinishTick = -1;
        this.deathTick = 0;
        this.vanishTick = 0;
        this.field_70158_ak = true;
        this.meleeGroundList = new ArrayList();
        this.resurrectList = new ArrayList();
        this.killer = null;
        this.func_70105_a(1.8f, 2.6f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new MCAIZombieAttack(this, 3.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIZombieMelee(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIZombieRoar(this, 0.35f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new MCAIZombieThrow(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new MCAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2f, false).setMaxAttackTick(0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new MCAIAttackOnCollide((EntityCreature)this, 1.2f, true).setMaxAttackTick(0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, 0, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)3);
        this.field_70180_af.func_75682_a(21, (Object)((byte)(this.field_70146_Z.nextInt(8) == 0 ? 1 : 0)));
    }

    public void setThrowAttackHit(boolean flag) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(flag ? 1 : 0)));
    }

    public void setThrowAttackFinish(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)(flag ? 1 : 0)));
    }

    public void decrementLives() {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(this.getLives() - 1)));
    }

    public void setVillager() {
        this.field_70180_af.func_75692_b(21, (Object)1);
    }

    public boolean getThrowAttackHit() {
        return this.field_70180_af.func_75683_a(16) == 1;
    }

    public boolean getThrowAttackFinish() {
        return this.field_70180_af.func_75683_a(17) == 1;
    }

    public int getLives() {
        return this.field_70180_af.func_75683_a(20);
    }

    public boolean getVillager() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public int func_70658_aO() {
        return 3;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_70069_a(float f) {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected void fixRotation() {
        float f;
        for (f = this.field_70759_as - this.field_70761_aq; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        float f1 = 0.1f;
        if (this.currentAttackID == 1) {
            f1 = 0.2f;
        }
        this.field_70761_aq += f * f1;
    }

    protected void updateAnimation() {
        if (this.currentAttackID != 0) {
            ++this.animTick;
        }
        if (this.currentAttackID == 3) {
            if (this.getThrowAttackHit()) {
                if (this.throwHitTick == -1) {
                    this.throwHitTick = 0;
                }
                ++this.throwHitTick;
            }
            if (this.getThrowAttackFinish()) {
                if (this.throwFinishTick == -1) {
                    this.throwFinishTick = 0;
                }
                ++this.throwFinishTick;
            }
        } else {
            this.throwHitTick = -1;
            this.throwFinishTick = -1;
        }
    }

    protected void updateMeleeGrounds() {
        if (!this.meleeGroundList.isEmpty()) {
            ZombieChunk chunk = this.meleeGroundList.remove(0);
            if (chunk.spawnParticles) {
                int id = Block.func_149682_b((Block)this.field_70170_p.func_147439_a(chunk.posX, chunk.posY, chunk.posZ));
                int data = this.field_70170_p.func_72805_g(chunk.posX, chunk.posY, chunk.posZ);
                this.field_70170_p.func_72926_e(2001, chunk.posX, chunk.posY + 1, chunk.posZ, id + (data << 12));
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)chunk.posX, (double)(chunk.posY + 1), (double)chunk.posZ, (double)(chunk.posX + 1), (double)(chunk.posY + 2), (double)(chunk.posZ + 1));
            if (chunk.first) {
                double addScale = this.field_70146_Z.nextDouble() * 0.75;
                box.func_72314_b(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            ArrayList<Entity> list = MutantCreatures.getCollidingEntities((Entity)this, this.field_70170_p, box);
            for (Entity entity : list) {
                if (!(entity instanceof EntityLivingBase)) continue;
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(6 + this.field_70146_Z.nextInt(3)));
                if (this.field_70146_Z.nextInt(5) != 0) continue;
                living.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 160, 1));
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.fixRotation();
        this.updateAnimation();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
            this.func_70624_b(null);
        }
        if (this.deathTick <= 0 && this.field_70173_aa % 100 == 0 && !this.field_70170_p.func_72935_r()) {
            this.func_70691_i(2.0f);
        }
        this.updateMeleeGrounds();
        for (int i = this.resurrectList.size() - 1; i >= 0; --i) {
            ZombieResurrect zr = this.resurrectList.get(i);
            if (zr.update(this)) continue;
            this.resurrectList.remove(zr);
        }
        if (this.func_110143_aJ() > 0.0f) {
            this.deathTick = 0;
            this.vanishTick = 0;
        }
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        this.field_70181_x += (double)0.06f;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack stack;
        if (this.deathTick > 0 && (stack = player.field_71071_by.func_70448_g()) != null && (stack.func_77973_b() == Items.field_151033_d || stack.func_77973_b() == Items.field_151059_bz)) {
            this.func_70015_d(8);
        }
        return super.func_70085_c(player);
    }

    public void attackEntityAtDistSq(EntityLivingBase living, float f) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.currentAttackID == 0 && this.field_70122_E && this.field_70146_Z.nextInt(20) == 0) {
                this.sendAttackPacket(1);
            }
            if (this.currentAttackID == 0 && f < 1.0f && this.field_70146_Z.nextInt(125) == 0) {
                this.sendAttackPacket(3);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.currentAttackID == 0 && this.field_70146_Z.nextInt(5) == 0) {
                this.sendAttackPacket(3);
            }
            if (this.currentAttackID == 0 && this.field_70122_E) {
                this.sendAttackPacket(1);
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        float dmg = f;
        Entity entity = source.func_76346_g();
        if (entity != null && this.currentAttackID == 3 && entity == this.func_70638_az()) {
            return false;
        }
        return super.func_70097_a(source, dmg);
    }

    public void func_70653_a(Entity entity, float dmg, double d, double d1) {
    }

    public int maxDeathTime() {
        return 140;
    }

    public int maxVanishTime() {
        return 100;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        Entity entity = source.func_76346_g();
        if (!this.field_70170_p.field_72995_K && entity != null && entity instanceof EntityLivingBase) {
            this.killer = (EntityLivingBase)entity;
        }
    }

    protected void func_70609_aI() {
        ++this.deathTick;
        this.vanishTick = this.func_70027_ad() ? ++this.vanishTick : Math.max(0, this.vanishTick - 1);
        if (this.deathTick >= this.maxDeathTime()) {
            float f = this.deathTick - this.vanishTick;
            int h = (int)(40.0f * f / (float)this.maxDeathTime());
            this.field_70725_aQ = 0;
            this.deathTick = 0;
            this.vanishTick = 0;
            this.func_70066_B();
            if (!this.field_70170_p.field_72995_K) {
                this.decrementLives();
            }
            this.func_70606_j(h);
            if (!this.field_70170_p.field_72995_K && this.killer != null) {
                this.func_70624_b(this.killer);
                this.func_70604_c(this.killer);
            }
        }
        if (this.vanishTick >= this.maxVanishTime() || this.getLives() <= 0 && this.deathTick > 25) {
            if (!this.field_70170_p.field_72995_K) {
                if ((this.field_70718_bc > 0 || this.func_70684_aJ()) && !this.func_70631_g_()) {
                    int k;
                    for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= k) {
                        k = EntityXPOrb.func_70527_a((int)i);
                        this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, k));
                    }
                }
                this.func_145779_a(MutantCreatures.hulkHammer, 1);
                MCHandler.spawnFlamesAtEntity((Entity)this, 30);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && MutantCreatures.getRandomSpawnChance();
    }

    public float func_70013_c(float f) {
        float f1 = ((float)this.field_70737_aN - f) / (float)this.field_70738_aO;
        return super.func_70013_c(f) * f1;
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74768_a("deathTick", this.deathTick);
        tagcompound.func_74768_a("vanishTick", this.vanishTick);
        tagcompound.func_74757_a("villager", this.getVillager());
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.deathTick = tagcompound.func_74762_e("deathTick");
        this.vanishTick = tagcompound.func_74762_e("vanishTick");
        if (tagcompound.func_74767_n("villager")) {
            this.setVillager();
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    protected String func_70639_aQ() {
        return "MutantCreatures:mutantzombie.living";
    }

    protected String func_70621_aR() {
        return "MutantCreatures:mutantzombie.snarl";
    }

    protected String func_70673_aS() {
        return "MutantCreatures:mutantzombie.snarl";
    }

    public void sendAttackPacket(int id) {
        if (MutantCreatures.isEffectiveClient()) {
            return;
        }
        this.currentAttackID = id;
        MutantCreatures.packetPipeline.sendToAll(new PacketZombieAttack(id, this));
    }
}

