/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import portablejim.veinminer.network.packet.IPacket;
import portablejim.veinminer.server.MinerServer;
import portablejim.veinminer.util.PlayerStatus;

public class PacketClientPresent
implements IPacket {
    public short mode;

    public PacketClientPresent() {
        this.mode = 0;
    }

    public PacketClientPresent(int clientMode) {
        switch (clientMode) {
            case 1: 
            case 2: {
                this.mode = 1;
                break;
            }
            case 3: {
                this.mode = (short)2;
                break;
            }
            case 4: {
                this.mode = (short)3;
                break;
            }
            default: {
                this.mode = 0;
            }
        }
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        buffer.writeShort((int)this.mode);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        this.mode = buffer.readShort();
    }

    @Override
    public void handleClientSide(EntityClientPlayerMP player) {
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        UUID playerName = player.func_110124_au();
        MinerServer.instance.addClientPlayer(playerName);
        switch (this.mode) {
            case 2: {
                MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.SNEAK_ACTIVE);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.sneak", new Object[0]));
                break;
            }
            case 3: {
                MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.SNEAK_INACTIVE);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.nosneak", new Object[0]));
                break;
            }
            case 1: {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("mod.veinminer.preferredmode.auto", new Object[0]));
            }
            default: {
                MinerServer.instance.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
            }
        }
    }
}

