/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.floatingruins.ConfigElement;
import bspkrs.floatingruins.FRLog;
import bspkrs.floatingruins.WorldGenFloatingIsland;
import bspkrs.floatingruins.fml.Reference;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;

public final class FloatingRuins {
    private static final boolean enabledDefault = true;
    public static boolean enabled = true;
    private static final boolean allowDebugLoggingDefault = false;
    public static boolean allowDebugLogging = false;
    private static final boolean allowInSuperFlatDefault = false;
    public static boolean allowInSuperFlat = false;
    private static final boolean allowMultiMobSpawnersDefault = true;
    public static boolean allowMultiMobSpawners = true;
    private static final boolean harderDungeonsDefault = false;
    public static boolean harderDungeons = false;
    private static final int rarityDefault = 800;
    public static int rarity = 800;
    private static final int rarityDungeonDefault = 1;
    public static int rarityDungeon = 1;
    private static final int heightMaxDefault = 225;
    public static int heightMax = 225;
    private static final int heightMeanDefault = 100;
    public static int heightMean = 100;
    private static final int heightMinDefault = 80;
    public static int heightMin = 80;
    private static final int heightNormDefault = 3;
    public static int heightNorm = 3;
    private static final int radiusMaxDefault = 23;
    public static int radiusMax = 23;
    private static final int radiusMeanDefault = 10;
    public static int radiusMean = 10;
    private static final int radiusMinDefault = 7;
    public static int radiusMin = 7;
    private static final int radiusNormDefault = 5;
    public static int radiusNorm = 5;
    private static final int depthMaxDefault = 45;
    public static int depthMax = 45;
    private static final int depthMeanDefault = 9;
    public static int depthMean = 9;
    private static final int depthMinDefault = 5;
    public static int depthMin = 5;
    private static final int depthNormDefault = 3;
    public static int depthNorm = 3;
    private static final int shapeSpheroidWeightDefault = 21;
    public static int shapeSpheroidWeight = 21;
    private static final int shapeConeWeightDefault = 14;
    public static int shapeConeWeight = 14;
    private static final int shapeJetsonsWeightDefault = 1;
    public static int shapeJetsonsWeight = 1;
    private static final int shapeStalactiteWeightDefault = 0;
    public static int shapeStalactiteWeight = 0;
    private static final int numberOfItemsDefault = 4;
    public static int numberOfItems = 4;
    private static final String blockIDBlacklistDefault;
    public static String blockIDBlacklist;
    private static final String dimensionIDBlacklistDefault = "-1;1";
    public static String dimensionIDBlacklist;
    private static final String biomeIDBlacklistDefault = "7;8;9;11;15;16;";
    public static String biomeIDBlacklist;
    private static final boolean useCustomItemListDefault = false;
    public static boolean useCustomItemList;
    private static final String stringOfIdsDefault;
    public static String stringOfIds;
    private static final String spawnerDefaultDefault = "Creeper, Skeleton, Zombie, CaveSpider";
    public static String spawnerDefault;
    private static final String spawnerDesertDefault = "WitherSkeleton, PigZombie, Blaze";
    public static String spawnerDesert;
    private static final String spawnerForestDefault = "Witch, CaveSpider";
    public static String spawnerForest;
    private static final String spawnerPlainsDefault = "Spider, Zombie, Creeper";
    public static String spawnerPlains;
    private static final String spawnerSwamplandDefault = "Creeper, CaveSpider, Witch";
    public static String spawnerSwampland;
    private static final String spawnerTaigaDefault = "Zombie, Creeper, Wolf";
    public static String spawnerTaiga;
    private static final String spawnerHillsDefault = "Default";
    public static String spawnerHills;
    private static final String spawnerOceanDefault = "Silverfish, ChargedCreeper";
    public static String spawnerOcean;
    private static final String spawnerRiverDefault = "Silverfish, Creeper";
    public static String spawnerRiver;
    private static final String spawnerJungleDefault = "Skeleton, CaveSpider";
    public static String spawnerJungle;
    private static final String spawnerIceBiomesDefault = "Zombie, Skeleton, Wolf";
    public static String spawnerIceBiomes;
    private static final String spawnerMushroomDefault = "MushroomCow";
    public static String spawnerMushroom;
    private static final String spawnerNearLavaDefault = "Blaze, LavaSlime, WitherSkeleton, PigZombie";
    public static String spawnerNearLava;
    private static int chunksToRetry;

    public static void initConfig(File file) {
        Reference.config = new Configuration(file, "1.0");
        if (!"1.0".equals(Reference.config.getLoadedConfigVersion())) {
            FRLog.info("Your FloatingRuins config file is out of date and will be altered.", new Object[0]);
            for (ConfigElement ce : ConfigElement.values()) {
                if (!Reference.config.moveProperty("general", ce.key(), ce.ctgy())) continue;
                FRLog.debug("Property %s moved from %s to %s", ce.key(), "general", ce.ctgy());
            }
        }
        FloatingRuins.syncConfig(true);
    }

    public static void syncConfig(boolean init) {
        if (!init) {
            Reference.config.load();
        }
        Reference.config.setCategoryComment("general", "ATTENTION: Editing this file manually is no longer necessary. \nOn the Mods list screen select the entry for FloatingRuins, then click the Config button to modify these settings.");
        HashMap orderedKeys = new HashMap();
        orderedKeys.put("general", new ArrayList());
        orderedKeys.put("general.island_settings", new ArrayList());
        orderedKeys.put("general.island_settings.island_size", new ArrayList());
        orderedKeys.put("general.dungeon_settings", new ArrayList());
        enabled = Reference.config.getBoolean(ConfigElement.ENABLED.key(), ConfigElement.ENABLED.ctgy(), true, ConfigElement.ENABLED.desc(), ConfigElement.ENABLED.languageKey());
        ((List)orderedKeys.get(ConfigElement.ENABLED.ctgy())).add(ConfigElement.ENABLED.key());
        allowDebugLogging = Reference.config.getBoolean(ConfigElement.ALLOW_DEBUG_LOGGING.key(), ConfigElement.ALLOW_DEBUG_LOGGING.ctgy(), false, ConfigElement.ALLOW_DEBUG_LOGGING.desc(), ConfigElement.ALLOW_DEBUG_LOGGING.languageKey());
        ((List)orderedKeys.get(ConfigElement.ALLOW_DEBUG_LOGGING.ctgy())).add(ConfigElement.ALLOW_DEBUG_LOGGING.key());
        allowInSuperFlat = Reference.config.getBoolean(ConfigElement.ALLOW_IN_SUPERFLAT.key(), ConfigElement.ALLOW_IN_SUPERFLAT.ctgy(), false, ConfigElement.ALLOW_IN_SUPERFLAT.desc(), ConfigElement.ALLOW_IN_SUPERFLAT.languageKey());
        ((List)orderedKeys.get(ConfigElement.ALLOW_IN_SUPERFLAT.ctgy())).add(ConfigElement.ALLOW_IN_SUPERFLAT.key());
        allowMultiMobSpawners = Reference.config.getBoolean(ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.key(), ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.ctgy(), true, ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.desc(), ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.languageKey());
        ((List)orderedKeys.get(ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.ctgy())).add(ConfigElement.ALLOW_MULTI_MOB_SPAWNERS.key());
        rarity = Reference.config.getInt(ConfigElement.RARITY.key(), ConfigElement.RARITY.ctgy(), 800, 1, Integer.MAX_VALUE, ConfigElement.RARITY.desc(), ConfigElement.RARITY.languageKey());
        ((List)orderedKeys.get(ConfigElement.RARITY.ctgy())).add(ConfigElement.RARITY.key());
        rarityDungeon = Reference.config.getInt(ConfigElement.RARITY_DUNGEON.key(), ConfigElement.RARITY_DUNGEON.ctgy(), 1, 1, Integer.MAX_VALUE, ConfigElement.RARITY_DUNGEON.desc(), ConfigElement.RARITY_DUNGEON.languageKey());
        ((List)orderedKeys.get(ConfigElement.RARITY_DUNGEON.ctgy())).add(ConfigElement.RARITY_DUNGEON.key());
        harderDungeons = Reference.config.getBoolean(ConfigElement.HARDER_DUNGEONS.key(), ConfigElement.HARDER_DUNGEONS.ctgy(), false, ConfigElement.HARDER_DUNGEONS.desc(), ConfigElement.HARDER_DUNGEONS.languageKey());
        ((List)orderedKeys.get(ConfigElement.HARDER_DUNGEONS.ctgy())).add(ConfigElement.HARDER_DUNGEONS.key());
        heightMean = Reference.config.getInt(ConfigElement.HEIGHT_MEAN.key(), ConfigElement.HEIGHT_MEAN.ctgy(), 100, heightMin, heightMax, ConfigElement.HEIGHT_MEAN.desc(), ConfigElement.HEIGHT_MEAN.languageKey());
        ((List)orderedKeys.get(ConfigElement.HEIGHT_MEAN.ctgy())).add(ConfigElement.HEIGHT_MEAN.key());
        heightMin = Reference.config.getInt(ConfigElement.HEIGHT_MIN.key(), ConfigElement.HEIGHT_MIN.ctgy(), 80, 80, heightMean, ConfigElement.HEIGHT_MIN.desc(), ConfigElement.HEIGHT_MIN.languageKey());
        ((List)orderedKeys.get(ConfigElement.HEIGHT_MIN.ctgy())).add(ConfigElement.HEIGHT_MIN.key());
        heightMax = Reference.config.getInt(ConfigElement.HEIGHT_MAX.key(), ConfigElement.HEIGHT_MAX.ctgy(), 225, heightMean, 240, ConfigElement.HEIGHT_MAX.desc(), ConfigElement.HEIGHT_MAX.languageKey());
        ((List)orderedKeys.get(ConfigElement.HEIGHT_MAX.ctgy())).add(ConfigElement.HEIGHT_MAX.key());
        heightNorm = Reference.config.getInt(ConfigElement.HEIGHT_NORM.key(), ConfigElement.HEIGHT_NORM.ctgy(), 3, 1, 10, ConfigElement.HEIGHT_NORM.desc(), ConfigElement.HEIGHT_NORM.languageKey());
        ((List)orderedKeys.get(ConfigElement.HEIGHT_NORM.ctgy())).add(ConfigElement.HEIGHT_NORM.key());
        radiusMean = Reference.config.getInt(ConfigElement.RADIUS_MEAN.key(), ConfigElement.RADIUS_MEAN.ctgy(), 10, radiusMin, radiusMax, ConfigElement.RADIUS_MEAN.desc(), ConfigElement.RADIUS_MEAN.languageKey());
        ((List)orderedKeys.get(ConfigElement.RADIUS_MEAN.ctgy())).add(ConfigElement.RADIUS_MEAN.key());
        radiusMax = Reference.config.getInt(ConfigElement.RADIUS_MAX.key(), ConfigElement.RADIUS_MAX.ctgy(), 23, radiusMean, 50, ConfigElement.RADIUS_MAX.desc(), ConfigElement.RADIUS_MAX.languageKey());
        ((List)orderedKeys.get(ConfigElement.RADIUS_MAX.ctgy())).add(ConfigElement.RADIUS_MAX.key());
        radiusMin = Reference.config.getInt(ConfigElement.RADIUS_MIN.key(), ConfigElement.RADIUS_MIN.ctgy(), 7, 5, radiusMean, ConfigElement.RADIUS_MIN.desc(), ConfigElement.RADIUS_MIN.languageKey());
        ((List)orderedKeys.get(ConfigElement.RADIUS_MIN.ctgy())).add(ConfigElement.RADIUS_MIN.key());
        radiusNorm = Reference.config.getInt(ConfigElement.RADIUS_NORM.key(), ConfigElement.RADIUS_NORM.ctgy(), 5, 1, 10, ConfigElement.RADIUS_NORM.desc(), ConfigElement.RADIUS_NORM.languageKey());
        ((List)orderedKeys.get(ConfigElement.RADIUS_NORM.ctgy())).add(ConfigElement.RADIUS_NORM.key());
        depthMean = Reference.config.getInt(ConfigElement.DEPTH_MEAN.key(), ConfigElement.DEPTH_MEAN.ctgy(), 9, depthMin, depthMax, ConfigElement.DEPTH_MEAN.desc(), ConfigElement.DEPTH_MEAN.languageKey());
        ((List)orderedKeys.get(ConfigElement.DEPTH_MEAN.ctgy())).add(ConfigElement.DEPTH_MEAN.key());
        depthMin = Reference.config.getInt(ConfigElement.DEPTH_MIN.key(), ConfigElement.DEPTH_MIN.ctgy(), 5, 5, depthMean, ConfigElement.DEPTH_MIN.desc(), ConfigElement.DEPTH_MIN.languageKey());
        ((List)orderedKeys.get(ConfigElement.DEPTH_MIN.ctgy())).add(ConfigElement.DEPTH_MIN.key());
        depthMax = Reference.config.getInt(ConfigElement.DEPTH_MAX.key(), ConfigElement.DEPTH_MAX.ctgy(), 45, depthMean, 45, ConfigElement.DEPTH_MAX.desc(), ConfigElement.DEPTH_MAX.languageKey());
        ((List)orderedKeys.get(ConfigElement.DEPTH_MAX.ctgy())).add(ConfigElement.DEPTH_MAX.key());
        depthNorm = Reference.config.getInt(ConfigElement.DEPTH_NORM.key(), ConfigElement.DEPTH_NORM.ctgy(), 3, 1, 10, ConfigElement.DEPTH_NORM.desc(), ConfigElement.DEPTH_NORM.languageKey());
        ((List)orderedKeys.get(ConfigElement.DEPTH_NORM.ctgy())).add(ConfigElement.DEPTH_NORM.key());
        shapeSpheroidWeight = Reference.config.getInt(ConfigElement.SHAPE_SPHEROID_WEIGHT.key(), ConfigElement.SHAPE_SPHEROID_WEIGHT.ctgy(), 21, 0, Integer.MAX_VALUE, ConfigElement.SHAPE_SPHEROID_WEIGHT.desc(), ConfigElement.SHAPE_SPHEROID_WEIGHT.languageKey());
        ((List)orderedKeys.get(ConfigElement.SHAPE_SPHEROID_WEIGHT.ctgy())).add(ConfigElement.SHAPE_SPHEROID_WEIGHT.key());
        shapeConeWeight = Reference.config.getInt(ConfigElement.SHAPE_CONE_WEIGHT.key(), ConfigElement.SHAPE_CONE_WEIGHT.ctgy(), 14, 0, Integer.MAX_VALUE, ConfigElement.SHAPE_CONE_WEIGHT.desc(), ConfigElement.SHAPE_CONE_WEIGHT.languageKey());
        ((List)orderedKeys.get(ConfigElement.SHAPE_CONE_WEIGHT.ctgy())).add(ConfigElement.SHAPE_CONE_WEIGHT.key());
        shapeJetsonsWeight = Reference.config.getInt(ConfigElement.SHAPE_JETSONS_WEIGHT.key(), ConfigElement.SHAPE_JETSONS_WEIGHT.ctgy(), 1, 0, Integer.MAX_VALUE, ConfigElement.SHAPE_JETSONS_WEIGHT.desc(), ConfigElement.SHAPE_JETSONS_WEIGHT.languageKey());
        ((List)orderedKeys.get(ConfigElement.SHAPE_JETSONS_WEIGHT.ctgy())).add(ConfigElement.SHAPE_JETSONS_WEIGHT.key());
        useCustomItemList = Reference.config.getBoolean(ConfigElement.USE_CUSTOM_ITEM_LIST.key(), ConfigElement.USE_CUSTOM_ITEM_LIST.ctgy(), false, ConfigElement.USE_CUSTOM_ITEM_LIST.desc(), ConfigElement.USE_CUSTOM_ITEM_LIST.languageKey());
        ((List)orderedKeys.get(ConfigElement.USE_CUSTOM_ITEM_LIST.ctgy())).add(ConfigElement.USE_CUSTOM_ITEM_LIST.key());
        stringOfIds = Reference.config.getString(ConfigElement.STRING_OF_IDS.key(), ConfigElement.STRING_OF_IDS.ctgy(), stringOfIdsDefault, ConfigElement.STRING_OF_IDS.desc(), ConfigElement.STRING_OF_IDS.languageKey());
        ((List)orderedKeys.get(ConfigElement.STRING_OF_IDS.ctgy())).add(ConfigElement.STRING_OF_IDS.key());
        numberOfItems = Reference.config.getInt(ConfigElement.NUMBER_OF_ITEMS.key(), ConfigElement.NUMBER_OF_ITEMS.ctgy(), 4, 1, 27, ConfigElement.NUMBER_OF_ITEMS.desc(), ConfigElement.NUMBER_OF_ITEMS.languageKey());
        ((List)orderedKeys.get(ConfigElement.NUMBER_OF_ITEMS.ctgy())).add(ConfigElement.NUMBER_OF_ITEMS.key());
        blockIDBlacklist = Reference.config.getString(ConfigElement.BLOCK_ID_BLACKLIST.key(), ConfigElement.BLOCK_ID_BLACKLIST.ctgy(), blockIDBlacklistDefault, ConfigElement.BLOCK_ID_BLACKLIST.desc(), ConfigElement.BLOCK_ID_BLACKLIST.languageKey());
        ((List)orderedKeys.get(ConfigElement.BLOCK_ID_BLACKLIST.ctgy())).add(ConfigElement.BLOCK_ID_BLACKLIST.key());
        dimensionIDBlacklist = Reference.config.getString(ConfigElement.DIMENSION_ID_BLACKLIST.key(), ConfigElement.DIMENSION_ID_BLACKLIST.ctgy(), dimensionIDBlacklistDefault, ConfigElement.DIMENSION_ID_BLACKLIST.desc(), ConfigElement.DIMENSION_ID_BLACKLIST.languageKey());
        ((List)orderedKeys.get(ConfigElement.DIMENSION_ID_BLACKLIST.ctgy())).add(ConfigElement.DIMENSION_ID_BLACKLIST.key());
        biomeIDBlacklist = Reference.config.getString(ConfigElement.BIOME_ID_BLACKLIST.key(), ConfigElement.BIOME_ID_BLACKLIST.ctgy(), biomeIDBlacklistDefault, ConfigElement.BIOME_ID_BLACKLIST.desc(), ConfigElement.BIOME_ID_BLACKLIST.languageKey());
        ((List)orderedKeys.get(ConfigElement.BIOME_ID_BLACKLIST.ctgy())).add(ConfigElement.BIOME_ID_BLACKLIST.key());
        spawnerDefault = Reference.config.getString(ConfigElement.SPAWNER_DEFAULT.key(), ConfigElement.SPAWNER_DEFAULT.ctgy(), spawnerDefaultDefault, ConfigElement.SPAWNER_DEFAULT.desc(), ConfigElement.SPAWNER_DEFAULT.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_DEFAULT.ctgy())).add(ConfigElement.SPAWNER_DEFAULT.key());
        spawnerDesert = Reference.config.getString(ConfigElement.SPAWNER_DESERT.key(), ConfigElement.SPAWNER_DESERT.ctgy(), spawnerDesertDefault, ConfigElement.SPAWNER_DESERT.desc(), ConfigElement.SPAWNER_DESERT.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_DESERT.ctgy())).add(ConfigElement.SPAWNER_DESERT.key());
        spawnerForest = Reference.config.getString(ConfigElement.SPAWNER_FOREST.key(), ConfigElement.SPAWNER_FOREST.ctgy(), spawnerForestDefault, ConfigElement.SPAWNER_FOREST.desc(), ConfigElement.SPAWNER_FOREST.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_FOREST.ctgy())).add(ConfigElement.SPAWNER_FOREST.key());
        spawnerHills = Reference.config.getString(ConfigElement.SPAWNER_HILLS.key(), ConfigElement.SPAWNER_HILLS.ctgy(), spawnerHillsDefault, ConfigElement.SPAWNER_HILLS.desc(), ConfigElement.SPAWNER_HILLS.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_HILLS.ctgy())).add(ConfigElement.SPAWNER_HILLS.key());
        spawnerIceBiomes = Reference.config.getString(ConfigElement.SPAWNER_ICE_BIOMES.key(), ConfigElement.SPAWNER_ICE_BIOMES.ctgy(), spawnerIceBiomesDefault, ConfigElement.SPAWNER_ICE_BIOMES.desc(), ConfigElement.SPAWNER_ICE_BIOMES.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_ICE_BIOMES.ctgy())).add(ConfigElement.SPAWNER_ICE_BIOMES.key());
        spawnerJungle = Reference.config.getString(ConfigElement.SPAWNER_JUNGLE.key(), ConfigElement.SPAWNER_JUNGLE.ctgy(), spawnerJungleDefault, ConfigElement.SPAWNER_JUNGLE.desc(), ConfigElement.SPAWNER_JUNGLE.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_JUNGLE.ctgy())).add(ConfigElement.SPAWNER_JUNGLE.key());
        spawnerMushroom = Reference.config.getString(ConfigElement.SPAWNER_MUSHROOM.key(), ConfigElement.SPAWNER_MUSHROOM.ctgy(), spawnerMushroomDefault, ConfigElement.SPAWNER_MUSHROOM.desc(), ConfigElement.SPAWNER_MUSHROOM.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_MUSHROOM.ctgy())).add(ConfigElement.SPAWNER_MUSHROOM.key());
        spawnerOcean = Reference.config.getString(ConfigElement.SPAWNER_OCEAN.key(), ConfigElement.SPAWNER_OCEAN.ctgy(), spawnerOceanDefault, ConfigElement.SPAWNER_OCEAN.desc(), ConfigElement.SPAWNER_OCEAN.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_OCEAN.ctgy())).add(ConfigElement.SPAWNER_OCEAN.key());
        spawnerPlains = Reference.config.getString(ConfigElement.SPAWNER_PLAINS.key(), ConfigElement.SPAWNER_PLAINS.ctgy(), spawnerPlainsDefault, ConfigElement.SPAWNER_PLAINS.desc(), ConfigElement.SPAWNER_PLAINS.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_PLAINS.ctgy())).add(ConfigElement.SPAWNER_PLAINS.key());
        spawnerRiver = Reference.config.getString(ConfigElement.SPAWNER_RIVER.key(), ConfigElement.SPAWNER_RIVER.ctgy(), spawnerRiverDefault, ConfigElement.SPAWNER_RIVER.desc(), ConfigElement.SPAWNER_RIVER.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_RIVER.ctgy())).add(ConfigElement.SPAWNER_RIVER.key());
        spawnerSwampland = Reference.config.getString(ConfigElement.SPAWNER_SWAMPLAND.key(), ConfigElement.SPAWNER_SWAMPLAND.ctgy(), spawnerSwamplandDefault, ConfigElement.SPAWNER_SWAMPLAND.desc(), ConfigElement.SPAWNER_SWAMPLAND.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_SWAMPLAND.ctgy())).add(ConfigElement.SPAWNER_SWAMPLAND.key());
        spawnerTaiga = Reference.config.getString(ConfigElement.SPAWNER_TAIGA.key(), ConfigElement.SPAWNER_TAIGA.ctgy(), spawnerTaigaDefault, ConfigElement.SPAWNER_TAIGA.desc(), ConfigElement.SPAWNER_TAIGA.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_TAIGA.ctgy())).add(ConfigElement.SPAWNER_TAIGA.key());
        spawnerNearLava = Reference.config.getString(ConfigElement.SPAWNER_NEAR_LAVA.key(), ConfigElement.SPAWNER_NEAR_LAVA.ctgy(), spawnerNearLavaDefault, ConfigElement.SPAWNER_NEAR_LAVA.desc(), ConfigElement.SPAWNER_NEAR_LAVA.languageKey());
        ((List)orderedKeys.get(ConfigElement.SPAWNER_NEAR_LAVA.ctgy())).add(ConfigElement.SPAWNER_NEAR_LAVA.key());
        for (Map.Entry entry : orderedKeys.entrySet()) {
            Reference.config.setCategoryPropertyOrder((String)entry.getKey(), (List)entry.getValue());
            Reference.config.setCategoryLanguageKey((String)entry.getKey(), "bspkrs.fr.configgui.ctgy." + (String)entry.getKey());
        }
        Reference.config.save();
    }

    public static void generateSurface(World world, Random random, int x, int z, boolean isWorldGen) {
        if ((world.func_72912_H().func_76067_t() != WorldType.field_77138_c || allowInSuperFlat) && !CommonUtils.isIDInList((int)world.field_73011_w.field_76574_g, (String)dimensionIDBlacklist)) {
            random = FloatingRuins.getRandom(world, x, z);
            int tgtY = FloatingRuins.getWeightedInt(heightMin, heightMean, heightMax, heightNorm, random);
            if (isWorldGen) {
                x += random.nextInt(16);
                z += random.nextInt(16);
            }
            WorldGenFloatingIsland islandGenerator = FloatingRuins.getFloatingIslandGenerator(world, random, x, tgtY, z);
            if (!isWorldGen || random.nextInt(rarity) == 0) {
                String debug = "";
                int biomeID = FloatingRuins.getBlacklistBiomeIDWithinRange(world, x, z, islandGenerator.radius);
                if (isWorldGen && biomeID > -1) {
                    debug = "Location %d,%d skipped due to proximity of a biomeID (%d) in the biomeIDBlackList";
                    if (isWorldGen) {
                        debug = debug + ". \"Retry\" count incremented (%d).";
                        ++chunksToRetry;
                    }
                    FloatingRuins.debug(debug, x, z, biomeID, chunksToRetry);
                } else if (isWorldGen && FloatingRuins.isVillageNearby(world, x, islandGenerator.yGround, z, islandGenerator.radius)) {
                    debug = "Location %d, %d skipped due to a village being found nearby";
                    if (isWorldGen) {
                        debug = debug + ". \"Retry\" count incremented (%d).";
                        ++chunksToRetry;
                    }
                    FloatingRuins.debug(debug, x, z, chunksToRetry);
                } else if (!FloatingRuins.doGenerateSurface(world, random, x, tgtY, z, islandGenerator)) {
                    debug = "Location %d, %d failed during island generation";
                    if (isWorldGen) {
                        debug = debug + ". \"Retry\" count incremented (%d).";
                        ++chunksToRetry;
                    }
                    FloatingRuins.debug(debug, x, z, chunksToRetry);
                }
            } else if (isWorldGen && chunksToRetry > 0 && random.nextInt(128) == 0 && FloatingRuins.getBlacklistBiomeIDWithinRange(world, x, z, islandGenerator.radius) == -1 && !FloatingRuins.isVillageNearby(world, x, islandGenerator.yGround, z, islandGenerator.radius) && FloatingRuins.doGenerateSurface(world, random, x, tgtY, z, islandGenerator)) {
                FloatingRuins.debug("Successfully generated a \"retry\" floating island at %d,%d. \"Retry\" count decremented (%d).", x, z, --chunksToRetry);
            }
        }
    }

    public static boolean doGenerateSurface(World world, Random random, int x, int tgtY, int z, WorldGenFloatingIsland islandGenerator) {
        if (islandGenerator == null) {
            islandGenerator = FloatingRuins.getFloatingIslandGenerator(world, random, x, tgtY, z);
        }
        return islandGenerator.func_76484_a(world, random, x, tgtY, z);
    }

    public static WorldGenFloatingIsland getFloatingIslandGenerator(World world, Random random, int x, int tgtY, int z) {
        int radius = FloatingRuins.getWeightedInt(radiusMin, radiusMean, radiusMax, radiusNorm, random);
        int yGround = CommonUtils.getHighestGroundBlock((World)world, (int)x, (int)tgtY, (int)z);
        int depth = FloatingRuins.getWeightedInt(depthMin, depthMean, depthMax, depthNorm, random);
        int islandType = FloatingRuins.getWeightedIslandType(random);
        WorldType wt = world.func_72912_H().func_76067_t();
        if (depth > yGround - (wt == WorldType.field_77138_c ? 1 : 5)) {
            depth = yGround - (wt == WorldType.field_77138_c ? 1 : 5);
        }
        return new WorldGenFloatingIsland(radius, depth, yGround, islandType);
    }

    public static Random getRandom(World world, int x, int z) {
        Random random = new Random(world.func_72905_C());
        long l = random.nextLong() / 2L * 2L + 1L;
        long l1 = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)x * l + (long)z * l1 ^ world.func_72905_C());
        return random;
    }

    public static boolean isVillageNearby(World world, int x, int y, int z, int radius) {
        if (world.field_72982_D != null) {
            for (Village village : world.field_72982_D.func_75540_b()) {
                if (!(Math.sqrt(village.func_75577_a().func_71569_e(x, y, z)) < (double)(village.func_75568_b() + radius))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getBlacklistBiomeIDWithinRange(World world, int x, int z, int radius) {
        float reciprocalRootOf2 = 0.70710677f;
        int adjRadius = Math.round((float)radius * reciprocalRootOf2);
        Coord pos = new Coord(x, 64, z);
        ForgeDirection[] NSEW = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
        int biomeID = pos.getBiomeGenBase((World)world).field_76756_M;
        if (CommonUtils.isIDInList((int)biomeID, (String)biomeIDBlacklist)) {
            return biomeID;
        }
        for (ForgeDirection fd : NSEW) {
            for (int i = radius; i > 0; i -= 2) {
                biomeID = pos.getOffsetCoord((ForgeDirection)fd, (int)i).getBiomeGenBase((World)world).field_76756_M;
                if (!CommonUtils.isIDInList((int)biomeID, (String)biomeIDBlacklist)) continue;
                return biomeID;
            }
        }
        for (int ns = 0; ns < 2; ++ns) {
            for (int ew = 2; ew < 4; ++ew) {
                for (int r = adjRadius; r > 0; r -= 2) {
                    biomeID = pos.getOffsetCoord((ForgeDirection)NSEW[ns], (int)r).getOffsetCoord((ForgeDirection)NSEW[ew], (int)r).getBiomeGenBase((World)world).field_76756_M;
                    if (!CommonUtils.isIDInList((int)biomeID, (String)biomeIDBlacklist)) continue;
                    return biomeID;
                }
            }
        }
        return -1;
    }

    public static void debug(String msg, Object ... args) {
        if (allowDebugLogging) {
            FRLog.info("[DEBUG] " + msg, args);
        }
    }

    public static int getWeightedInt(int min, int mean, int max, int norm, Random random) {
        float step;
        float deviation = 0.0f;
        for (int i = 0; i < norm; ++i) {
            deviation += (float)random.nextInt(99) / (float)norm;
        }
        if (deviation <= 50.0f) {
            step = (float)(mean - min) / 50.0f;
            min += Math.round(step * deviation);
        } else {
            step = (float)(max - mean) / 50.0f;
            min = mean + Math.round(step * (deviation -= 50.0f));
        }
        int weightedInt = min + random.nextInt((int)Math.ceil(step));
        return Math.abs(weightedInt);
    }

    public static int getWeightedIslandType(Random random) {
        int totalWeight = shapeSpheroidWeight + shapeConeWeight + shapeJetsonsWeight + shapeStalactiteWeight;
        int choice = random.nextInt(totalWeight);
        if (choice >= totalWeight - shapeStalactiteWeight) {
            return 3;
        }
        if (choice >= totalWeight - shapeStalactiteWeight - shapeJetsonsWeight) {
            return 2;
        }
        if (choice >= totalWeight - shapeStalactiteWeight - shapeJetsonsWeight - shapeConeWeight) {
            return 1;
        }
        return 0;
    }

    static {
        dimensionIDBlacklist = dimensionIDBlacklistDefault;
        biomeIDBlacklist = biomeIDBlacklistDefault;
        useCustomItemList = false;
        spawnerDefault = spawnerDefaultDefault;
        spawnerDesert = spawnerDesertDefault;
        spawnerForest = spawnerForestDefault;
        spawnerPlains = spawnerPlainsDefault;
        spawnerSwampland = spawnerSwamplandDefault;
        spawnerTaiga = spawnerTaigaDefault;
        spawnerHills = spawnerHillsDefault;
        spawnerOcean = spawnerOceanDefault;
        spawnerRiver = spawnerRiverDefault;
        spawnerJungle = spawnerJungleDefault;
        spawnerIceBiomes = spawnerIceBiomesDefault;
        spawnerMushroom = spawnerMushroomDefault;
        spawnerNearLava = spawnerNearLavaDefault;
        chunksToRetry = 0;
        blockIDBlacklistDefault = GameData.blockRegistry.func_148750_c((Object)Blocks.field_150357_h) + ";";
        stringOfIdsDefault = GameData.itemRegistry.func_148750_c((Object)Items.field_151032_g) + ", 10; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151032_g) + ", 16; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151044_h) + ", 6; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151045_i) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151042_j) + ", 3; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151043_k) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151009_A) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151008_G) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151020_U) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151023_V) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151022_W) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151029_X) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151159_an) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151159_an) + ", 5; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151153_ao) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151153_ao) + ", 3; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151133_ar) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151129_at) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151117_aB) + ", 1; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151122_aG) + ", 4; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151123_aH) + ", 6; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151110_aK) + ", 4; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151110_aK) + ", 8; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151114_aO) + ", 12; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151114_aO) + ", 8; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151101_aQ) + ", 3; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151100_aR) + ", 5, 0; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151105_aU) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151072_bj) + ", 2; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151075_bm) + ", 6; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151166_bC) + ", 4; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151166_bC) + ", 6; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151128_bU) + ", 6; " + GameData.itemRegistry.func_148750_c((Object)Items.field_151148_bJ) + ", 1; " + GameData.blockRegistry.func_148750_c((Object)Blocks.field_150343_Z) + ", 4; " + GameData.blockRegistry.func_148750_c((Object)Blocks.field_150432_aD) + ", 3;";
    }
}

