/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockTextureStitched;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityCableDetector;
import ic2.core.block.wiring.TileEntityCableSplitter;
import ic2.core.init.InternalName;
import ic2.core.item.block.ItemBlockIC2;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.util.AabbUtil;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCable
extends BlockMultiID {
    private static final Direction[] directions = Direction.values();
    private static final int[] coloredMetas = new int[]{0, 3, 4, 6, 7, 8, 9};
    protected int colorMultiplier = -1;
    public boolean enableBreakBlock = true;
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] coloredTextures;

    public BlockCable(InternalName internalName1) {
        super(internalName1, Material.field_151573_f, ItemBlockIC2.class);
        this.func_149711_c(0.2f);
        this.func_149672_a(field_149775_l);
        this.func_149647_a(null);
        Ic2Items.copperCableBlock = new ItemStack((Block)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new ItemStack((Block)this, 1, 0);
        Ic2Items.goldCableBlock = new ItemStack((Block)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new ItemStack((Block)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new ItemStack((Block)this, 1, 4);
        Ic2Items.ironCableBlock = new ItemStack((Block)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new ItemStack((Block)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.tinCableBlock = new ItemStack((Block)this, 1, 10);
        Ic2Items.detectorCableBlock = new ItemStack((Block)this, 1, 11);
        Ic2Items.splitterCableBlock = new ItemStack((Block)this, 1, 12);
        Ic2Items.insulatedtinCableBlock = new ItemStack((Block)this, 1, 13);
        GameRegistry.registerTileEntity(TileEntityCable.class, (String)"Cable");
        GameRegistry.registerTileEntity(TileEntityCableDetector.class, (String)"Detector Cable");
        GameRegistry.registerTileEntity(TileEntityCableSplitter.class, (String)"SplitterCable");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public String getTextureFolder(int id) {
        return "wiring/cable";
    }

    @Override
    public String getTextureName(int index) {
        ItemStack itemStack;
        Item item = Ic2Items.copperCableItem.func_77973_b();
        String ret = item.func_77667_c(itemStack = new ItemStack((Block)this, 1, index));
        if (ret == null) {
            return null;
        }
        return ret.replace("item", "block").substring(4);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.coloredTextures = new IIcon[coloredMetas.length][90];
        for (int index = 0; index < coloredMetas.length; ++index) {
            int meta = coloredMetas[index];
            for (int color = 1; color < 16; ++color) {
                String name = "ic2:" + this.getTextureFolder(index) + "/" + this.getTextureName(meta) + "." + Util.getColorName(color).name();
                for (int side = 0; side < 6; ++side) {
                    String subName = name + ":" + side;
                    BlockTextureStitched texture = new BlockTextureStitched(subName, side);
                    this.coloredTextures[index][(color - 1) * 6 + side] = texture;
                    ((TextureMap)iconRegister).setTextureEntry(subName, (TextureAtlasSprite)texture);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int x, int y, int z, int side) {
        TileEntity te = iBlockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 0) {
                if (te instanceof TileEntityCableDetector || te instanceof TileEntityCableSplitter || cable.color == 0) {
                    return super.func_149673_e(iBlockAccess, x, y, z, side);
                }
                int index = Arrays.binarySearch(coloredMetas, (int)cable.cableType);
                return this.coloredTextures[index][(cable.color - 1) * 6 + side];
            }
            if (cable.foamed == 1) {
                return StackUtil.getBlock(Ic2Items.constructionFoam).func_149691_a(side, 0);
            }
            Block referencedBlock = cable.getReferencedBlock(side);
            if (referencedBlock != null) {
                try {
                    return referencedBlock.func_149691_a(cable.retextureRefSide[side], cable.retextureRefMeta[side]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return StackUtil.getBlock(Ic2Items.constructionFoamWall).func_149691_a(side, (int)cable.foamColor);
        }
        return null;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        double halfThickness = tileEntityCable.foamed > 0 ? 0.5 : (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        } else if (halfThickness < 0.5) {
            int mask = 1;
            for (Direction dir : directions) {
                if ((tileEntityCable.connectivity & mask) == 0) {
                    mask *= 2;
                    continue;
                }
                mask *= 2;
                AxisAlignedBB bbox = null;
                switch (dir) {
                    case XN: {
                        bbox = AxisAlignedBB.func_72330_a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case XP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case ZN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                        break;
                    }
                    case ZP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                    }
                }
                intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
                if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
                hit = true;
                break;
            }
        }
        if (hit && intersectingDirection != null) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        if (meta == 13) {
            halfThickness = TileEntityCable.getCableThickness(14);
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX1 = (double)x + 0.5 - halfThickness;
        double minY1 = (double)y + 0.5 - halfThickness;
        double minZ1 = (double)z + 0.5 - halfThickness;
        double maxX1 = (double)x + 0.5 + halfThickness;
        double maxY1 = (double)y + 0.5 + halfThickness;
        double maxZ1 = (double)z + 0.5 + halfThickness;
        if ((cable.connectivity & 1) != 0) {
            minX1 = x;
        }
        if ((cable.connectivity & 4) != 0) {
            minY1 = y;
        }
        if ((cable.connectivity & 0x10) != 0) {
            minZ1 = z;
        }
        if ((cable.connectivity & 2) != 0) {
            maxX1 = x + 1;
        }
        if ((cable.connectivity & 8) != 0) {
            maxY1 = y + 1;
        }
        if ((cable.connectivity & 0x20) != 0) {
            maxZ1 = z + 1;
        }
        return AxisAlignedBB.func_72330_a((double)minX1, (double)minY1, (double)minZ1, (double)maxX1, (double)maxY1, (double)maxZ1);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        TileEntity te;
        ItemStack cur = entityPlayer.func_71045_bC();
        if (cur != null && (StackUtil.equals((Block)Blocks.field_150354_m, cur) || cur.func_77973_b() == Ic2Items.constructionFoam.func_77973_b()) && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (StackUtil.equals((Block)Blocks.field_150354_m, cur) && cable.foamed == 1 && cable.changeFoam((byte)2) || cur.func_77973_b() == Ic2Items.constructionFoam.func_77973_b() && cable.foamed == 0 && cable.changeFoam((byte)1)) {
                if (IC2.platform.isSimulating() && !entityPlayer.field_71075_bZ.field_75098_d) {
                    --cur.field_77994_a;
                    if (cur.field_77994_a <= 0) {
                        entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        TileEntity te;
        super.func_149695_a(world, x, y, z, neighbor);
        if (IC2.platform.isSimulating() && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCable) {
            ((TileEntityCable)te).onNeighborBlockChange();
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                cable.changeFoam((byte)0);
                world.func_147459_d(x, y, z, (Block)this);
                return false;
            }
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (this.enableBreakBlock) {
            super.func_149749_a(world, x, y, z, block, meta);
        }
    }

    public static int getCableColor(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int color) {
        color = BlockColored.func_150031_c((int)color);
        return ((TileEntityCable)world.func_147438_o(x, y, z)).changeColor(color);
    }

    @SubscribeEvent
    public void colorBlock(PaintEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        event.painted = ((TileEntityCable)event.world.func_147438_o(event.x, event.y, event.z)).changeColor(event.color);
    }

    public boolean canHarvestBlock(EntityPlayer player, int md) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.cableType == 14) {
                ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, 13));
                return ret;
            }
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, (int)cable.cableType));
        } else {
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, metadata));
        }
        return ret;
    }

    @Override
    public TileEntityBlock createTileEntity(World world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        if (meta == 13) {
            return new TileEntityCable((short)(meta + 1));
        }
        return new TileEntityCable((short)meta);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("cable");
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.func_71045_bC(), world, i, j, k);
        }
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive() ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tabs, List itemList) {
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 1) {
                return 0.01f;
            }
            if (cable.foamed == 2) {
                return 3.0f;
            }
        }
        return 0.2f;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double src_x, double src_y, double src_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 255;
            }
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int direction) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 11 || meta == 12;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ArrayList<ItemStack> ret = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
        if (ret.isEmpty()) {
            return null;
        }
        return (ItemStack)ret.get(0);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        if (te != null && te.getClass() == TileEntityCableDetector.class) {
            TileEntityCableDetector tec = (TileEntityCableDetector)te;
            return (int)Math.floor(EnergyNet.instance.getTotalEnergyEmitted(te) / (tec.getConductorBreakdownEnergy() - 1.0) * 15.0);
        }
        return 0;
    }

    @SubscribeEvent
    public void onRetexture(RetextureEvent event) {
        TileEntity te = event.world.func_147438_o(event.x, event.y, event.z);
        if (te instanceof TileEntityCable && ((TileEntityCable)te).retexture(event.side, event.referencedBlock, event.referencedMeta, event.referencedSide)) {
            event.applied = true;
        }
    }

    public int func_149720_d(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        if (this.colorMultiplier != -1) {
            return this.colorMultiplier;
        }
        return super.func_149720_d(par1iBlockAccess, x, y, z);
    }
}

