/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.Grid;
import ic2.core.energy.NodeLink;
import ic2.core.energy.NodeType;
import ic2.core.energy.Tile;
import java.util.ArrayList;
import java.util.List;

class Node {
    final int uid;
    final Tile tile;
    final NodeType nodeType;
    boolean isExtraNode = false;
    double amount;
    Grid grid;
    List<NodeLink> links = new ArrayList<NodeLink>();

    Node(EnergyNetLocal energyNet, Tile tile1, NodeType nodeType1) {
        assert (nodeType1 != NodeType.Conductor || tile1.entity instanceof IEnergyConductor);
        assert (nodeType1 != NodeType.Sink || tile1.entity instanceof IEnergySink);
        assert (nodeType1 != NodeType.Source || tile1.entity instanceof IEnergySource);
        this.uid = EnergyNetLocal.getNextNodeUid();
        this.tile = tile1;
        this.nodeType = nodeType1;
    }

    Node(Node node) {
        this.uid = node.uid;
        this.tile = node.tile;
        this.nodeType = node.nodeType;
        this.grid = node.grid;
        assert (this.nodeType != NodeType.Conductor || this.tile.entity instanceof IEnergyConductor);
        assert (this.nodeType != NodeType.Sink || this.tile.entity instanceof IEnergySink);
        assert (this.nodeType != NodeType.Source || this.tile.entity instanceof IEnergySource);
        for (NodeLink link : node.links) {
            this.links.add(new NodeLink(link));
        }
    }

    double getInnerLoss() {
        switch (this.nodeType) {
            case Source: {
                return 0.2;
            }
            case Sink: {
                return 20.0 * (double)this.getTier();
            }
            case Conductor: {
                return ((IEnergyConductor)this.tile.entity).getConductionLoss();
            }
        }
        throw new RuntimeException("invalid nodetype: " + (Object)((Object)this.nodeType));
    }

    int getTier() {
        return 1;
    }

    public String toString() {
        String type = null;
        switch (this.nodeType) {
            case Conductor: {
                type = "C";
                break;
            }
            case Sink: {
                type = "A";
                break;
            }
            case Source: {
                type = "E";
            }
        }
        return this.tile.entity.getClass().getSimpleName().replace("TileEntity", "") + "|" + type + "|" + this.uid;
    }
}

