/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import ic2.core.util.Util;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public double charge(ItemStack stack, double charge, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0.0);
        if (charge < 0.0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && charge > item.getTransferLimit(stack)) {
            charge = item.getTransferLimit(stack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(stack);
        double newCharge = tNBT.func_74769_h("charge");
        if (charge > item.getMaxCharge(stack) - newCharge) {
            charge = item.getMaxCharge(stack) - newCharge;
        }
        if (!simulate) {
            if ((newCharge += charge) > 0.0) {
                tNBT.func_74780_a("charge", newCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            stack.func_150996_a(newCharge > 0.0 ? item.getChargedItem(stack) : item.getEmptyItem(stack));
            if (stack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)stack.func_77973_b();
                if (stack.func_77958_k() > 2) {
                    stack.func_77964_b(stack.func_77958_k() - 1 - (int)Util.map(newCharge, item.getMaxCharge(stack), stack.func_77958_k() - 2));
                } else {
                    stack.func_77964_b(0);
                }
            } else {
                stack.func_77964_b(0);
            }
        }
        return charge;
    }

    @Override
    public double discharge(ItemStack stack, double charge, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        NBTTagCompound tNBT;
        double newCharge;
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0.0);
        if (charge < 0.0 || stack.field_77994_a > 1 || item.getTier(stack) > tier) {
            return 0.0;
        }
        if (externally && !item.canProvideEnergy(stack)) {
            return 0.0;
        }
        if (!ignoreTransferLimit && charge > item.getTransferLimit(stack)) {
            charge = item.getTransferLimit(stack);
        }
        if (charge > (newCharge = (tNBT = StackUtil.getOrCreateNbtData(stack)).func_74769_h("charge"))) {
            charge = newCharge;
        }
        if (!simulate) {
            if ((newCharge -= charge) > 0.0) {
                tNBT.func_74780_a("charge", newCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            stack.func_150996_a(newCharge > 0.0 ? item.getChargedItem(stack) : item.getEmptyItem(stack));
            if (stack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)stack.func_77973_b();
                if (stack.func_77958_k() > 2) {
                    stack.func_77964_b(stack.func_77958_k() - 1 - (int)Util.map(newCharge, item.getMaxCharge(stack), stack.func_77958_k() - 2));
                } else {
                    stack.func_77964_b(0);
                }
            } else {
                stack.func_77964_b(0);
            }
        }
        return charge;
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricItem.manager.getCharge(itemStack) >= amount;
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        double transfer = ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, true);
        if (Util.isSimilar(transfer, amount)) {
            ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        int tier = itemStack.func_77973_b() instanceof IElectricItem ? ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack) : Integer.MAX_VALUE;
        boolean transferred = false;
        for (int i = 0; i < 4; ++i) {
            double transfer;
            ItemStack armorItemStack = entity.func_71124_b(i + 1);
            if (armorItemStack == null || (transfer = ElectricItem.manager.discharge(armorItemStack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true, true)) <= 0.0 || (transfer = ElectricItem.manager.charge(itemStack, transfer, tier, true, false)) <= 0.0) continue;
            ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false);
            transferred = true;
        }
        if (transferred && entity instanceof EntityPlayer && IC2.platform.isSimulating()) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        double charge = ElectricItem.manager.getCharge(itemStack);
        double space = ElectricItem.manager.charge(itemStack, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, true);
        return charge + "/" + (charge + space) + " EU";
    }
}

