/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.Node;
import ic2.core.energy.NodeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

class Tile {
    final TileEntity entity;
    final List<Node> nodes = new ArrayList<Node>();

    Tile(EnergyNetLocal energyNet, TileEntity te) {
        this.entity = te;
        if (te instanceof IEnergySource) {
            this.nodes.add(new Node(energyNet, this, NodeType.Source));
        }
        if (te instanceof IEnergySink) {
            this.nodes.add(new Node(energyNet, this, NodeType.Sink));
        }
        if (te instanceof IEnergyConductor) {
            this.nodes.add(new Node(energyNet, this, NodeType.Conductor));
        }
    }

    void addExtraNode(Node node) {
        node.isExtraNode = true;
        this.nodes.add(node);
    }

    boolean removeExtraNode(Node node) {
        boolean canBeRemoved = false;
        if (node.isExtraNode) {
            canBeRemoved = true;
        } else {
            for (Node otherNode : this.nodes) {
                if (otherNode == node || otherNode.nodeType != node.nodeType || !otherNode.isExtraNode) continue;
                otherNode.isExtraNode = false;
                canBeRemoved = true;
                break;
            }
        }
        if (canBeRemoved) {
            this.nodes.remove(node);
            return true;
        }
        return false;
    }

    TileEntity getSubEntityAt(ChunkCoordinates coords) {
        if (this.entity instanceof IMetaDelegate) {
            for (TileEntity te : ((IMetaDelegate)this.entity).getSubTiles()) {
                if (te.field_145851_c != coords.field_71574_a || te.field_145848_d != coords.field_71572_b || te.field_145849_e != coords.field_71573_c) continue;
                return te;
            }
            return null;
        }
        return this.entity;
    }
}

