/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.core.IC2;
import ic2.core.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public class LiquidUtil {
    public static LiquidData getLiquid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        Fluid liquid = null;
        boolean isSource = false;
        if (block instanceof IFluidBlock) {
            IFluidBlock fblock = (IFluidBlock)block;
            liquid = fblock.getFluid();
            isSource = fblock.canDrain(world, x, y, z);
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            liquid = FluidRegistry.WATER;
            isSource = world.func_72805_g(x, y, z) == 0;
        } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            liquid = FluidRegistry.LAVA;
            boolean bl = isSource = world.func_72805_g(x, y, z) == 0;
        }
        if (liquid != null) {
            return new LiquidData(liquid, isSource);
        }
        return null;
    }

    public static int fillContainerStack(ItemStack stack, EntityPlayer player, FluidStack fluid, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return 0;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.fill(stack, fluid, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        int amount = container.fill(testStack, fluid, true);
        if (amount <= 0) {
            return 0;
        }
        if (LiquidUtil.storeContainer(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return amount;
        }
        return 0;
    }

    public static FluidStack drainContainerStack(ItemStack stack, EntityPlayer player, int maxAmount, boolean simulate) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return null;
        }
        IFluidContainerItem container = (IFluidContainerItem)item;
        if (stack.field_77994_a == 1) {
            return container.drain(stack, maxAmount, !simulate);
        }
        ItemStack testStack = StackUtil.copyWithSize(stack, 1);
        FluidStack ret = container.drain(testStack, maxAmount, true);
        if (ret == null || ret.amount <= 0) {
            return null;
        }
        if (LiquidUtil.storeContainer(testStack, player, simulate)) {
            if (!simulate) {
                --stack.field_77994_a;
            }
            return ret;
        }
        return null;
    }

    private static boolean storeContainer(ItemStack container, EntityPlayer player, boolean simulate) {
        if (simulate) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.field_70462_a[i];
                if (stack != null && (!StackUtil.isStackEqualStrict(stack, container) || stack.field_77994_a >= container.func_77976_d())) continue;
                return true;
            }
            return false;
        }
        if (player.field_71071_by.func_70441_a(container)) {
            if (!IC2.platform.isRendering()) {
                player.field_71070_bA.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public static class LiquidData {
        public final Fluid liquid;
        public final boolean isSource;

        LiquidData(Fluid liquid1, boolean isSource1) {
            this.liquid = liquid1;
            this.isSource = isSource1;
        }
    }
}

