/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import ic2.core.init.InternalName;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public final class Util {
    public static int roundToNegInf(float x) {
        int ret = (int)x;
        if ((float)ret > x) {
            --ret;
        }
        return ret;
    }

    public static int roundToNegInf(double x) {
        int ret = (int)x;
        if ((double)ret > x) {
            --ret;
        }
        return ret;
    }

    public static double limit(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double map(double value, double srcMax, double dstMax) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > srcMax) {
            value = srcMax;
        }
        return value / srcMax * dstMax;
    }

    public static boolean isSimilar(double a, double b) {
        return Math.abs(a - b) < 1.0E-6;
    }

    public static int countInArray(Object[] oa, Class<?> cls) {
        int ret = 0;
        for (Object o : oa) {
            if (!cls.isAssignableFrom(o.getClass())) continue;
            ++ret;
        }
        return ret;
    }

    public static InternalName getColorName(int color) {
        switch (color) {
            case 0: {
                return InternalName.black;
            }
            case 1: {
                return InternalName.red;
            }
            case 2: {
                return InternalName.green;
            }
            case 3: {
                return InternalName.brown;
            }
            case 4: {
                return InternalName.blue;
            }
            case 5: {
                return InternalName.purple;
            }
            case 6: {
                return InternalName.cyan;
            }
            case 7: {
                return InternalName.lightGray;
            }
            case 8: {
                return InternalName.gray;
            }
            case 9: {
                return InternalName.pink;
            }
            case 10: {
                return InternalName.lime;
            }
            case 11: {
                return InternalName.yellow;
            }
            case 12: {
                return InternalName.lightBlue;
            }
            case 13: {
                return InternalName.magenta;
            }
            case 14: {
                return InternalName.orange;
            }
            case 15: {
                return InternalName.white;
            }
        }
        return null;
    }

    public static boolean inDev() {
        return System.getProperty("INDEV") != null;
    }

    public static boolean matchesOD(ItemStack stack, Object match) {
        if (match instanceof ItemStack) {
            return stack == null || stack.func_77969_a((ItemStack)match);
        }
        if (match instanceof String) {
            if (stack == null) {
                return false;
            }
            for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)oreId).equals(match)) continue;
                return true;
            }
            return false;
        }
        return stack == match;
    }

    public static String asString(TileEntity te) {
        if (te == null) {
            return null;
        }
        return te + " (" + te.func_145831_w().field_73011_w.field_76574_g + ": " + te.field_145851_c + "/" + te.field_145848_d + "/" + te.field_145849_e + ")";
    }

    public static String toSiString(double value, int digits) {
        String si;
        int iVal;
        double log;
        if (value == 0.0) {
            return "0 ";
        }
        String ret = "";
        if (value < 0.0) {
            ret = "-";
            value = -value;
        }
        if ((log = Math.log10(value)) >= 0.0) {
            int reduce = (int)Math.floor(log / 3.0);
            double div = (int)Math.pow(10.0, reduce * 3);
            iVal = (int)Math.floor(value / div);
            value = value / div - (double)iVal;
            switch (reduce) {
                case 0: {
                    si = "";
                    break;
                }
                case 1: {
                    si = "k";
                    break;
                }
                case 2: {
                    si = "M";
                    break;
                }
                case 3: {
                    si = "G";
                    break;
                }
                case 4: {
                    si = "T";
                    break;
                }
                case 5: {
                    si = "P";
                    break;
                }
                default: {
                    si = "?";
                    break;
                }
            }
        } else {
            int expand = (int)Math.ceil(-log / 3.0);
            double mul = (int)Math.pow(10.0, expand * 3);
            iVal = (int)Math.floor(value * mul);
            value = value * mul - (double)iVal;
            switch (expand) {
                case 0: {
                    si = "";
                    break;
                }
                case 1: {
                    si = "m";
                    break;
                }
                case 2: {
                    si = "\u00b5";
                    break;
                }
                case 3: {
                    si = "n";
                    break;
                }
                case 4: {
                    si = "p";
                    break;
                }
                case 5: {
                    si = "f";
                    break;
                }
                default: {
                    si = "?";
                }
            }
        }
        digits = iVal == 0 ? --digits : (int)((double)digits - Math.ceil(Math.log10(iVal)));
        ret = ret + Integer.toString(iVal);
        if (digits > 0) {
            int dVal = (int)(value * Math.pow(10.0, digits));
            ret = ret + String.format(".%0" + digits + "d", dVal);
        }
        ret = ret.replaceFirst("(\\.\\d+?)0+$", "$1");
        return ret + " " + si;
    }
}

