/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.doors.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.relauncher.Side;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.core.updateChecker.ModVersionInfo;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import us.ichun.mods.doors.common.core.CommonProxy;
import us.ichun.mods.doors.common.tileentity.TileEntityDoor;

@Mod(modid="Doors", name="Doors", version="4.0.1", dependencies="required-after:iChunUtil@[4.2.1,)", acceptableRemoteVersions="[4.0.0,4.1.0)")
public class Doors {
    public static final String readME1 = "HEY YOU. YES YOU. If you're reading this that means you decompiled the mod. Obviously this mod was made for April Fools,";
    public static final String readME2 = "so for the sake of everyone else, please don't spoil what this mod does cause you decompiled it! Let the community... 'Explore'.";
    public static final String readME3 = "You know how I can be with my mods... So again, let them find out for themselves, it'll be best. Cheers, iChun";
    public static final String version = "4.0.1";
    private static Logger logger = LogManager.getLogger((String)"Doors");
    public static EnumMap<Side, FMLEmbeddedChannel> channels;
    @Mod.Instance(value="Doors")
    public static Doors instance;
    @SidedProxy(clientSide="us.ichun.mods.doors.client.core.ClientProxy", serverSide="us.ichun.mods.doors.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static Block blockDoor;
    public static Item itemDoorPlacer;
    public static int renderDoor;
    public static HashMap<World, ArrayList<TileEntityDoor>> doorMap;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        proxy.preInit();
        if (TileEntityDoor.canTrigger) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            config.load();
            renderDoor = this.addCommentAndReturnInt(config, "doors", "renderDoor", "Render Door?\n0 = No\n1 = Yes", 1);
            config.save();
        }
        ModVersionChecker.register_iChunMod((ModVersionInfo)new ModVersionInfo("Doors", "1.7.10", version, false));
    }

    public int addCommentAndReturnInt(Configuration config, String cat, String s, String comment, int i) {
        Property prop = config.get(cat, s, i);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getInt();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        doorMap.remove(event.world);
    }

    public static ArrayList<TileEntityDoor> getDoorMap(World world) {
        ArrayList<TileEntityDoor> map = doorMap.get(world);
        if (map == null) {
            map = new ArrayList();
            doorMap.put(world, map);
        }
        return map;
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }

    static {
        renderDoor = 1;
        doorMap = new HashMap();
    }
}

