/*
 * Decompiled with CFR 0.152.
 */
package clickme.nocubes.renderer;

import clickme.nocubes.NoCubes;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class SurfaceNets {
    public static int[] cube_edges;
    public static int[] edge_table;

    public static float getBlockDensity(int x, int y, int z, IBlockAccess cache) {
        float dens = 0.0f;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 2; ++i) {
                    Block block = cache.func_147439_a(x - i, y - j, z - k);
                    if (NoCubes.isBlockNatural(block)) {
                        dens += 1.0f;
                        continue;
                    }
                    dens -= 1.0f;
                }
            }
        }
        return dens;
    }

    public static boolean renderChunk(int pass, int cx, int cy, int cz, IBlockAccess cache, RenderBlocks renderer) {
        if (!NoCubes.isNoCubesEnabled) {
            return false;
        }
        if (pass != 0) {
            return false;
        }
        Tessellator tess = Tessellator.field_78398_a;
        int[] dims = new int[]{16, 16, 16};
        int[] c = new int[]{cx, cy, cz};
        int[] x = new int[3];
        int[] r = new int[]{1, dims[0] + 3, (dims[0] + 3) * (dims[1] + 3)};
        float[] grid = new float[8];
        float[][] buffer = new float[r[2] * 2][3];
        int bufno = 1;
        x[2] = 0;
        while (x[2] < dims[2] + 1) {
            int m = 1 + (dims[0] + 3) * (1 + bufno * (dims[1] + 3));
            x[1] = 0;
            while (x[1] < dims[1] + 1) {
                x[0] = 0;
                while (x[0] < dims[0] + 1) {
                    int mask = 0;
                    int g = 0;
                    for (int k = 0; k < 2; ++k) {
                        for (int j = 0; j < 2; ++j) {
                            int i = 0;
                            while (i < 2) {
                                float p;
                                grid[g] = p = SurfaceNets.getBlockDensity(c[0] + x[0] + i, c[1] + x[1] + j, c[2] + x[2] + k, cache);
                                mask |= p > 0.0f ? 1 << g : 0;
                                ++i;
                                ++g;
                            }
                        }
                    }
                    if (mask != 0 && mask != 255) {
                        Block block = Blocks.field_150350_a;
                        int meta = 0;
                        block6: for (int k = -1; k < 2; ++k) {
                            for (int j = -1; j < 2; ++j) {
                                for (int i = -1; i < 2; ++i) {
                                    Block b = cache.func_147439_a(c[0] + x[0] + i, c[1] + x[1] + k, c[2] + x[2] + j);
                                    if (!NoCubes.isBlockNatural(b) || block == Blocks.field_150431_aC || block == Blocks.field_150349_c) continue;
                                    block = b;
                                    meta = cache.func_72805_g(c[0] + x[0] + i, c[1] + x[1] + k, c[2] + x[2] + j);
                                    if (b == Blocks.field_150431_aC || b == Blocks.field_150349_c) break block6;
                                }
                            }
                        }
                        int[] br = new int[]{c[0] + x[0], c[1] + x[1] + 1, c[2] + x[2]};
                        block9: for (int k = -1; k < 2; ++k) {
                            for (int j = -2; j < 3; ++j) {
                                for (int i = -1; i < 2; ++i) {
                                    Block b = cache.func_147439_a(c[0] + x[0] + i, c[1] + x[1] + k, c[2] + x[2] + j);
                                    if (b.func_149662_c()) continue;
                                    br[0] = c[0] + x[0] + i;
                                    br[1] = c[1] + x[1] + k;
                                    br[2] = c[2] + x[2] + j;
                                    break block9;
                                }
                            }
                        }
                        IIcon icon = renderer.func_147787_a(block, 1, meta);
                        double tu0 = icon.func_94209_e();
                        double tu1 = icon.func_94212_f();
                        double tv0 = icon.func_94206_g();
                        double tv1 = icon.func_94210_h();
                        int edgemask = edge_table[mask];
                        int ecount = 0;
                        float[] v = new float[]{0.0f, 0.0f, 0.0f};
                        for (int i = 0; i < 12; ++i) {
                            if ((edgemask & 1 << i) == 0) continue;
                            ++ecount;
                            int e0 = cube_edges[i << 1];
                            float g0 = grid[e0];
                            int e1 = cube_edges[(i << 1) + 1];
                            float g1 = grid[e1];
                            float t = g0 - g1;
                            if (!(Math.abs(t) > 0.0f)) continue;
                            t = g0 / t;
                            int j = 0;
                            int k = 1;
                            while (j < 3) {
                                int a = e0 & k;
                                int b = e1 & k;
                                if (a != b) {
                                    int n = j;
                                    v[n] = v[n] + (a != 0 ? 1.0f - t : t);
                                } else {
                                    int n = j;
                                    v[n] = v[n] + (a != 0 ? 1.0f : 0.0f);
                                }
                                ++j;
                                k <<= 1;
                            }
                        }
                        float s = 1.0f / (float)ecount;
                        for (int i = 0; i < 3; ++i) {
                            v[i] = (float)(c[i] + x[i]) + s * v[i];
                        }
                        int tx = x[0] == 16 ? 0 : x[0];
                        int ty = x[1] == 16 ? 0 : x[1];
                        int tz = x[2] == 16 ? 0 : x[2];
                        long i1 = (long)(tx * 3129871) ^ (long)tz * 116129781L ^ (long)ty;
                        i1 = i1 * i1 * 42317861L + i1 * 11L;
                        v[0] = (float)((double)v[0] - ((double)((float)(i1 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.2);
                        v[1] = (float)((double)v[1] - ((double)((float)(i1 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2);
                        v[2] = (float)((double)v[2] - ((double)((float)(i1 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.2);
                        buffer[m] = v;
                        for (int i = 0; i < 3; ++i) {
                            if ((edgemask & 1 << i) == 0) continue;
                            int iu = (i + 1) % 3;
                            int iv = (i + 2) % 3;
                            if (x[iu] == 0 || x[iv] == 0) continue;
                            int du = r[iu];
                            int dv = r[iv];
                            tess.func_78380_c(block.func_149677_c((IBlockAccess)Minecraft.func_71410_x().field_71441_e, br[0], br[1], br[2]));
                            tess.func_78378_d(block.func_149720_d(cache, c[0] + x[0], c[1] + x[1], c[2] + x[2]));
                            float[] v0 = buffer[m];
                            float[] v1 = buffer[m - du];
                            float[] v2 = buffer[m - du - dv];
                            float[] v3 = buffer[m - dv];
                            if ((mask & 1) != 0) {
                                tess.func_78374_a((double)v0[0], (double)v0[1], (double)v0[2], tu0, tv1);
                                tess.func_78374_a((double)v1[0], (double)v1[1], (double)v1[2], tu1, tv1);
                                tess.func_78374_a((double)v2[0], (double)v2[1], (double)v2[2], tu1, tv0);
                                tess.func_78374_a((double)v3[0], (double)v3[1], (double)v3[2], tu0, tv0);
                                continue;
                            }
                            tess.func_78374_a((double)v0[0], (double)v0[1], (double)v0[2], tu0, tv1);
                            tess.func_78374_a((double)v3[0], (double)v3[1], (double)v3[2], tu1, tv1);
                            tess.func_78374_a((double)v2[0], (double)v2[1], (double)v2[2], tu1, tv0);
                            tess.func_78374_a((double)v1[0], (double)v1[1], (double)v1[2], tu0, tv0);
                        }
                    }
                    x[0] = x[0] + 1;
                    ++m;
                }
                x[1] = x[1] + 1;
                m += 2;
            }
            x[2] = x[2] + 1;
            bufno ^= 1;
            r[2] = -r[2];
        }
        return true;
    }

    static {
        int i;
        cube_edges = new int[24];
        edge_table = new int[256];
        int k = 0;
        for (i = 0; i < 8; ++i) {
            for (int j = 1; j <= 4; j <<= 1) {
                int p = i ^ j;
                if (i > p) continue;
                SurfaceNets.cube_edges[k++] = i;
                SurfaceNets.cube_edges[k++] = p;
            }
        }
        for (i = 0; i < 256; ++i) {
            int em = 0;
            for (int j = 0; j < 24; j += 2) {
                boolean a = (i & 1 << cube_edges[j]) != 0;
                boolean b = (i & 1 << cube_edges[j + 1]) != 0;
                em |= a != b ? 1 << (j >> 1) : 0;
            }
            SurfaceNets.edge_table[i] = em;
        }
    }
}

