/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui;

import com.thejackimonster.saoui.SAODeathGUI;
import com.thejackimonster.saoui.SAOEventHandler;
import com.thejackimonster.saoui.SAOIngameGUI;
import com.thejackimonster.saoui.SAOIngameMenuGUI;
import com.thejackimonster.saoui.SAOJ8String;
import com.thejackimonster.saoui.SAONewChatGUI;
import com.thejackimonster.saoui.SAORenderBase;
import com.thejackimonster.saoui.SAOSound;
import com.thejackimonster.saoui.SAOWindowViewGUI;
import com.thejackimonster.saoui.ui.SAOConfirmGUI;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOScreenGUI;
import com.thejackimonster.saoui.ui.SAOWindowGUI;
import com.thejackimonster.saoui.util.SAOAction;
import com.thejackimonster.saoui.util.SAOActionHandler;
import com.thejackimonster.saoui.util.SAOColorCursor;
import com.thejackimonster.saoui.util.SAOColorState;
import com.thejackimonster.saoui.util.SAOCommand;
import com.thejackimonster.saoui.util.SAOFriendRequest;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="saoui", name="Sword Art Online UI", version="1.5")
@SideOnly(value=Side.CLIENT)
public class SAOMod
implements Runnable {
    public static final String MODID = "saoui";
    public static final String NAME = "Sword Art Online UI";
    public static final String VERSION = "1.5";
    public static final String AUTHOR_AND_DEVELOPER = "TheJackiMonster";
    private static final double MAX_RANGE = 256.0;
    private static final float HEALTH_ANIMATION_FACTOR = 0.075f;
    private static final float HEALTH_FRAME_FACTOR = 36.0f;
    public static final float UNKNOWN_TIME_DELAY = -1.0f;
    public static boolean IS_SPRINTING = false;
    public static boolean IS_SNEAKING = false;
    public static boolean DEBUG = false;
    private static File friendsFile;
    private static String[] friends;
    private static List<SAOFriendRequest> friendRequests;
    private static String[] party;
    private static String _FRIEND_REQUEST_TITLE;
    private static String _FRIEND_REQUEST_TEXT;
    private static String _PARTY_INVITATION_TITLE;
    private static String _PARTY_INVITATION_TEXT;
    public static String _PARTY_DISSOLVING_TITLE;
    public static String _PARTY_DISSOLVING_TEXT;
    public static String _PARTY_LEAVING_TITLE;
    public static String _PARTY_LEAVING_TEXT;
    public static String _MESSAGE_TITLE;
    public static String _MESSAGE_FROM;
    public static String _DEAD_ALERT;
    private static Thread mcModThread;
    private static Thread renderManagerUpdate;
    private static Map<UUID, Float> healthSmooth;
    private static Map<UUID, SAOColorCursor> colorStates;
    private static int partyTicks;
    private static Configuration config;
    public static int REPLACE_GUI_DELAY;
    private boolean replaceGUI;
    private SAOEventHandler events;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.events = new SAOEventHandler();
        FMLCommonHandler.instance().bus().register((Object)this.events);
        MinecraftForge.EVENT_BUS.register((Object)this.events);
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        friendRequests = new ArrayList<SAOFriendRequest>();
        DEBUG = config.get("general", "debug", DEBUG).getBoolean();
        _FRIEND_REQUEST_TITLE = config.get("general", "friend.request.title", "Friend Request").getString();
        _FRIEND_REQUEST_TEXT = config.get("general", "friend.request.text", "%s wants to add you as friend.").getString();
        _PARTY_INVITATION_TITLE = config.get("general", "party.invitation.title", "Invite").getString();
        _PARTY_INVITATION_TEXT = config.get("general", "party.invitation.text", "%s invites you to join a party.").getString();
        _PARTY_DISSOLVING_TITLE = config.get("general", "party.dissolving.title", "Dissolve").getString();
        _PARTY_DISSOLVING_TEXT = config.get("general", "party.dissolving.text", "You will disband your party?").getString();
        _PARTY_LEAVING_TITLE = config.get("general", "party.leaving.title", "Leave").getString();
        _PARTY_LEAVING_TEXT = config.get("general", "party.leaving.text", "You will leave your party?").getString();
        _MESSAGE_TITLE = config.get("general", "message.title", "Message").getString();
        _MESSAGE_FROM = config.get("general", "message.from", "from %s").getString();
        _DEAD_ALERT = config.get("general", "dead.alert", "You are dead").getString();
        for (SAOOption option : SAOOption.values()) {
            option.value = config.get("general", "option." + option.name().toLowerCase(), option.value).getBoolean();
        }
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Thread thread;
        Minecraft mc = Minecraft.func_71410_x();
        friendsFile = new File(mc.field_71412_D, ".sao_friends");
        if (!friendsFile.exists()) {
            SAOMod.writeFriends(friends);
        }
        friends = SAOMod.loadFriends();
        final RenderManager manager = mc.func_175598_ae();
        if (renderManagerUpdate != null) {
            thread = renderManagerUpdate;
            renderManagerUpdate = null;
            thread.interrupt();
        }
        renderManagerUpdate = new Thread(){

            @Override
            public void run() {
                while (manager != null) {
                    try {
                        for (Field field : manager.getClass().getDeclaredFields()) {
                            if (!Map.class.isAssignableFrom(field.getType())) continue;
                            Field playerRenderMapField = field;
                            playerRenderMapField.setAccessible(true);
                            Map playerRenderMap = (Map)playerRenderMapField.get(manager);
                            for (Map.Entry entry : playerRenderMap.entrySet()) {
                                Object value = entry.getValue();
                                if (!(value instanceof Render) || value instanceof SAORenderBase) continue;
                                SAORenderBase render = new SAORenderBase((Render)value);
                                entry.setValue(render);
                            }
                        }
                    }
                    catch (Exception e) {
                        SAOMod.sleep(1000L);
                    }
                    SAOMod.sleep(10000L);
                }
            }
        };
        renderManagerUpdate.start();
        if (mcModThread != null) {
            thread = mcModThread;
            mcModThread = null;
            thread.interrupt();
        }
        if (healthSmooth == null) {
            healthSmooth = new HashMap<UUID, Float>();
        } else {
            healthSmooth.clear();
        }
        if (colorStates == null) {
            colorStates = new HashMap<UUID, SAOColorCursor>();
        } else {
            colorStates.clear();
        }
        this.replaceGUI = true;
        mcModThread = new Thread(this);
        mcModThread.start();
    }

    private static final boolean sleep(long time) {
        try {
            Thread.sleep(time);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long time;
        long lasttime = time = System.currentTimeMillis();
        while (mcModThread != null && !mcModThread.isInterrupted()) {
            Minecraft mc;
            block33: {
                mc = Minecraft.func_71410_x();
                time = System.currentTimeMillis();
                long delay = Math.abs(time - lasttime);
                lasttime = time;
                if (mc == null) {
                    SAOMod.sleep(2500L);
                    continue;
                }
                for (SAOColorCursor cursor : colorStates.values()) {
                    cursor.update(delay);
                }
                if (mc.field_71439_g == null) {
                    IS_SPRINTING = false;
                    IS_SNEAKING = false;
                } else if (mc.field_71415_G) {
                    if (IS_SPRINTING) {
                        KeyBinding.func_74510_a((int)mc.field_71474_y.field_151444_V.func_151463_i(), (boolean)true);
                    }
                    if (IS_SNEAKING) {
                        KeyBinding.func_74510_a((int)mc.field_71474_y.field_74311_E.func_151463_i(), (boolean)true);
                    }
                }
                if (mc.field_71456_v != null && !(mc.field_71456_v instanceof SAOIngameGUI)) {
                    mc.field_71456_v = new SAOIngameGUI(mc);
                    continue;
                }
                if (this.replaceGUI) {
                    if (mc.field_71462_r != null && !(mc.field_71462_r instanceof SAOScreenGUI)) {
                        if (REPLACE_GUI_DELAY > 0) {
                            --REPLACE_GUI_DELAY;
                        } else {
                            if (mc.field_71462_r instanceof GuiIngameMenu || mc.field_71462_r instanceof GuiInventory && !SAOOption.DEFAULT_INVENTORY.value) {
                                boolean inv = mc.field_71462_r instanceof GuiInventory;
                                mc.field_71462_r.field_146297_k = mc;
                                try {
                                    SAOSound.play(mc, "sao.orb.dropdown");
                                    mc.func_147108_a((GuiScreen)new SAOIngameMenuGUI((GuiInventory)(inv ? mc.field_71462_r : null)));
                                    this.replaceGUI = false;
                                    break block33;
                                }
                                catch (NullPointerException e) {
                                    continue;
                                }
                            }
                            if (mc.field_71462_r instanceof GuiGameOver && !SAOOption.DEFAULT_DEATH_SCREEN.value) {
                                mc.field_71462_r.field_146297_k = mc;
                                try {
                                    mc.func_147108_a((GuiScreen)new SAODeathGUI((GuiGameOver)mc.field_71462_r));
                                    this.replaceGUI = false;
                                }
                                catch (NullPointerException e) {
                                    continue;
                                }
                            }
                        }
                    }
                } else if (mc.field_71462_r == null && mc.field_71415_G) {
                    this.replaceGUI = true;
                }
            }
            SAOMod.sleep(1L);
            List<SAOFriendRequest> e = friendRequests;
            synchronized (e) {
                for (int i = friendRequests.size() - 1; i >= 0; --i) {
                    if (i >= friendRequests.size() || --SAOMod.friendRequests.get((int)i).ticks > 0) continue;
                    friendRequests.remove(i);
                }
            }
            if (party != null && partyTicks > 0 && --partyTicks <= 0) {
                String name = SAOMod.getName(mc);
                if (party.length <= 1) {
                    SAOMod.dissolveParty(mc);
                } else if (SAOMod.isPartyLeader(name)) {
                    int i;
                    boolean[] online = SAOMod.isOnline(mc, party);
                    String[] remove = new String[party.length];
                    int count = 0;
                    for (i = 0; i < online.length; ++i) {
                        if (online[i]) continue;
                        remove[count++] = party[i];
                    }
                    for (i = 0; i < count; ++i) {
                        SAOMod.removeParty(mc, remove[i]);
                    }
                } else {
                    List<EntityPlayer> players = SAOMod.listOnlinePlayers(mc);
                    String leader = party[0];
                    if (!SAOMod.isOnline(mc, leader)) {
                        SAOMod.dissolveParty(mc);
                    }
                }
                if (party == null) continue;
                partyTicks = 1000;
                continue;
            }
            if (party != null) continue;
            partyTicks = 0;
        }
    }

    public static final List<EntityPlayer> listOnlinePlayers(Minecraft mc, boolean search, double range) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        if (mc.field_71439_g == null) {
            return players;
        }
        NetHandlerPlayClient nethandlerplayclient = mc.field_71439_g.field_71174_a;
        Collection list = nethandlerplayclient.func_175106_d();
        if (!search) {
            range = 256.0;
        }
        AxisAlignedBB box = AxisAlignedBB.func_178781_a((double)(mc.field_71439_g.field_70165_t - range), (double)(mc.field_71439_g.field_70163_u - range), (double)(mc.field_71439_g.field_70161_v - range), (double)(mc.field_71439_g.field_70165_t + range), (double)(mc.field_71439_g.field_70163_u + range), (double)(mc.field_71439_g.field_70161_v + range));
        List entities = mc.field_71441_e.func_72872_a(EntityPlayer.class, box);
        block0: for (Object element : list) {
            if (!(element instanceof NetworkPlayerInfo)) continue;
            NetworkPlayerInfo info = (NetworkPlayerInfo)element;
            String infoName = SAOMod.unformatName(info.func_178845_a().getName());
            for (Object element0 : entities) {
                EntityPlayer player;
                String playerName;
                if (!(element0 instanceof EntityPlayer) || !infoName.equals(playerName = SAOMod.getName(player = (EntityPlayer)element0))) continue;
                players.add(player);
                continue block0;
            }
        }
        return players;
    }

    public static final List<EntityPlayer> listOnlinePlayers(Minecraft mc) {
        return SAOMod.listOnlinePlayers(mc, true, (double)mc.field_71474_y.field_151451_c * 16.0);
    }

    public static EntityPlayer findOnlinePlayer(Minecraft mc, String username) {
        List<EntityPlayer> players = SAOMod.listOnlinePlayers(mc);
        for (EntityPlayer player : players) {
            if (!SAOMod.getName(player).equals(username)) continue;
            return player;
        }
        return null;
    }

    public static final boolean[] isOnline(Minecraft mc, String[] names) {
        List<EntityPlayer> players = SAOMod.listOnlinePlayers(mc);
        boolean[] online = new boolean[names.length];
        block0: for (int i = 0; i < names.length; ++i) {
            for (EntityPlayer player : players) {
                if (!SAOMod.getName(player).equals(names[i])) continue;
                online[i] = true;
                continue block0;
            }
        }
        return online;
    }

    public static final boolean isOnline(Minecraft mc, String name) {
        return SAOMod.isOnline(mc, new String[]{name})[0];
    }

    public static final void sendSAOCommand(Minecraft mc, SAOCommand command, String username, String ... args) {
        if (mc.field_71439_g == null || !SAOOption.CLIENT_CHAT_PACKETS.value) {
            return;
        }
        String format = I18n.func_135052_a((String)"commands.message.usage", (Object[])new Object[0]);
        String cmd = format.substring(0, format.indexOf(32));
        String message = SAOJ8String.join(" ", cmd, username, String.valueOf((Object)command), SAOJ8String.join(" ", args));
        mc.field_71439_g.func_71165_d(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void receiveSAOCommand(final Minecraft mc, SAOCommand command, final String username, final String ... args) {
        if (mc.field_71439_g == null || !SAOOption.CLIENT_CHAT_PACKETS.value) {
            return;
        }
        if (command == SAOCommand.INVITE_PARTY) {
            if (!SAOMod.isPartyMember(SAOMod.getName(mc))) {
                final GuiScreen keepScreen = mc.field_71462_r;
                final boolean ingameFocus = mc.field_71415_G;
                String text = String.format(_PARTY_INVITATION_TEXT, username);
                mc.func_147108_a((GuiScreen)SAOWindowViewGUI.viewConfirm(_PARTY_INVITATION_TITLE, text, new SAOActionHandler(){

                    @Override
                    public void actionPerformed(SAOElementGUI element, SAOAction action, int data) {
                        SAOID id = element.ID();
                        if (id == SAOID.CONFIRM) {
                            SAOMod.access$102(args.length > 0 ? args : null);
                            if (party != null) {
                                partyTicks = 1000;
                            }
                            SAOMod.sendSAOCommand(mc, SAOCommand.CONFIRM_INVITE_PARTY, username, new String[0]);
                        } else {
                            SAOMod.sendSAOCommand(mc, SAOCommand.CANCEL_INVITE_PARTY, username, new String[0]);
                        }
                        mc.func_147108_a(keepScreen);
                        if (ingameFocus) {
                            mc.func_71381_h();
                        } else {
                            mc.func_71364_i();
                        }
                    }
                }));
                if (ingameFocus) {
                    mc.func_71364_i();
                }
            }
        } else if (command == SAOCommand.DISSOLVE_PARTY) {
            if (SAOMod.isPartyLeader(SAOMod.getName(mc))) {
                SAOMod.removeParty(mc, username);
            } else if (SAOMod.isPartyLeader(username)) {
                SAOWindowGUI window = SAOMod.getWindow(mc);
                if (window != null && window.getTitle().equals(_PARTY_INVITATION_TITLE) && window instanceof SAOConfirmGUI) {
                    ((SAOConfirmGUI)window).cancel();
                }
                party = null;
            }
        } else if (command == SAOCommand.UPDATE_PARTY) {
            if (SAOMod.isPartyLeader(username)) {
                party = args.length <= 1 ? null : args;
            }
        } else if (command == SAOCommand.CONFIRM_INVITE_PARTY) {
            if (SAOMod.isPartyLeader(SAOMod.getName(mc))) {
                boolean inParty = SAOMod.isPartyMember(username);
                if (inParty && args.length > 0) {
                    SAOMod.addParty(mc, args[0]);
                } else {
                    SAOMod.addParty(mc, username);
                }
            } else if (SAOMod.isPartyMember(SAOMod.getName(mc))) {
                SAOMod.sendSAOCommand(mc, command, party[0], username);
            } else {
                SAOMod.sendSAOCommand(mc, SAOCommand.DISSOLVE_PARTY, username, new String[0]);
            }
        } else if (command == SAOCommand.ADD_FRIEND_REQUEST) {
            if (!SAOMod.isFriend(username)) {
                final GuiScreen keepScreen = mc.field_71462_r;
                final boolean ingameFocus = mc.field_71415_G;
                String text = String.format(_FRIEND_REQUEST_TEXT, username);
                mc.func_147108_a((GuiScreen)SAOWindowViewGUI.viewConfirm(_FRIEND_REQUEST_TITLE, text, new SAOActionHandler(){

                    @Override
                    public void actionPerformed(SAOElementGUI element, SAOAction action, int data) {
                        SAOID id = element.ID();
                        if (id == SAOID.CONFIRM && (SAOMod.isFriend(username) || SAOMod.addFriends(username))) {
                            SAOMod.sendSAOCommand(mc, SAOCommand.ACCEPT_ADD_FRIEND, username, new String[0]);
                        } else {
                            SAOMod.sendSAOCommand(mc, SAOCommand.CANCEL_ADD_FRIEND, username, new String[0]);
                        }
                        mc.func_147108_a(keepScreen);
                        if (ingameFocus) {
                            mc.func_71381_h();
                        } else {
                            mc.func_71364_i();
                        }
                    }
                }));
                if (ingameFocus) {
                    mc.func_71364_i();
                }
            } else {
                SAOMod.sendSAOCommand(mc, SAOCommand.ACCEPT_ADD_FRIEND, username, new String[0]);
            }
        } else {
            if (command == SAOCommand.ACCEPT_ADD_FRIEND) {
                List<SAOFriendRequest> list = friendRequests;
                synchronized (list) {
                    int index = -1;
                    for (int i = 0; i < friendRequests.size(); ++i) {
                        if (!friendRequests.get(i).equals(username)) continue;
                        index = i;
                        break;
                    }
                    if (index >= 0 && (SAOMod.isFriend(username) || SAOMod.addFriends(username))) {
                        friendRequests.remove(index);
                    }
                }
            }
            if (command == SAOCommand.CANCEL_ADD_FRIEND) {
                List<SAOFriendRequest> list = friendRequests;
                synchronized (list) {
                    int index = -1;
                    for (int i = 0; i < friendRequests.size(); ++i) {
                        if (!friendRequests.get(i).equals(username)) continue;
                        index = i;
                        break;
                    }
                    if (index >= 0) {
                        friendRequests.remove(index);
                    }
                }
            }
        }
    }

    private static final String[] loadFriends() {
        try {
            String[] friends;
            FileInputStream stream = new FileInputStream(friendsFile);
            if (stream.available() != 0) {
                int count = stream.read() & 0xFF;
                friends = new String[count];
                for (int i = 0; i < count; ++i) {
                    int length = stream.read() & 0xFF;
                    byte[] bytes = new byte[length];
                    stream.read(bytes, 0, length);
                    friends[i] = new String(bytes);
                }
            } else {
                friends = new String[]{};
            }
            stream.close();
            return friends;
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public static final String[] listFriends() {
        if (friends == null) {
            friends = SAOMod.loadFriends();
        }
        return friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addFriendRequest(Minecraft mc, String ... names) {
        List<SAOFriendRequest> list = friendRequests;
        synchronized (list) {
            for (String name : names) {
                if (friendRequests.contains(name) || SAOMod.isFriend(name)) continue;
                friendRequests.add(new SAOFriendRequest(name, 10000));
                SAOMod.sendSAOCommand(mc, SAOCommand.ADD_FRIEND_REQUEST, name, new String[0]);
            }
        }
    }

    public static final boolean addFriends(String ... names) {
        friends = SAOMod.listFriends();
        String[] newNames = new String[names.length];
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            boolean found = false;
            for (int j = 0; j < friends.length; ++j) {
                if (!friends[j].equals(names[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            newNames[index++] = names[i];
        }
        if (index > 0) {
            String[] resized = new String[index];
            System.arraycopy(newNames, 0, resized, 0, resized.length);
            return SAOMod.addRawFriends(resized);
        }
        return true;
    }

    public static final boolean isFriend(String name) {
        for (String friend : SAOMod.listFriends()) {
            if (!name.equals(friend)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isFriend(EntityPlayer player) {
        return SAOMod.isFriend(SAOMod.getName(player));
    }

    private static final boolean addRawFriends(String[] names) {
        friends = SAOMod.listFriends();
        String[] resized = new String[friends.length + names.length];
        System.arraycopy(friends, 0, resized, 0, friends.length);
        System.arraycopy(names, 0, resized, friends.length, names.length);
        if (SAOMod.writeFriends(resized)) {
            friends = resized;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean writeFriends(String[] friends) {
        String[] data = friends == null ? new String[]{} : friends;
        File file = friendsFile;
        synchronized (file) {
            try {
                FileOutputStream stream = new FileOutputStream(friendsFile);
                int count = data.length % 256;
                stream.write(count);
                for (int i = 0; i < count; ++i) {
                    byte[] bytes = data[i].getBytes();
                    int length = bytes.length % 256;
                    stream.write(length);
                    stream.write(bytes, 0, length);
                }
                stream.flush();
                stream.close();
                return true;
            }
            catch (IOException e) {
                if (DEBUG) {
                    System.out.println(e);
                }
                return false;
            }
        }
    }

    public static final String[] listPartyMembers() {
        return party;
    }

    public static final boolean isPartyMember(String username) {
        if (party != null) {
            for (String member : party) {
                if (!member.equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isPartyLeader(String username) {
        return party != null && party[0].equals(username);
    }

    private static final void addParty(Minecraft mc, String username) {
        if (party != null && !SAOMod.isPartyMember(username)) {
            String[] resized = new String[party.length + 1];
            System.arraycopy(party, 0, resized, 0, party.length);
            resized[SAOMod.party.length] = username;
            party = resized;
            SAOMod.updateParty(mc);
        }
    }

    private static final void removeParty(Minecraft mc, String username) {
        if (SAOMod.isPartyMember(username)) {
            String[] resized = new String[party.length - 1];
            int index = 0;
            for (String member : party) {
                if (member.equals(username)) continue;
                resized[index++] = member;
            }
            if (resized.length > 1) {
                party = resized;
                SAOMod.updateParty(mc);
            } else {
                party = null;
            }
        }
    }

    private static final void updateParty(Minecraft mc) {
        if (party != null) {
            String memberString = SAOJ8String.join(" ", party);
            for (String member : party) {
                if (member.equals(SAOMod.getName(mc))) continue;
                SAOMod.sendSAOCommand(mc, SAOCommand.UPDATE_PARTY, member, memberString);
            }
        }
    }

    public static final boolean createParty(Minecraft mc, double range) {
        List<EntityPlayer> found = SAOMod.listOnlinePlayers(mc, true, range);
        if (found.contains(mc.field_71439_g)) {
            found.remove(mc.field_71439_g);
        }
        if (found.size() > 0) {
            party = new String[]{SAOMod.getName(mc)};
            partyTicks = 10000;
            for (EntityPlayer player : found) {
                SAOMod.inviteParty(mc, SAOMod.getName(player));
            }
            return true;
        }
        return false;
    }

    public static final void inviteParty(Minecraft mc, String username) {
        if (party != null && !SAOMod.isPartyMember(username)) {
            SAOMod.sendSAOCommand(mc, SAOCommand.INVITE_PARTY, username, party[0]);
        }
    }

    public static final void dissolveParty(Minecraft mc) {
        if (party != null) {
            if (party[0].equals(SAOMod.getName(mc))) {
                for (int i = 1; i < party.length; ++i) {
                    SAOMod.sendSAOCommand(mc, SAOCommand.DISSOLVE_PARTY, party[i], new String[0]);
                }
            } else {
                SAOMod.sendSAOCommand(mc, SAOCommand.DISSOLVE_PARTY, party[0], new String[0]);
            }
        }
        partyTicks = 0;
        party = null;
    }

    public static final String getName(EntityPlayer player) {
        return player == null ? "" : player.func_70005_c_();
    }

    public static final String getName(Minecraft mc) {
        return SAOMod.getName((EntityPlayer)mc.field_71439_g);
    }

    public static final String unformatName(String name) {
        int index = name.indexOf("\u00ef\u00bf\u00bd");
        while (index != -1) {
            name = index + 1 < name.length() ? name.replace(name.substring(index, index + 2), "") : name.replace("\u00ef\u00bf\u00bd", "");
            index = name.indexOf("\u00ef\u00bf\u00bd");
        }
        return name;
    }

    public static final SAOWindowGUI getWindow(Minecraft mc) {
        if (mc.field_71462_r != null && mc.field_71462_r instanceof SAOWindowViewGUI) {
            return ((SAOWindowViewGUI)mc.field_71462_r).getWindow();
        }
        return null;
    }

    public static final float getHealth(Minecraft mc, Entity entity, float time) {
        if (SAOOption.SMOOTH_HEALTH.value) {
            float healthReal;
            UUID uuid = entity.func_110124_au();
            if (entity instanceof EntityLivingBase) {
                healthReal = ((EntityLivingBase)entity).func_110143_aJ();
            } else {
                float f = healthReal = entity.field_70128_L ? 0.0f : 1.0f;
            }
            if (healthSmooth.containsKey(uuid)) {
                float healthValue = healthSmooth.get(uuid).floatValue();
                if (healthReal <= 0.0f && entity instanceof EntityLivingBase) {
                    float value = (float)(18 - ((EntityLivingBase)entity).field_70725_aQ) / 18.0f;
                    if (value <= 0.0f) {
                        healthSmooth.remove(uuid);
                    }
                    return healthValue * value;
                }
                healthValue = Math.round(healthValue * 10.0f) != Math.round(healthReal * 10.0f) ? (healthValue += (healthReal - healthValue) * (SAOMod.gameTimeDelay(mc, time) * 0.075f)) : healthReal;
                healthSmooth.put(uuid, Float.valueOf(healthValue));
                return healthValue;
            }
            healthSmooth.put(uuid, Float.valueOf(healthReal));
            return healthReal;
        }
        return entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110143_aJ() : (entity.field_70128_L ? 0.0f : 1.0f);
    }

    private static final int gameFPS(Minecraft mc) {
        ArrayList<String> output = new ArrayList<String>();
        if (SAONewChatGUI.reformat(mc.field_71426_K, "%s fps, %s chunk updates", output)) {
            try {
                return Integer.parseInt((String)output.get(0));
            }
            catch (NumberFormatException e) {
                return mc.func_90020_K();
            }
        }
        return mc.func_90020_K();
    }

    private static final float gameTimeDelay(Minecraft mc, float time) {
        if (time >= 0.0f) {
            return time;
        }
        return 36.0f / (float)SAOMod.gameFPS(mc);
    }

    public static final float getMaxHealth(Entity entity) {
        return entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110138_aP() : 1.0f;
    }

    public static final SAOColorState getColorState(EntityPlayer entity) {
        UUID uuid = entity.func_110124_au();
        if (!colorStates.containsKey(uuid)) {
            colorStates.put(uuid, new SAOColorCursor());
        }
        return colorStates.get(uuid).get();
    }

    public static final void onDamagePlayer(EntityPlayer entity) {
        UUID uuid = entity.func_110124_au();
        if (colorStates.containsKey(uuid)) {
            colorStates.get(uuid).set(SAOColorState.VIOLENT);
        } else {
            colorStates.put(uuid, new SAOColorCursor(SAOColorState.VIOLENT, true));
        }
    }

    public static final void onKillPlayer(EntityPlayer entity) {
        UUID uuid = entity.func_110124_au();
        if (colorStates.containsKey(uuid)) {
            colorStates.get(uuid).set(SAOColorState.KILLER);
        } else {
            colorStates.put(uuid, new SAOColorCursor(SAOColorState.KILLER, true));
        }
    }

    public static final void setOption(SAOOption option) {
        config.get("general", "option." + option.name().toLowerCase(), option.value).set(option.value);
    }

    public static final void saveAllOptions() {
        config.save();
    }

    static /* synthetic */ String[] access$102(String[] x0) {
        party = x0;
        return x0;
    }

    static {
        REPLACE_GUI_DELAY = 0;
    }
}

