/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui;

import com.thejackimonster.saoui.SAOIngameGUI;
import com.thejackimonster.saoui.SAOMod;
import com.thejackimonster.saoui.util.SAOCommand;
import com.thejackimonster.saoui.util.SAOOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAONewChatGUI
extends GuiNewChat {
    private static final String[] kills = new String[]{"death.fell.assist", "death.fell.assist.item", "death.fell.finish", "death.fell.finish.item", "death.attack.inFire.player", "death.attack.onFire.player", "death.attack.lava.player", "death.attack.drown.player", "death.attack.cactus.player", "death.attack.explosion.player", "death.attack.mob", "death.attack.player", "death.attack.player.item", "death.attack.arrow", "death.attack.arrow.item", "death.attack.fireball", "death.attack.fireball.item", "death.attack.thrown", "death.attack.thrown.item", "death.attack.indirectMagic", "death.attack.indirectMagic.item", "death.attack.thorns"};
    private final SAOIngameGUI parent;
    private final List<String> input;
    private final Minecraft minecraft;
    private final GuiNewChat oldChat;

    public SAONewChatGUI(SAOIngameGUI gui, Minecraft mc, GuiNewChat chat) {
        super(mc);
        this.parent = gui;
        this.input = new ArrayList<String>();
        this.minecraft = mc;
        this.oldChat = chat;
    }

    public void func_146234_a(IChatComponent chat, int flag) {
        String text = chat.func_150260_c();
        for (String kill : kills) {
            EntityPlayer killer;
            this.input.clear();
            if (!SAONewChatGUI.reformat(text, I18n.func_135052_a((String)kill, (Object[])new Object[0]), this.input) || this.input.size() != (kill.endsWith(".item") ? 3 : 2)) continue;
            String username = SAOMod.unformatName(this.input.get(0));
            String killername = SAOMod.unformatName(this.input.get(1));
            if (!SAOMod.isOnline(this.minecraft, username) || (killer = SAOMod.findOnlinePlayer(this.minecraft, killername)) == null) continue;
            SAOMod.onKillPlayer(killer);
        }
        if (SAOOption.CLIENT_CHAT_PACKETS.value) {
            String format0 = I18n.func_135052_a((String)"commands.message.display.incoming", (Object[])new Object[]{"%s", "%s"});
            String format1 = I18n.func_135052_a((String)"commands.message.display.outgoing", (Object[])new Object[]{"%s", "%s"});
            this.input.clear();
            if (SAONewChatGUI.reformat(text, format0, this.input) && this.input.size() == 2) {
                SAOCommand command;
                String username = SAOMod.unformatName(this.input.get(0));
                String message = this.input.get(1);
                if (SAOMod.DEBUG) {
                    System.out.println("[SAO] " + text.replace(this.input.get(0), username));
                }
                if ((command = SAOCommand.getCommand(message)) != null) {
                    SAOMod.receiveSAOCommand(this.minecraft, command, username, command.getContent(message));
                } else {
                    this.parent.onMessage(username, message);
                }
            } else if (!SAONewChatGUI.reformat(text, format1, this.input)) {
                super.func_146234_a(chat, flag);
            }
        } else {
            super.func_146234_a(chat, flag);
        }
        this.oldChat.func_146234_a(chat, flag);
    }

    protected static final boolean reformat(String string, String format, List<String> output) {
        int formatIndex = 0;
        int stringIndex = 0;
        while (formatIndex < format.length()) {
            char messageChar;
            char formatChar = format.charAt(formatIndex);
            if (formatChar == '%' && formatIndex + 1 < format.length() && (format.charAt(formatIndex + 1) == 's' || format.charAt(formatIndex + 1) == 'd' || format.charAt(formatIndex + 1) == 'i' || format.charAt(formatIndex + 1) == 'f' || format.charAt(formatIndex + 1) == 'c')) {
                char messageChar2;
                char endChar;
                String input = "";
                char c = endChar = (formatIndex += 2) < format.length() ? format.charAt(formatIndex) : (char)'\u0000';
                while (stringIndex < string.length() && (messageChar2 = string.charAt(stringIndex)) != endChar) {
                    input = input + messageChar2;
                    ++stringIndex;
                }
                output.add(input);
                continue;
            }
            if (stringIndex >= string.length() || (messageChar = string.charAt(stringIndex)) != formatChar) break;
            ++formatIndex;
            ++stringIndex;
        }
        return stringIndex >= string.length() && formatIndex >= format.length();
    }
}

