/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui;

import com.thejackimonster.saoui.SAOEntityPiecesFX;
import com.thejackimonster.saoui.SAOMod;
import com.thejackimonster.saoui.SAOSound;
import com.thejackimonster.saoui.util.SAOColorState;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOHealthStep;
import com.thejackimonster.saoui.util.SAOOption;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SAORenderBase
extends RenderPlayer {
    private static final int HEALTH_COUNT = 32;
    private static final double HEALTH_ANGLE = (double)0.35f;
    private static final double HEALTH_RANGE = (double)0.975f;
    private static final float HEALTH_OFFSET = 0.75f;
    private static final float HEALTH_OFFSET_PLAYER = -0.125f;
    private static final double HEALTH_HEIGHT = (double)0.21f;
    private static final double PIECES_X_OFFSET = 0.02;
    private static final double PIECES_Y_OFFSET = -0.02;
    private static final int PIECES_COUNT = 150;
    private static final double PIECES_SPEED = 1.4;
    private static final double PIECES_GRAVITY = 0.4;
    private final Render parent;

    public SAORenderBase(Render render) {
        super(render.func_177068_d());
        this.parent = render;
    }

    public void func_177138_b(AbstractClientPlayer player) {
        if (this.parent instanceof RenderPlayer) {
            ((RenderPlayer)this.parent).func_177138_b(player);
        }
    }

    public void func_177139_c(AbstractClientPlayer player) {
        if (this.parent instanceof RenderPlayer) {
            ((RenderPlayer)this.parent).func_177139_c(player);
        }
    }

    public boolean func_177071_a(Entity p_177071_1_, ICamera p_177071_2_, double p_177071_3_, double p_177071_5_, double p_177071_7_) {
        return this.parent.func_177071_a(p_177071_1_, p_177071_2_, p_177071_3_, p_177071_5_, p_177071_7_);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f0, float f1) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean dead = false;
        boolean deadStart = false;
        boolean deadExactly = false;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            dead = SAOMod.getHealth(mc, (Entity)living, -1.0f) <= 0.0f;
            deadStart = living.field_70725_aQ == 1;
            boolean bl = deadExactly = living.field_70725_aQ >= 18;
            if (deadStart) {
                ++living.field_70725_aQ;
            }
        } else if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            deadStart = item.func_174872_o() + 16 >= item.lifespan;
            deadExactly = item.func_174872_o() >= item.lifespan;
        }
        this.parent.func_76986_a(entity, x, y, z, f0, f1);
        if (entity instanceof EntityLivingBase && !dead && !entity.func_98034_c((EntityPlayer)mc.field_71439_g)) {
            if (SAOOption.COLOR_CURSOR.value) {
                this.doRenderColorCursor(mc, entity, x, y, z, 64);
            }
            if (SAOOption.HEALTH_BARS.value && !entity.equals((Object)mc.field_71439_g)) {
                this.doRenderHealthBar(mc, entity, x, y, z, f0, f1);
            }
        }
        if (SAOOption.PARTICLES.value) {
            if (deadStart) {
                SAOSound.playAtEntity(entity, "sao.particles.death");
            }
            if (deadExactly) {
                this.doSpawnDeathParticles(mc, entity);
                entity.func_70106_y();
            }
        }
    }

    public void func_110776_a(ResourceLocation location) {
        this.parent.func_110776_a(location);
    }

    public void func_76979_b(Entity p_76979_1_, double p_76979_2_, double p_76979_4_, double p_76979_6_, float p_76979_8_, float p_76979_9_) {
        this.parent.func_76979_b(p_76979_1_, p_76979_2_, p_76979_4_, p_76979_6_, p_76979_8_, p_76979_9_);
    }

    public FontRenderer func_76983_a() {
        return this.parent.func_76983_a();
    }

    public RenderManager func_177068_d() {
        return this.parent.func_177068_d();
    }

    private void doRenderColorCursor(Minecraft mc, Entity entity, double x, double y, double z, int distance) {
        double d3 = entity.func_70068_e(this.field_76990_c.field_78734_h);
        if (d3 <= (double)(distance * distance)) {
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.0f), (float)((float)y + entity.field_70131_O + 1.1f), (float)((float)z));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.func_179140_f();
            SAOGL.glDepthTest(true);
            SAOGL.glBlend(true);
            SAOGL.tryBlendFuncSeparate(770, 771, 1, 0);
            SAOGL.glBindTexture(SAOResources.entities);
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_178970_b();
            SAOColorState.getColorState(mc, entity, -1.0f).glColor();
            tessellator.func_178180_c().func_178985_a(-9.0, -1.0, 0.0, 0.0, 0.25);
            tessellator.func_178180_c().func_178985_a(-9.0, 17.0, 0.0, 0.0, 0.375);
            tessellator.func_178180_c().func_178985_a(9.0, 17.0, 0.0, 0.125, 0.375);
            tessellator.func_178180_c().func_178985_a(9.0, -1.0, 0.0, 0.125, 0.25);
            tessellator.func_78381_a();
            SAOGL.glBlend(false);
            SAOGL.glColor(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    private void doRenderHealthBar(Minecraft mc, Entity entity, double x, double y, double z, float f0, float f1) {
        double z0;
        double y0;
        double x0;
        double rad;
        double value;
        int i;
        SAOGL.glBindTexture(SAOResources.entities);
        Tessellator tessellator = Tessellator.func_178181_a();
        SAOGL.glDepthTest(true);
        SAOGL.glCullFace(false);
        SAOGL.glBlend(true);
        SAOGL.blendFunc(770, 771);
        int hitPoints = (int)(this.getHealthFactor(mc, entity, -1.0f) * 32.0f);
        this.useColor(mc, entity, -1.0f);
        tessellator.func_178180_c().func_178964_a(5);
        for (i = 0; i <= hitPoints; ++i) {
            value = (double)(i + 32 - hitPoints) / 32.0;
            rad = Math.toRadians(this.field_76990_c.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
            x0 = x + (double)entity.field_70130_N * (double)0.975f * Math.cos(rad);
            y0 = y + (double)(entity.field_70131_O * 0.75f);
            z0 = z + (double)entity.field_70130_N * (double)0.975f * Math.sin(rad);
            double uv_value = value - (double)(32 - hitPoints) / 32.0;
            tessellator.func_178180_c().func_178985_a(x0, y0 + (double)0.21f, z0, 1.0 - uv_value, 0.0);
            tessellator.func_178180_c().func_178985_a(x0, y0, z0, 1.0 - uv_value, 0.125);
        }
        tessellator.func_78381_a();
        SAOGL.glColor(1.0f, 1.0f, 1.0f, 1.0f);
        tessellator.func_178180_c().func_178964_a(5);
        for (i = 0; i <= 32; ++i) {
            value = (double)i / 32.0;
            rad = Math.toRadians(this.field_76990_c.field_78735_i - 135.0f) + (value - 0.5) * Math.PI * (double)0.35f;
            x0 = x + (double)entity.field_70130_N * (double)0.975f * Math.cos(rad);
            y0 = y + (double)(entity.field_70131_O * 0.75f);
            z0 = z + (double)entity.field_70130_N * (double)0.975f * Math.sin(rad);
            tessellator.func_178180_c().func_178985_a(x0, y0 + (double)0.21f, z0, 1.0 - value, 0.125);
            tessellator.func_178180_c().func_178985_a(x0, y0, z0, 1.0 - value, 0.25);
        }
        tessellator.func_78381_a();
        SAOGL.glCullFace(true);
    }

    private final void doSpawnDeathParticles(Minecraft mc, Entity entity) {
        World world = entity.field_70170_p;
        if (world != null) {
            float[][] colors = new float[][]{{0.6039216f, 0.9960785f, 0.18039216f}, {0.003921569f, 1.0f, 1.0f}, {0.03137255f, 0.03137255f, 0.5411765f}};
            float size = entity.field_70130_N * entity.field_70131_O;
            int pieces = (int)Math.max(Math.min(size * 64.0f, 128.0f), 8.0f);
            for (int i = 0; i < pieces; ++i) {
                float[] color = colors[i % 3];
                double x0 = (double)entity.field_70130_N * (Math.random() * 2.0 - 1.0) * 0.75;
                double y0 = (double)entity.field_70131_O * Math.random();
                double z0 = (double)entity.field_70130_N * (Math.random() * 2.0 - 1.0) * 0.75;
                mc.field_71452_i.func_78873_a((EntityFX)new SAOEntityPiecesFX(world, entity.field_70165_t + x0, entity.field_70163_u + y0, entity.field_70161_v + z0, color[0], color[1], color[2]));
            }
        }
    }

    private final void useColor(Minecraft mc, Entity entity, float time) {
        if (entity instanceof EntityLivingBase) {
            SAOHealthStep.getStep(mc, (EntityLivingBase)entity, time).glColor((EntityLivingBase)entity);
        } else {
            SAOHealthStep.GOOD.glColor();
        }
    }

    private final float getHealthFactor(Minecraft mc, Entity entity, float time) {
        float normalFactor = SAOMod.getHealth(mc, entity, time) / SAOMod.getMaxHealth(entity);
        float delta = 1.0f - normalFactor;
        return normalFactor + delta * delta / 2.0f * normalFactor;
    }
}

