/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;

public class SAOAlertGUI
extends SAOElementGUI {
    public String caption;
    public int alertColor;

    public SAOAlertGUI(SAOParentGUI gui, int xPos, int yPos, int w, String string, int color) {
        super(gui, xPos, yPos, w, 32);
        this.caption = string;
        this.alertColor = color;
    }

    public SAOAlertGUI(SAOParentGUI gui, int xPos, int yPos, String string, int color) {
        this(gui, xPos, yPos, SAOAlertGUI.autoWidth(string), string, color);
    }

    private static final int autoWidth(String string) {
        int defValue = SAOGL.glStringWidth(string);
        return Math.max(0, defValue - 20);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            SAOGL.glBindTexture(SAOResources.gui);
            int color = this.mouseOver(cursorX, cursorY) ? SAOColor.mediumColor(this.alertColor, -2004317953) : this.alertColor;
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color, this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            SAOGL.glTexturedRect(left - 20, top, 0, 145, 20, this.height);
            SAOGL.glTexturedRect(left, top, this.width, this.height, 20, 145, 40, this.height);
            SAOGL.glTexturedRect(left + this.width, top, 60, 145, 20, this.height);
            SAOGL.glString(this.caption, left + (this.width - SAOGL.glStringWidth(this.caption)) / 2, top + (this.height - SAOGL.glStringHeight()) / 2, this.alertColor);
        }
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return button == 0;
    }

    @Override
    public int getX(boolean relative) {
        return super.getX(relative) - this.width / 2;
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) - this.height / 2;
    }

    @Override
    public SAOID ID() {
        return SAOID.ALERT;
    }
}

