/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOIcon;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOButtonGUI
extends SAOElementGUI {
    private final SAOID id;
    public String caption;
    public SAOIcon icon;
    public boolean highlight;

    public SAOButtonGUI(SAOParentGUI gui, SAOID saoID, int xPos, int yPos, int w, int h, String string, SAOIcon saoIcon) {
        super(gui, xPos, yPos, w, h);
        this.id = saoID;
        this.caption = string;
        this.icon = saoIcon;
        this.highlight = false;
    }

    public SAOButtonGUI(SAOParentGUI gui, SAOID saoID, int xPos, int yPos, int w, String string, SAOIcon saoIcon) {
        this(gui, saoID, xPos, yPos, w, 20, string, saoIcon);
    }

    public SAOButtonGUI(SAOParentGUI gui, SAOID saoID, int xPos, int yPos, String string, SAOIcon saoIcon) {
        this(gui, saoID, xPos, yPos, 100, string, saoIcon);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            SAOGL.glBindTexture(SAOResources.gui);
            int hoverState = this.hoverState(cursorX, cursorY);
            int color0 = this.getColor(hoverState, true);
            int color1 = this.getColor(hoverState, false);
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color0, this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            int width2 = this.width / 2;
            int height2 = this.height / 2;
            SAOGL.glTexturedRect(left, top, 0, 45, width2, height2);
            SAOGL.glTexturedRect(left + width2, top, 200 - width2, 45, width2, height2);
            SAOGL.glTexturedRect(left, top + height2, 0, 65 - height2, width2, height2);
            SAOGL.glTexturedRect(left + width2, top + height2, 200 - width2, 65 - height2, width2, height2);
            int iconOffset = (this.height - 16) / 2;
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color1, this.visibility));
            SAOGL.glTexturedRect(left + iconOffset, top + iconOffset, 140, 25, 16, 16);
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color0, this.visibility));
            this.icon.glDraw(left + iconOffset, top + iconOffset);
            int captionOffset = (this.height - SAOGL.glStringHeight()) / 2;
            SAOGL.glString(this.caption, left + iconOffset * 2 + 16 + 4, top + captionOffset, SAOColor.multiplyAlpha(color1, this.visibility));
        }
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return button == 0;
    }

    protected int getColor(int hoverState, boolean bg) {
        if (bg) {
            return hoverState == 1 ? -1 : (hoverState >= 2 ? -524393729 : -190);
        }
        return hoverState == 1 ? -2004317953 : (hoverState >= 2 ? -1 : -2004318142);
    }

    public int hoverState(int cursorX, int cursorY) {
        if (this.mouseOver(cursorX, cursorY)) {
            return 2;
        }
        if (this.highlight) {
            return 3;
        }
        if (this.enabled) {
            return 1;
        }
        return 0;
    }

    @Override
    public SAOID ID() {
        return this.id;
    }
}

