/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOSlotGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOOption;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOCharacterViewGUI
extends SAOElementGUI {
    private final EntityPlayer character;
    private int clickIndex;

    public SAOCharacterViewGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h, EntityPlayer player) {
        super(gui, xPos, yPos, w, h);
        this.character = player;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        this.clickIndex = -1;
        if (this.visibility > 0.0f) {
            int size;
            SAOGL.glBindTexture(SAOResources.gui);
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(-1, this.visibility));
            int left = this.getX(false) + this.width / 2;
            int top = this.getY(false) + this.height * 13 / 16;
            int shadowX = size = this.width * this.height / 550;
            int shadowY = size / 2 + Math.max(Math.min((cursorY - top) / 12, 0), -size / 2 + 2);
            int shadowOffset = Math.max((cursorY - top) / 10, 0);
            SAOGL.glTexturedRect(left - shadowX / 2, top - shadowY / 2, shadowX, shadowY, 200, 85, 56, 30);
            SAOCharacterViewGUI.drawCharacter(this.character, left, top, size, cursorX, cursorY);
            left = this.getX(false) + this.width / 2;
            top = this.getY(false) + this.height / 2;
            int width2 = this.width / 2 - 14;
            int height2 = this.height / 2 - 14;
            for (int angle = 0; angle < 12; ++angle) {
                int x = (int)((double)left + Math.sin(Math.toRadians(angle * 30)) * (double)width2);
                int y = (int)((double)top + Math.cos(Math.toRadians(angle * 30)) * (double)height2);
                boolean hovered = cursorX >= x - 10 && cursorY >= y - 10 && cursorX <= x + 10 && cursorY <= y + 10;
                SAOGL.glBindTexture(SAOResources.gui);
                SAOGL.glColorRGBA(SAOColor.multiplyAlpha(hovered ? -524393729 : -2004317953, this.visibility));
                SAOGL.glTexturedRect(x - 10, y - 10, 0, 25, 20, 20);
                if (angle + 4 >= 9 && angle + 4 < 12) continue;
                int index = angle + 4 >= 12 ? (angle - 8) % 9 : (angle + 4) % 9;
                Slot slot = this.character.field_71069_bz.func_75147_a((IInventory)this.character.field_71071_by, index);
                if (slot.func_75216_d() && slot.func_75211_c().func_77973_b() != null) {
                    SAOGL.glColorRGBA(SAOColor.multiplyAlpha(hovered ? -1 : -1, this.visibility));
                    SAOSlotGUI.getIcon(slot.func_75211_c()).glDraw(x - 8, y - 8);
                }
                if (!hovered) continue;
                this.clickIndex = index;
            }
        }
    }

    @Override
    public boolean keyTyped(Minecraft mc, char ch, int key) {
        if (this.character == mc.field_71439_g) {
            for (int i = 0; i < 9; ++i) {
                if (key != mc.field_71474_y.field_151456_ac[i].func_151463_i()) continue;
                this.character.field_71071_by.field_70461_c = i;
                return true;
            }
        }
        return super.keyTyped(mc, ch, key);
    }

    @Override
    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        if (this.clickIndex >= 0 && button == 0 && this.character == mc.field_71439_g) {
            this.character.field_71071_by.field_70461_c = this.clickIndex;
            return true;
        }
        return super.mousePressed(mc, cursorX, cursorY, button);
    }

    public static final void drawCharacter(EntityPlayer character, int x, int y, int size, int cursorX, int cursorY) {
        float mouseX = (float)x - (float)cursorX;
        float mouseY = (float)y - (float)size * 1.67f - (float)cursorY;
        boolean value = SAOOption.COLOR_CURSOR.value;
        SAOOption.COLOR_CURSOR.value = false;
        GuiInventory.func_147046_a((int)x, (int)y, (int)size, (float)mouseX, (float)mouseY, (EntityLivingBase)character);
        SAOOption.COLOR_CURSOR.value = value;
        SAOGL.glRescaleNormal(true);
        SAOGL.glTexture2D(true);
        SAOGL.glBlend(true);
        SAOGL.tryBlendFuncSeparate(770, 771, 1, 0);
    }
}

