/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOAction;
import com.thejackimonster.saoui.util.SAOParentGUI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOContainerGUI
extends SAOElementGUI {
    public final List<SAOElementGUI> elements = new ArrayList<SAOElementGUI>();

    public SAOContainerGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h) {
        super(gui, xPos, yPos, w, h);
    }

    @Override
    public void update(Minecraft mc) {
        this.focus = false;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            this.update(mc, i, this.elements.get(i));
        }
    }

    protected void update(Minecraft mc, int index, SAOElementGUI element) {
        if (element.removed()) {
            this.elements.remove(index);
            return;
        }
        element.update(mc);
        this.focus |= element.focus;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            this.elements.get(i).draw(mc, cursorX, cursorY);
        }
    }

    @Override
    public boolean keyTyped(Minecraft mc, char ch, int key) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get((int)i).focus || !this.elements.get(i).keyTyped(mc, ch, key)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.KEY_TYPED, key);
        }
        return super.keyTyped(mc, ch, key);
    }

    @Override
    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY) || !this.elements.get(i).mousePressed(mc, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.getAction(button, true), button);
        }
        return super.mousePressed(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY, button) || !this.elements.get(i).mouseReleased(mc, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.getAction(button, false), button);
        }
        return super.mouseReleased(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseWheel(Minecraft mc, int cursorX, int cursorY, int delta) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY) || !this.elements.get(i).mouseWheel(mc, cursorX, cursorY, delta)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.MOUSE_WHEEL, delta);
        }
        return super.mouseWheel(mc, cursorX, cursorY, delta);
    }

    @Override
    public void close(Minecraft mc) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            this.elements.get(i).close(mc);
            this.elements.remove(i);
        }
        super.close(mc);
    }
}

