/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.SAOSound;
import com.thejackimonster.saoui.util.SAOAction;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOParentGUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class SAOElementGUI
implements SAOParentGUI {
    public final SAOParentGUI parent;
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean enabled;
    public float visibility;
    public boolean focus;
    private boolean removed;

    public SAOElementGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h) {
        this.parent = gui;
        this.x = xPos;
        this.y = yPos;
        this.width = w;
        this.height = h;
        this.enabled = true;
        this.visibility = 1.0f;
        this.focus = false;
        this.removed = false;
    }

    public void update(Minecraft mc) {
    }

    public void draw(Minecraft mc, int cursorX, int cursorY) {
        if (this.mouseOver(cursorX, cursorY)) {
            this.mouseMoved(mc, cursorX, cursorY);
        }
    }

    public boolean keyTyped(Minecraft mc, char ch, int key) {
        return false;
    }

    public boolean mouseOver(int cursorX, int cursorY, int flag) {
        if (this.visibility >= 1.0f && this.enabled) {
            int left = this.getX(false);
            int top = this.getY(false);
            return cursorX >= left && cursorY >= top && cursorX <= left + this.width && cursorY <= top + this.height;
        }
        return false;
    }

    public final boolean mouseOver(int cursorX, int cursorY) {
        return this.mouseOver(cursorX, cursorY, -1);
    }

    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        return false;
    }

    public void mouseMoved(Minecraft mc, int cursorX, int cursorY) {
    }

    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return false;
    }

    public boolean mouseWheel(Minecraft mc, int cursorX, int cursorY, int delta) {
        return false;
    }

    @Override
    public int getX(boolean relative) {
        return relative ? this.x : this.x + (this.parent != null ? this.parent.getX(relative) : 0);
    }

    @Override
    public int getY(boolean relative) {
        return relative ? this.y : this.y + (this.parent != null ? this.parent.getY(relative) : 0);
    }

    public void click(SoundHandler handler, boolean flag) {
        if (flag) {
            SAOSound.play(handler, "sao.menu.popup");
        } else {
            SAOSound.play(handler, "sao.dialog.close");
        }
    }

    @Override
    public void actionPerformed(SAOElementGUI element, SAOAction action, int data) {
        if (this.parent != null) {
            this.parent.actionPerformed(element, action, data);
        }
    }

    public SAOID ID() {
        return SAOID.NONE;
    }

    public void close(Minecraft mc) {
        if (!this.removed) {
            this.remove();
        }
    }

    public void remove() {
        this.removed = true;
    }

    public boolean removed() {
        return this.removed;
    }

    public String toString() {
        return "[ ( " + this.getClass().getName() + " " + this.x + " " + this.y + " " + this.width + " " + this.height + " ) => " + this.parent + " ]";
    }
}

