/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.SAOSound;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOIcon;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOIconGUI
extends SAOElementGUI {
    private final SAOID id;
    public SAOIcon icon;
    public boolean highlight;
    public int bgColor;
    public int disabledMask;

    public SAOIconGUI(SAOParentGUI gui, SAOID saoID, int xPos, int yPos, SAOIcon saoIcon) {
        super(gui, xPos, yPos, 20, 20);
        this.id = saoID;
        this.icon = saoIcon;
        this.highlight = false;
        this.bgColor = -1;
        this.disabledMask = -190;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            SAOGL.glBindTexture(SAOResources.gui);
            int hoverState = this.hoverState(cursorX, cursorY);
            int color0 = this.getColor(hoverState, true);
            int color1 = this.getColor(hoverState, false);
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color0, this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            SAOGL.glTexturedRect(left, top, 0, 25, 20, 20);
            int iconOffset = 2;
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(color1, this.visibility));
            this.icon.glDraw(left + 2, top + 2);
        }
    }

    protected int getColor(int hoverState, boolean bg) {
        if (this.icon == SAOIcon.CONFIRM) {
            if (bg) {
                return hoverState == 1 ? 1199760383 : (hoverState == 2 ? 1654521855 : 0x4782E3FF & this.disabledMask);
            }
            return hoverState > 0 ? -1 : 0xFFFFFFFF & this.disabledMask;
        }
        if (this.icon == SAOIcon.CANCEL) {
            if (bg) {
                return hoverState == 1 ? -481867777 : (hoverState == 2 ? -10329345 : 0xE34747FF & this.disabledMask);
            }
            return hoverState > 0 ? -1 : 0xFFFFFFFF & this.disabledMask;
        }
        if (bg) {
            return hoverState == 1 ? this.bgColor : (hoverState == 2 ? -524393729 : this.bgColor & this.disabledMask);
        }
        return hoverState == 1 ? -2004317953 : (hoverState == 2 ? -1 : 0x888888FF & this.disabledMask);
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return button == 0;
    }

    @Override
    public void click(SoundHandler handler, boolean flag) {
        if (this.icon == SAOIcon.CONFIRM) {
            SAOSound.play(handler, "sao.confirm");
        } else {
            super.click(handler, flag);
        }
    }

    public int hoverState(int cursorX, int cursorY) {
        if (this.highlight || this.mouseOver(cursorX, cursorY)) {
            return 2;
        }
        if (this.enabled) {
            return 1;
        }
        return 0;
    }

    @Override
    public SAOID ID() {
        return this.id;
    }
}

