/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOListGUI;
import com.thejackimonster.saoui.ui.SAOSlotGUI;
import com.thejackimonster.saoui.util.SAOInventory;
import com.thejackimonster.saoui.util.SAOParentGUI;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOInventoryGUI
extends SAOListGUI {
    public final Container slots;
    public final SAOInventory filter;
    private boolean opened;

    public SAOInventoryGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h, Container containerSlots, SAOInventory inventory) {
        super(gui, xPos, yPos, w, h);
        this.slots = containerSlots;
        this.filter = inventory;
        this.opened = false;
    }

    @Override
    public void update(Minecraft mc) {
        if (!this.opened) {
            mc.field_71439_g.field_71070_bA = this.slots;
            this.opened = true;
        }
        super.update(mc);
        for (int i = 0; i < this.slots.field_75151_b.size(); ++i) {
            Slot slot = this.slots.func_75139_a(i);
            if (slot == null) continue;
            boolean state = this.equipped(slot.field_75222_d);
            ItemStack stack = slot.func_75211_c();
            boolean found = false;
            for (int j = this.elements.size() - 1; j >= 0; --j) {
                SAOSlotGUI gui;
                if (j >= this.elements.size() || !(this.elements.get(j) instanceof SAOSlotGUI) || (gui = (SAOSlotGUI)this.elements.get(j)).getSlotNumber() != slot.field_75222_d) continue;
                gui.refreshSlot(slot);
                if (gui.removed()) continue;
                if (this.filter.isFine(gui.getStack(), state)) {
                    found = true;
                    continue;
                }
                gui.remove();
            }
            if (found || stack == null || !this.filter.isFine(stack, state)) continue;
            if (state) {
                this.elements.add(0, new SAOSlotGUI(this, 0, this.getOffset(this.elements.size()), slot));
                continue;
            }
            this.elements.add(new SAOSlotGUI(this, 0, this.getOffset(this.elements.size()), slot));
        }
        this.slots.func_75142_b();
    }

    private final boolean equipped(int number) {
        boolean state = this.filter.equals((Object)SAOInventory.EQUIPMENT) ? number >= 5 && number < 9 : number >= 36 && number < 45;
        return state;
    }

    @Override
    protected void update(Minecraft mc, int index, SAOElementGUI element) {
        super.update(mc, index, element);
        if (element instanceof SAOSlotGUI) {
            SAOSlotGUI slot = (SAOSlotGUI)element;
            slot.highlight = this.equipped(slot.getSlotNumber());
        }
    }

    public void handleMouseClick(Minecraft mc, Slot slot, int slotNumber, int flag, int method) {
        if (slot != null) {
            slotNumber = slot.field_75222_d;
        }
        mc.field_71442_b.func_78753_a(this.slots.field_75152_c, slotNumber, flag, method, (EntityPlayer)mc.field_71439_g);
    }

    @Override
    public void close(Minecraft mc) {
        super.close(mc);
        if (mc.field_71439_g != null) {
            this.slots.func_75134_a((EntityPlayer)mc.field_71439_g);
        }
    }
}

