/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOAlign;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOParentGUI;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOLabelGUI
extends SAOElementGUI {
    public String caption;
    public int fontColor;
    public SAOAlign align;

    public SAOLabelGUI(SAOParentGUI gui, int xPos, int yPos, int width, String string, SAOAlign saoAlign) {
        super(gui, xPos, yPos, width, 20);
        this.caption = string;
        this.fontColor = -2004317953;
        this.align = saoAlign;
    }

    public SAOLabelGUI(SAOParentGUI gui, int xPos, int yPos, String string, SAOAlign saoAlign) {
        this(gui, xPos, yPos, 200, string, saoAlign);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            int left = this.align.getX(this, false, SAOGL.glStringWidth(this.caption)) + this.getOffsetX();
            int top = this.getY(false);
            SAOGL.glString(this.caption, left, top + (this.height - SAOGL.glStringHeight()) / 2, SAOColor.multiplyAlpha(this.fontColor, this.visibility));
        }
    }

    public int getOffsetX() {
        if (this.align == SAOAlign.LEFT) {
            return 8;
        }
        if (this.align == SAOAlign.RIGHT) {
            return -8;
        }
        return 0;
    }
}

