/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOMenuGUI;
import com.thejackimonster.saoui.util.SAOParentGUI;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOListGUI
extends SAOMenuGUI {
    private float scrolledValue;
    public int scrollValue;
    public int size;
    public int minSize;
    private int lastDragY;
    private int dragY;
    private boolean dragging;

    public SAOListGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h, int minH) {
        super(gui, xPos, yPos, w, h);
        this.fullArrow = false;
        this.scrollValue = 0;
        this.size = h;
        this.minSize = minH;
    }

    public SAOListGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h) {
        this(gui, xPos, yPos, w, h, 0);
    }

    @Override
    protected int getOffset(int index) {
        return Math.round((float)super.getOffset(index) - this.scrolledValue);
    }

    @Override
    protected int getSize() {
        return Math.max(Math.min(this.size, super.getOffset(this.elements.size())), this.minSize);
    }

    @Override
    protected void update(Minecraft mc, int index, SAOElementGUI element) {
        super.update(mc, index, element);
        int elementY = element.getY(false);
        int elementSize = element.height;
        int listY = this.getY(false);
        int listSize = this.getSize();
        element.visibility = elementY < listY ? Math.max(1.0f - (float)(listY - elementY) / (float)listSize, 0.0f) : (elementY + elementSize > listY + listSize ? Math.max(1.0f - (float)(elementY + elementSize - (listY + listSize)) / (float)listSize, 0.0f) : 1.0f);
        element.visibility = element.visibility < 0.6f ? 0.0f : (element.visibility *= element.visibility);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        this.scrolledValue = (this.scrolledValue + (float)this.scrollValue) / 2.0f;
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public boolean mouseOver(int cursorX, int cursorY, int flag) {
        if (!super.mouseOver(cursorX, cursorY, flag)) {
            if (this.dragging) {
                this.dragY += this.scroll(cursorY - this.lastDragY);
                this.lastDragY = cursorY;
            }
            this.dragging = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean mousePressed(Minecraft mc, int cursorX, int cursorY, int button) {
        if (button == 0) {
            this.dragY = 0;
            this.lastDragY = cursorY;
            this.dragging = true;
        }
        return super.mousePressed(mc, cursorX, cursorY, button);
    }

    @Override
    public void mouseMoved(Minecraft mc, int cursorX, int cursorY) {
        if (this.dragging) {
            this.dragY += this.scroll(cursorY - this.lastDragY);
            this.lastDragY = cursorY;
        }
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        boolean wasDragging = false;
        if (button == 0) {
            if (this.dragging) {
                this.dragY += this.scroll(cursorY - this.lastDragY);
                wasDragging = this.dragY > 0;
                this.lastDragY = cursorY;
            }
            this.dragging = false;
        }
        return !wasDragging && super.mouseReleased(mc, cursorX, cursorY, button);
    }

    @Override
    public boolean mouseWheel(Minecraft mc, int cursorX, int cursorY, int delta) {
        if (this.elements.size() > 0) {
            this.scroll(Math.abs(delta * 2 * this.getSize() / this.elements.size()) / delta);
        }
        return super.mouseWheel(mc, cursorX, cursorY, delta);
    }

    protected int scroll(int delta) {
        int value = this.scrollValue;
        this.scrollValue = Math.min(Math.max(this.scrollValue - delta, 0), super.getOffset(this.elements.size()) - this.getSize());
        return Math.abs(value - this.scrollValue);
    }
}

