/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOContainerGUI;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOMenuGUI
extends SAOContainerGUI {
    public boolean fullArrow = true;
    public boolean innerMenu = false;

    public SAOMenuGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h) {
        super(gui, xPos, yPos, w, h);
    }

    protected int getOffset(int index) {
        int start = 0;
        int offset = 0;
        while (start < this.elements.size() && start < index) {
            offset += this.getOffsetSize((SAOElementGUI)this.elements.get(start++));
        }
        return offset;
    }

    protected int getOffsetSize(SAOElementGUI element) {
        return element.height;
    }

    @Override
    public void update(Minecraft mc) {
        this.height = this.getSize();
        if (this.width <= 0) {
            for (SAOElementGUI element : this.elements) {
                if (element.width <= this.width) continue;
                this.width = element.width;
            }
        }
        super.update(mc);
    }

    protected int getSize() {
        return this.getOffset(this.elements.size());
    }

    @Override
    protected void update(Minecraft mc, int index, SAOElementGUI element) {
        element.y = this.getOffset(index);
        element.width = this.width - element.x;
        super.update(mc, index, element);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        if (this.visibility > 0.0f && this.parent != null && this.height > 0) {
            if (this.x > 0) {
                SAOGL.glBindTexture(SAOResources.gui);
                SAOGL.glColorRGBA(SAOColor.multiplyAlpha(-1, this.visibility));
                int left = this.getX(false);
                int top = this.getY(false);
                int arrowTop = super.getY(false) - this.height / 2;
                SAOGL.glTexturedRect(left - 2, top, 2, this.height, 40, 41, 2, 4);
                SAOGL.glTexturedRect(left - 10, arrowTop + (this.height - 10) / 2, 20, 25 + (this.fullArrow ? 10 : 0), 10, 10);
            } else if (this.x < 0) {
                SAOGL.glBindTexture(SAOResources.gui);
                SAOGL.glColorRGBA(SAOColor.multiplyAlpha(-1, this.visibility));
                int left = this.getX(false);
                int top = this.getY(false);
                int arrowTop = super.getY(false) - this.height / 2;
                SAOGL.glTexturedRect(left + this.width, top, 2, this.height, 40, 41, 2, 4);
                SAOGL.glTexturedRect(left + this.width, arrowTop + (this.height - 10) / 2, 30, 25 + (this.fullArrow ? 10 : 0), 10, 10);
            }
        }
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) - (relative || this.innerMenu ? 0 : this.height / 2);
    }
}

