/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.SAOIngameGUI;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOAction;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOCursorStatus;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOOption;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class SAOScreenGUI
extends GuiScreen
implements SAOParentGUI {
    public static final float ROTATION_FACTOR = 0.25f;
    public static SAOCursorStatus CURSOR_STATUS = SAOCursorStatus.SHOW;
    private int mouseX;
    private int mouseY;
    private int mouseDown;
    private float mouseDownValue;
    public final List<SAOElementGUI> elements = new ArrayList<SAOElementGUI>();
    private float[] rotationYaw;
    private float[] rotationPitch;
    private boolean grabbed = false;

    public void func_73866_w_() {
        if (CURSOR_STATUS != SAOCursorStatus.DEFAULT) {
            Mouse.setGrabbed((boolean)true);
            this.grabbed = true;
        }
        super.func_73866_w_();
        this.elements.clear();
        this.init();
    }

    protected void init() {
        if (this.field_146297_k.field_71439_g != null) {
            this.rotationYaw = new float[]{this.field_146297_k.field_71439_g.field_70177_z};
            this.rotationPitch = new float[]{this.field_146297_k.field_71439_g.field_70125_A};
        }
    }

    private final int getCursorX() {
        return SAOOption.CURSOR_MOVEMENT.value ? (this.field_146294_l / 2 - this.mouseX) / 2 : 0;
    }

    private final int getCursorY() {
        return SAOOption.CURSOR_MOVEMENT.value ? (this.field_146295_m / 2 - this.mouseY) / 2 : 0;
    }

    @Override
    public int getX(boolean relative) {
        return this.getCursorX();
    }

    @Override
    public int getY(boolean relative) {
        return this.getCursorY();
    }

    public void func_73876_c() {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            if (this.elements.get(i).removed()) {
                this.elements.get(i).close(this.field_146297_k);
                this.elements.remove(i);
                continue;
            }
            this.elements.get(i).update(this.field_146297_k);
        }
    }

    public void func_73863_a(int cursorX, int cursorY, float f) {
        this.mouseX = cursorX;
        this.mouseY = cursorY;
        if (this.field_146297_k.field_71439_g != null) {
            this.field_146297_k.field_71439_g.field_70177_z = this.rotationYaw[0] - (float)this.getCursorX() * 0.25f;
            this.field_146297_k.field_71439_g.field_70125_A = this.rotationPitch[0] - (float)this.getCursorY() * 0.25f;
        }
        super.func_73863_a(cursorX, cursorY, f);
        SAOGL.glStartUI(this.field_146297_k);
        SAOGL.glBlend(true);
        SAOGL.tryBlendFuncSeparate(770, 771, 1, 0);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            this.elements.get(i).draw(this.field_146297_k, cursorX, cursorY);
        }
        if (CURSOR_STATUS == SAOCursorStatus.SHOW) {
            SAOGL.glBindTexture(SAOResources.gui);
            SAOGL.glBlend(true);
            SAOGL.tryBlendFuncSeparate(770, 771, 1, 0);
            if (this.mouseDown != 0) {
                float fval = f * 0.1f;
                this.mouseDownValue = this.mouseDownValue + fval < 1.0f ? (this.mouseDownValue += fval) : 1.0f;
                SAOGL.glColorRGBA(SAOColor.multiplyAlpha(0x8EE1E8, this.mouseDownValue));
                SAOGL.glTexturedRect(cursorX - 7, cursorY - 7, 35, 115, 15, 15);
                SAOGL.glColorRGBA(-1);
            } else {
                this.mouseDownValue = 0.0f;
                SAOGL.glColorRGBA(0x8EE1E8);
            }
            SAOGL.glTexturedRect(cursorX - 7, cursorY - 7, 20, 115, 15, 15);
        }
        SAOGL.glEndUI(this.field_146297_k);
    }

    protected void func_73869_a(char ch, int key) throws IOException {
        super.func_73869_a(ch, key);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get((int)i).focus || !this.elements.get(i).keyTyped(this.field_146297_k, ch, key)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.KEY_TYPED, key);
        }
    }

    protected void func_73864_a(int cursorX, int cursorY, int button) throws IOException {
        super.func_73864_a(cursorX, cursorY, button);
        this.mouseDown |= 1 << button;
        boolean clickedElement = false;
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY)) continue;
            if (this.elements.get(i).mousePressed(this.field_146297_k, cursorX, cursorY, button)) {
                this.actionPerformed(this.elements.get(i), SAOAction.getAction(button, true), button);
            }
            clickedElement = true;
        }
        if (!clickedElement) {
            this.backgroundClicked(cursorX, cursorY, button);
        }
    }

    protected void func_146286_b(int cursorX, int cursorY, int button) {
        super.func_146286_b(cursorX, cursorY, button);
        this.mouseDown &= ~(1 << button);
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY, button) || !this.elements.get(i).mouseReleased(this.field_146297_k, cursorX, cursorY, button)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.getAction(button, false), button);
        }
    }

    protected void backgroundClicked(int cursorX, int cursorY, int button) {
        if (button == 0 && !((SAOIngameGUI)this.field_146297_k.field_71456_v).backgroundClicked(cursorX, cursorY, button)) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void mouseWheel(int cursorX, int cursorY, int delta) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size() || !this.elements.get(i).mouseOver(cursorX, cursorY) || !this.elements.get(i).mouseWheel(this.field_146297_k, cursorX, cursorY, delta)) continue;
            this.actionPerformed(this.elements.get(i), SAOAction.MOUSE_WHEEL, delta);
        }
    }

    @Override
    public void actionPerformed(SAOElementGUI element, SAOAction action, int data) {
        element.click(this.field_146297_k.func_147118_V(), false);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.hasWheel()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int delta = Mouse.getEventDWheel();
            if (delta != 0) {
                this.mouseWheel(x, y, delta);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        if (this.grabbed) {
            Mouse.setGrabbed((boolean)false);
        }
        this.close();
    }

    public void close() {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (i >= this.elements.size()) continue;
            this.elements.get(i).close(this.field_146297_k);
            this.elements.remove(i);
        }
    }
}

