/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOButtonGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOIcon;
import com.thejackimonster.saoui.util.SAOInventory;
import com.thejackimonster.saoui.util.SAOParentGUI;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOSlotGUI
extends SAOButtonGUI {
    private static final String UNKNOWN = "???";
    private Slot buttonSlot;

    public SAOSlotGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h, Slot slot) {
        super(gui, SAOID.SLOT, xPos, yPos, w, h, SAOSlotGUI.getCaption(slot), SAOSlotGUI.getIcon(slot));
        this.buttonSlot = slot;
    }

    public SAOSlotGUI(SAOParentGUI gui, int xPos, int yPos, int w, Slot slot) {
        this(gui, xPos, yPos, w, 20, slot);
    }

    public SAOSlotGUI(SAOParentGUI gui, int xPos, int yPos, Slot slot) {
        this(gui, xPos, yPos, 150, slot);
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f && this.enabled) {
            int left = this.getX(false);
            int top = this.getY(false);
            ItemStack stack = this.getStack();
            if (stack != null) {
                String sizeString = "x" + stack.field_77994_a;
                SAOGL.glString(sizeString, left + this.width + 2, top + this.height - 16, SAOColor.multiplyAlpha(this.getColor(this.hoverState(cursorX, cursorY), false), this.visibility), true);
            }
        }
    }

    public void refreshSlot(Slot slot) {
        if (slot != null) {
            this.buttonSlot = slot;
            this.caption = SAOSlotGUI.getCaption(this.buttonSlot);
            this.icon = SAOSlotGUI.getIcon(this.buttonSlot);
        }
        if (this.isEmpty()) {
            this.remove();
        }
    }

    public boolean isEmpty() {
        return !this.buttonSlot.func_75216_d() || this.buttonSlot.func_75211_c() == null;
    }

    public Slot getSlot() {
        return this.buttonSlot;
    }

    public int getSlotNumber() {
        return this.buttonSlot.field_75222_d;
    }

    public ItemStack getStack() {
        if (this.isEmpty()) {
            return null;
        }
        return this.buttonSlot.func_75211_c();
    }

    @Override
    protected int getColor(int hoverState, boolean bg) {
        int color = super.getColor(hoverState, bg);
        if (this.highlight && hoverState != 2) {
            return SAOColor.mediumColor(color, SAOColor.mediumColor(-1, 255));
        }
        return color;
    }

    @Override
    public boolean keyTyped(Minecraft mc, char ch, int key) {
        return true;
    }

    @Override
    public boolean mouseOver(int cursorX, int cursorY, int flag) {
        this.focus = super.mouseOver(cursorX, cursorY, flag);
        return this.focus;
    }

    @Override
    public boolean mouseReleased(Minecraft mc, int cursorX, int cursorY, int button) {
        return super.mouseReleased(mc, cursorX, cursorY, button) || button == 1 || button == 2;
    }

    protected static final SAOIcon getIcon(ItemStack stack) {
        if (stack != null) {
            if (SAOInventory.WEAPONS.isFine(stack, false)) {
                return SAOIcon.EQUIPMENT;
            }
            if (SAOInventory.EQUIPMENT.isFine(stack, false)) {
                return SAOIcon.ARMOR;
            }
            if (SAOInventory.ACCESSORY.isFine(stack, false)) {
                return SAOIcon.ACCESSORY;
            }
            return SAOIcon.ITEMS;
        }
        return SAOIcon.NONE;
    }

    protected static final SAOIcon getIcon(Slot slot) {
        if (slot.func_75216_d() && slot.func_75211_c().func_77973_b() != null) {
            return SAOSlotGUI.getIcon(slot.func_75211_c());
        }
        return SAOIcon.HELP;
    }

    protected static final String getCaption(Slot slot) {
        if (slot.func_75216_d() && slot.func_75211_c().func_77973_b() != null) {
            return slot.func_75211_c().func_82833_r();
        }
        return UNKNOWN;
    }
}

