/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.SAOJ8String;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOParentGUI;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOTextGUI
extends SAOElementGUI {
    public String[] lines;
    public int fontColor;

    public SAOTextGUI(SAOParentGUI gui, int xPos, int yPos, String ... strings) {
        super(gui, xPos, yPos, 0, 0);
        this.lines = strings;
        this.fontColor = -2004317953;
    }

    public SAOTextGUI(SAOParentGUI gui, int xPos, int yPos, String text, int width) {
        this(gui, xPos, yPos, SAOTextGUI.toLines(text, width));
    }

    public SAOTextGUI(SAOParentGUI gui, int xPos, int yPos, String text) {
        this(gui, xPos, yPos, text, 0);
    }

    @Override
    public void update(Minecraft mc) {
        for (int i = 0; i < this.lines.length; ++i) {
            int strWidth = SAOGL.glStringWidth(this.lines[i]) + 16;
            if (strWidth <= this.width) continue;
            this.width = strWidth;
        }
        int linesHeight = this.lines.length * SAOGL.glStringHeight() + 16;
        if (linesHeight > this.height) {
            this.height = linesHeight;
        }
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        super.draw(mc, cursorX, cursorY);
        if (this.visibility > 0.0f) {
            int left = this.getX(false);
            int top = this.getY(false);
            for (int i = 0; i < this.lines.length; ++i) {
                SAOGL.glString(this.lines[i], left + 8, top + 8 + i * (SAOGL.glStringHeight() + 1), SAOColor.multiplyAlpha(this.fontColor, this.visibility));
            }
        }
    }

    public final void setText(String text) {
        this.lines = SAOTextGUI.toLines(text, this.width);
    }

    public final String getText() {
        return SAOJ8String.join("\n", this.lines);
    }

    private static final String[] toLines(String text, int width) {
        if (width <= 0) {
            return text.split("\n");
        }
        String[] rawLines = text.split("\n");
        if (rawLines.length <= 0) {
            return rawLines;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String cut = "";
        String line = rawLines[0];
        int rawIndex = 0;
        while (line != null) {
            int lastIndex;
            int size = SAOGL.glStringWidth(line);
            while (size > width - 16 && (lastIndex = line.lastIndexOf(32)) != -1) {
                cut = line.substring(lastIndex + 1) + " " + cut;
                line = line.substring(0, lastIndex);
                if (rawIndex + 1 < rawLines.length) {
                    rawLines[rawIndex + 1] = cut + rawLines[rawIndex + 1];
                    cut = "";
                }
                size = SAOGL.glStringWidth(line);
            }
            if (!line.matches(" *")) {
                lines.add(line);
            }
            if (cut.length() > 0) {
                line = cut;
                cut = "";
                continue;
            }
            if (++rawIndex < rawLines.length) {
                line = rawLines[rawIndex];
                continue;
            }
            line = null;
        }
        return lines.toArray(new String[lines.size()]);
    }
}

