/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.ui;

import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOLabelGUI;
import com.thejackimonster.saoui.ui.SAOMenuGUI;
import com.thejackimonster.saoui.util.SAOAlign;
import com.thejackimonster.saoui.util.SAOColor;
import com.thejackimonster.saoui.util.SAOGL;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOResources;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SAOWindowGUI
extends SAOMenuGUI {
    private final SAOLabelGUI titleLable;

    public SAOWindowGUI(SAOParentGUI gui, int xPos, int yPos, int w, int h, String title) {
        super(gui, xPos, yPos, w, h);
        this.titleLable = new SAOLabelGUI((SAOParentGUI)this, 0, 0, title, SAOAlign.CENTER);
        this.elements.add(this.titleLable);
        if (this.titleLable.width > this.width) {
            this.width = this.titleLable.width;
        }
    }

    public final void setTitle(String title) {
        this.titleLable.caption = title;
    }

    public final String getTitle() {
        return this.titleLable.caption;
    }

    @Override
    protected int getSize() {
        return Math.max(super.getSize(), 20) + 20;
    }

    @Override
    protected int getOffsetSize(SAOElementGUI element) {
        return element.visibility > 0.0f ? super.getOffsetSize(element) : 0;
    }

    @Override
    public void draw(Minecraft mc, int cursorX, int cursorY) {
        if (this.visibility > 0.0f) {
            SAOGL.glBindTexture(SAOResources.gui);
            SAOGL.glColorRGBA(SAOColor.multiplyAlpha(-1, this.visibility));
            int left = this.getX(false);
            int top = this.getY(false);
            int topBox = this.getBoxSize(false);
            int bottomBox = this.getBoxSize(true);
            int width2 = this.width / 2;
            int size = this.height - (topBox + bottomBox);
            SAOGL.glTexturedRect(left, top, width2, topBox, 0, 65, width2, 20);
            SAOGL.glTexturedRect(left + width2, top, width2, topBox, 200 - width2, 65, width2, 20);
            if (size > 0) {
                int borderSize = Math.min(size / 2, 10);
                SAOGL.glTexturedRect(left, top + topBox, 0, 85, width2, borderSize);
                SAOGL.glTexturedRect(left + width2, top + topBox, 200 - width2, 85, width2, borderSize);
                if ((size + 1) / 2 > 10) {
                    SAOGL.glTexturedRect(left, top + topBox + borderSize, this.width, size - borderSize * 2, 0, 95, 200, 10);
                }
                SAOGL.glTexturedRect(left, top + topBox + size - borderSize, 0, 115 - borderSize, width2, borderSize);
                SAOGL.glTexturedRect(left + width2, top + topBox + size - borderSize, 200 - width2, 115 - borderSize, width2, borderSize);
            }
            SAOGL.glTexturedRect(left, top + size + topBox, width2, bottomBox, 0, 65, width2, 20);
            SAOGL.glTexturedRect(left + width2, top + size + topBox, width2, bottomBox, 200 - width2, 65, width2, 20);
        }
        super.draw(mc, cursorX, cursorY);
    }

    @Override
    public int getY(boolean relative) {
        return super.getY(relative) + (relative ? 0 : this.height / 2);
    }

    protected int getBoxSize(boolean bottom) {
        return 20;
    }
}

