/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.util;

import com.thejackimonster.saoui.util.SAOColorState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class SAOColorCursor {
    private static final long STATE_TIME = 86400000L;
    private SAOColorState colorState;
    private long downgradeTime;

    public SAOColorCursor(SAOColorState defaultState, boolean set) {
        if (set) {
            this.colorState = defaultState;
            this.set(defaultState);
        } else {
            this.colorState = defaultState;
            this.downgradeTime = 0L;
        }
    }

    public SAOColorCursor() {
        this(SAOColorState.INNOCENT, false);
    }

    public final void update(long delay) {
        if (delay >= this.downgradeTime) {
            this.colorState = SAOColorState.INNOCENT;
            this.downgradeTime = 0L;
        } else {
            this.downgradeTime -= delay;
        }
    }

    public final void set(SAOColorState state) {
        if (state.ordinal() >= this.colorState.ordinal()) {
            this.colorState = state;
            this.downgradeTime = 86400000L;
        }
    }

    public final SAOColorState get() {
        return this.colorState;
    }
}

