/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.util;

import com.thejackimonster.saoui.SAOMod;
import com.thejackimonster.saoui.util.SAOGL;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum SAOColorState {
    INNOCENT(-1812709633),
    VIOLENT(-188940033),
    KILLER(-1124073217),
    GAMEMASTER(0x222222FF);

    private final int color;

    private SAOColorState(int argb) {
        this.color = argb;
    }

    public final void glColor() {
        SAOGL.glColorRGBA(this.color);
    }

    public static final SAOColorState getColorState(Minecraft mc, Entity entity, float time) {
        if (entity instanceof EntityPlayer) {
            return SAOColorState.getPlayerColorState(mc, (EntityPlayer)entity, time);
        }
        if (entity instanceof EntityCreature) {
            return SAOColorState.getEntityColorState((EntityCreature)entity);
        }
        return INNOCENT;
    }

    private static SAOColorState getEntityColorState(EntityCreature creature) {
        if (creature instanceof EntityTameable && ((EntityTameable)creature).func_70909_n()) {
            return VIOLENT;
        }
        if (creature instanceof EntityWolf && ((EntityWolf)creature).func_70919_bu() || creature.func_70638_az() instanceof EntityPlayer || creature.func_142015_aE() > 0 && creature.func_70643_av() instanceof EntityPlayer || creature instanceof EntityMob && !(creature instanceof EntityPigZombie)) {
            return KILLER;
        }
        return INNOCENT;
    }

    private static final SAOColorState getPlayerColorState(Minecraft mc, EntityPlayer player, float time) {
        return SAOMod.getColorState(player);
    }
}

