/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.util;

import com.thejackimonster.saoui.SAOMod;
import com.thejackimonster.saoui.util.SAOGL;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum SAOHealthStep {
    VERY_LOW(0.1f, -1124073217),
    LOW(0.2f, -201326337),
    VERY_DAMAGED(0.3f, -193462017),
    DAMAGED(0.4f, -188940033),
    OKAY(0.5f, -303351553),
    GOOD(1.0f, -1812709633);

    private final float healthLimit;
    private final int color;

    private SAOHealthStep(float limit, int argb) {
        this.healthLimit = limit;
        this.color = argb;
    }

    public final float getLimit() {
        return this.healthLimit;
    }

    public final void glColor() {
        SAOGL.glColorRGBA(this.color);
    }

    public final void glColor(EntityLivingBase entity) {
        this.glColor();
    }

    public static final SAOHealthStep getStep(Minecraft mc, EntityLivingBase entity, float time) {
        float value = SAOMod.getHealth(mc, (Entity)entity, time) / SAOMod.getMaxHealth((Entity)entity);
        SAOHealthStep step = SAOHealthStep.first();
        while (value > step.getLimit() && step.ordinal() + 1 < SAOHealthStep.values().length) {
            step = SAOHealthStep.next(step);
        }
        return step;
    }

    private static final SAOHealthStep first() {
        return SAOHealthStep.values()[0];
    }

    private static final SAOHealthStep next(SAOHealthStep step) {
        return SAOHealthStep.values()[step.ordinal() + 1];
    }
}

