/*
 * Decompiled with CFR 0.152.
 */
package com.thejackimonster.saoui.util;

import com.thejackimonster.saoui.SAOMod;
import com.thejackimonster.saoui.ui.SAOCharacterViewGUI;
import com.thejackimonster.saoui.ui.SAOElementGUI;
import com.thejackimonster.saoui.ui.SAOIconGUI;
import com.thejackimonster.saoui.ui.SAOLabelGUI;
import com.thejackimonster.saoui.ui.SAOMapGUI;
import com.thejackimonster.saoui.ui.SAOMenuGUI;
import com.thejackimonster.saoui.ui.SAOPanelGUI;
import com.thejackimonster.saoui.ui.SAOQuestGUI;
import com.thejackimonster.saoui.ui.SAOTextGUI;
import com.thejackimonster.saoui.ui.SAOVLineGUI;
import com.thejackimonster.saoui.util.SAOAlign;
import com.thejackimonster.saoui.util.SAOID;
import com.thejackimonster.saoui.util.SAOIcon;
import com.thejackimonster.saoui.util.SAOJString;
import com.thejackimonster.saoui.util.SAOParentGUI;
import com.thejackimonster.saoui.util.SAOPlayerString;
import com.thejackimonster.saoui.util.SAOString;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatFileWriter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class SAOSub {
    private SAOSub() {
    }

    public static final SAOMenuGUI resetSub(Minecraft mc, SAOMenuGUI sub) {
        sub.elements.clear();
        sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, SAOMod.getName(mc), SAOAlign.CENTER));
        sub.elements.add(new SAOVLineGUI(sub, 0, 0, 150));
        return sub;
    }

    public static final SAOMenuGUI createSub(Minecraft mc, SAOElementGUI element, int x, int y) {
        return SAOSub.resetSub(mc, new SAOPanelGUI(element, x, y, 175, 240));
    }

    public static final SAOMenuGUI createSocialSub(Minecraft mc, SAOElementGUI element, int x, int y) {
        SAOMenuGUI sub = SAOSub.createSub(mc, element, x, y);
        String[] party = SAOMod.listPartyMembers();
        if (party != null) {
            return SAOSub.setPartySub(mc, sub);
        }
        return SAOSub.setFriendsSub(mc, sub);
    }

    public static final SAOMenuGUI createNavigationSub(Minecraft mc, SAOElementGUI element, int x, int y) {
        return SAOSub.setQuestsSub(mc, SAOSub.createSub(mc, element, x, y), (EntityPlayer)mc.field_71439_g);
    }

    public static final SAOMenuGUI createMainProfileSub(Minecraft mc, SAOElementGUI element, int x, int y) {
        return SAOSub.resetProfileSub(mc, new SAOPanelGUI(element, x, y, 175, 240), (EntityPlayer)mc.field_71439_g);
    }

    public static final SAOMenuGUI resetFriendsSub(Minecraft mc, SAOMenuGUI sub) {
        return SAOSub.setFriendsSub(mc, SAOSub.resetSub(mc, sub));
    }

    public static final SAOMenuGUI resetPartySub(Minecraft mc, SAOMenuGUI sub) {
        return SAOSub.setPartySub(mc, SAOSub.resetSub(mc, sub));
    }

    public static final SAOMenuGUI resetProfileSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player) {
        sub.elements.clear();
        sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, SAOMod.getName(player), SAOAlign.CENTER));
        sub.elements.add(new SAOVLineGUI(sub, 0, 0, 150));
        return SAOSub.setProfileSub(mc, sub, player);
    }

    public static final SAOMenuGUI resetCheckPositionSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player, int zoom, String title) {
        sub.elements.clear();
        sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, SAOMod.getName(player), SAOAlign.CENTER));
        sub.elements.add(new SAOVLineGUI(sub, 0, 0, 150));
        return SAOSub.setCheckPositionSub(mc, sub, player, zoom, title);
    }

    public static final SAOMenuGUI resetQuestsSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player) {
        sub.elements.clear();
        sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, SAOMod.getName(player), SAOAlign.CENTER));
        sub.elements.add(new SAOVLineGUI(sub, 0, 0, 150));
        return SAOSub.setQuestsSub(mc, sub, player);
    }

    public static final SAOMenuGUI setEmptySub(Minecraft mc, SAOMenuGUI sub) {
        sub.elements.add(new SAOTextGUI((SAOParentGUI)sub, 0, 0, new String[4]));
        SAOIconGUI icon = new SAOIconGUI((SAOParentGUI)sub, SAOID.NONE, sub.width / 2 - 10, 0, SAOIcon.NONE);
        icon.bgColor = -2004317953;
        icon.disabledMask = -1;
        icon.enabled = false;
        sub.elements.add(icon);
        sub.elements.add(new SAOTextGUI((SAOParentGUI)sub, 0, 0, new String[4]));
        return sub;
    }

    public static final SAOMenuGUI setFriendsSub(Minecraft mc, SAOMenuGUI sub) {
        String[] friends = SAOMod.listFriends();
        boolean[] online = SAOMod.isOnline(mc, friends);
        int onlineCount = 0;
        for (boolean value : online) {
            if (!value) continue;
            ++onlineCount;
        }
        if (onlineCount > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < friends.length; ++i) {
                if (!online[i]) continue;
                builder.append(" - ").append(friends[i]).append('\n');
            }
            sub.elements.add(new SAOLabelGUI((SAOParentGUI)sub, 0, 0, "-Friends-", SAOAlign.CENTER));
            sub.elements.add(new SAOTextGUI((SAOParentGUI)sub, 0, 0, builder.toString()));
        } else {
            SAOSub.setEmptySub(mc, sub);
        }
        return sub;
    }

    public static final SAOMenuGUI setPartySub(Minecraft mc, SAOMenuGUI sub) {
        String[] party = SAOMod.listPartyMembers();
        if (party != null) {
            boolean[] online = SAOMod.isOnline(mc, party);
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < party.length; ++i) {
                if (!online[i]) continue;
                builder.append(" - ").append(party[i]).append('\n');
            }
            sub.elements.add(new SAOLabelGUI((SAOParentGUI)sub, 0, 0, "-Party-", SAOAlign.CENTER));
            sub.elements.add(new SAOTextGUI((SAOParentGUI)sub, 0, 0, builder.toString()));
        } else {
            SAOSub.setEmptySub(mc, sub);
        }
        return sub;
    }

    public static final SAOMenuGUI setProfileSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player) {
        if (player != null) {
            sub.elements.add(new SAOCharacterViewGUI(sub, 0, 0, sub.width, 150, player));
        } else {
            SAOSub.setEmptySub(mc, sub);
        }
        return sub;
    }

    public static final SAOMenuGUI setCheckPositionSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player, int zoom, String title) {
        if (player != null) {
            SAOMapGUI map = new SAOMapGUI((SAOParentGUI)sub, 0, 0, 4, player);
            map.zoom = zoom;
            if (title != null) {
                sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, title, SAOAlign.CENTER));
            }
            sub.elements.add(map);
        } else {
            SAOSub.setEmptySub(mc, sub);
        }
        return sub;
    }

    public static final SAOMenuGUI setQuestsSub(Minecraft mc, SAOMenuGUI sub, EntityPlayer player) {
        sub.elements.add(new SAOLabelGUI(sub, 0, 0, sub.width, "-Quest List-", SAOAlign.CENTER));
        SAOMenuGUI questList = new SAOMenuGUI(sub, 0, 0, sub.width, 150);
        questList.innerMenu = true;
        StatFileWriter stats = mc.field_71439_g.func_146107_m();
        if (stats != null) {
            for (Object obj0 : AchievementList.field_76007_e) {
                Achievement ach0;
                if (!(obj0 instanceof Achievement) || !(ach0 = (Achievement)obj0).func_75967_d() || stats.func_77443_a(ach0) || !stats.func_77442_b(ach0)) continue;
                questList.elements.add(new SAOQuestGUI((SAOParentGUI)questList, 0, 0, questList.width, ach0));
            }
        }
        sub.elements.add(questList);
        return sub;
    }

    public static final SAOPanelGUI addInfo(SAOMenuGUI sub) {
        SAOPanelGUI info = new SAOPanelGUI(sub, 0, 0, sub.width, 0);
        info.bgColor = -1145324545;
        info.innerMenu = true;
        sub.elements.add(info);
        return info;
    }

    public static final SAOString[] addProfileContent(Minecraft mc) {
        return SAOSub.addProfileContent((EntityPlayer)mc.field_71439_g);
    }

    public static final SAOString[] addProfileContent(EntityPlayer player) {
        return new SAOString[]{new SAOJString("Profile"), new SAOPlayerString(player)};
    }

    public static final SAOString[] addPositionContent(EntityPlayer player, EntityPlayer search) {
        StringBuilder floor = new StringBuilder("Floor ");
        StringBuilder builder = new StringBuilder();
        if (player != null) {
            floor.append(1 - player.field_71093_bK);
            builder.append("X: ").append((int)player.field_70165_t).append(", ");
            builder.append("Y: ").append((int)player.field_70163_u).append(", ");
            builder.append("Z: ").append((int)player.field_70161_v).append('\n');
            if (player != search) {
                builder.append("Distance: ");
                builder.append((double)((int)(Math.sqrt(player.func_70068_e((Entity)search)) * 1000.0)) / 1000.0);
                builder.append('\n');
            }
        } else {
            floor.append("0");
        }
        return new SAOString[]{new SAOJString(floor.toString()), new SAOJString(builder.toString())};
    }
}

