/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib;

import alexiil.mods.lib.ConfigAccess;
import alexiil.mods.lib.git.Commit;
import alexiil.mods.lib.git.GitHubUser;
import alexiil.mods.lib.git.Release;
import alexiil.mods.lib.git.SiteRequester;
import alexiil.mods.lib.net.INetworkProvider;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

public abstract class AlexIILMod {
    public Property netRate;
    public Property netDistance;
    public Property connectExternally;
    public Logger log;
    public ModMetadata meta;
    public CreativeTabs tab;
    public ConfigAccess cfg;
    public INetworkProvider provider;
    private List<GitHubUser> contributors = null;
    private List<Commit> commits = null;
    private List<Release> releases = null;
    private Commit thisCommit = null;

    public void preInit(FMLPreInitializationEvent event) {
        this.log = event.getModLog();
        this.meta = event.getModMetadata();
        this.cfg = ConfigAccess.get(event.getSuggestedConfigurationFile(), this);
        this.connectExternally = this.cfg.getProp("connectExternally", true);
        this.connectExternally.comment = "If this is enabled, it will connect to an external server (drone.io) to fetch changelogs and release information";
    }

    protected void useTiles() {
        this.netRate = this.cfg.getProp("netRate", 120);
        this.netRate.comment = "How long to wait between sending updates, in ticks";
        this.netDistance = this.cfg.getProp("netDistance", 120);
        this.netDistance.comment = "The range in which to send updates to players";
    }

    public void initSiteVersioning() {
        String droneSite = this.getBaseSite();
        this.contributors = Collections.unmodifiableList(SiteRequester.getContributors(droneSite + "contributors.json"));
        if (this.contributors.size() == 0) {
            this.meta.authorList.add("Could not connect to GitHub to fetch the rest...");
        }
        for (GitHubUser gitHubUser : this.contributors) {
            if ("AlexIIL".equals(gitHubUser.login)) continue;
            this.meta.authorList.add(gitHubUser.login);
        }
        this.commits = SiteRequester.getCommits(droneSite + "commits.json");
        Collections.sort(this.commits, new Comparator<Commit>(){

            @Override
            public int compare(Commit c0, Commit c1) {
                return c1.commit.committer.date.compareTo(c0.commit.committer.date);
            }
        });
        this.commits = Collections.unmodifiableList(this.commits);
        for (Commit commit : this.commits) {
            if (!this.getCommitHash().equals(commit.sha)) continue;
            this.thisCommit = commit;
        }
        if (this.thisCommit == null && this.commits.size() > 0 && this.getBuildType() == 2) {
            this.log.warn("Didn't find my commit! This is unexpected, consider this a bug!");
            this.log.warn("Commit Hash : \"" + this.getCommitHash() + "\"");
        }
        this.releases = Collections.unmodifiableList(SiteRequester.getReleases(droneSite + "releases.json"));
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.cfg.saveAll();
    }

    public String format(String toFormat, Object ... objects) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return I18n.func_135052_a((String)toFormat, (Object[])objects);
        }
        return toFormat;
    }

    public List<GitHubUser> getContributors() {
        if (this.contributors == null) {
            this.initSiteVersioning();
        }
        return this.contributors;
    }

    public List<Commit> getCommits() {
        if (this.contributors == null) {
            this.initSiteVersioning();
        }
        return this.commits;
    }

    public Commit getCurrentCommit() {
        if (this.contributors == null) {
            this.initSiteVersioning();
        }
        return this.thisCommit;
    }

    public List<Release> getReleases() {
        if (this.contributors == null) {
            this.initSiteVersioning();
        }
        return this.releases;
    }

    public abstract String getCommitHash();

    public abstract int getBuildType();

    public String getBaseSite() {
        return "https://drone.io/github.com/" + this.getUser() + "/" + this.getRepo() + "/files/VersionInfo/build/libs/version/";
    }

    public abstract String getUser();

    public abstract String getRepo();
}

