/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class BlockPosUtils {
    public static BlockPos readFromNBT(NBTTagCompound nbt, String tagPart) {
        int[] arr = nbt.func_74759_k(tagPart);
        return new BlockPos(arr[0], arr[1], arr[2]);
    }

    public static BlockPos readFromNBT(NBTTagCompound nbt) {
        return BlockPosUtils.readFromNBT(nbt, "pos");
    }

    public static NBTTagCompound saveToNBT(BlockPos pos, String tagPart) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a(tagPart, new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        return nbt;
    }

    public static NBTTagCompound saveToNBT(BlockPos pos) {
        return BlockPosUtils.saveToNBT(pos, "pos");
    }

    public static BlockPos readFromByteBuf(ByteBuf buffer) {
        return new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void writeToByteBuf(ByteBuf buffer, BlockPos pos) {
        buffer.writeInt(pos.func_177958_n());
        buffer.writeInt(pos.func_177956_o());
        buffer.writeInt(pos.func_177952_p());
    }

    public static AxisAlignedBB getBB(BlockPos pos, int range) {
        double xMin = pos.func_177958_n() - range;
        return AxisAlignedBB.func_178781_a((double)xMin, (double)(pos.func_177956_o() - range), (double)(pos.func_177952_p() - range), (double)(pos.func_177958_n() + range), (double)(pos.func_177956_o() + range), (double)(pos.func_177952_p() + range));
    }

    public static AxisAlignedBB getBB(Entity pos, int range) {
        return AxisAlignedBB.func_178781_a((double)(pos.field_70165_t - (double)range), (double)(pos.field_70163_u - (double)range), (double)(pos.field_70161_v - (double)range), (double)(pos.field_70165_t + (double)range), (double)(pos.field_70163_u + (double)range), (double)(pos.field_70161_v + (double)range));
    }

    public static AxisAlignedBB getBB(TileEntity tile, int range) {
        return BlockPosUtils.getBB(tile.func_174877_v(), range);
    }

    public static BlockPos move(BlockPos pos, EnumFacing direction) {
        int x = direction.func_176740_k() == EnumFacing.Axis.X ? direction.func_176743_c().func_179524_a() : 0;
        int y = direction.func_176740_k() == EnumFacing.Axis.Y ? direction.func_176743_c().func_179524_a() : 0;
        int z = direction.func_176740_k() == EnumFacing.Axis.Z ? direction.func_176743_c().func_179524_a() : 0;
        return pos.func_177982_a(x, y, z);
    }
}

