/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.block;

import alexiil.mods.lib.AlexIILMod;
import alexiil.mods.lib.item.ItemBlockMeta;
import alexiil.mods.lib.tile.TileEntityBasic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockContainerBasic
extends BlockContainer {
    private static final List<BlockContainerBasic> blocks = new ArrayList<BlockContainerBasic>();
    public final boolean enabled;
    public final String name;
    protected AlexIILMod mod;

    public static void initModels() {
        for (BlockContainerBasic ib : blocks) {
            ib.initModel();
        }
    }

    public BlockContainerBasic(Material material, String name, AlexIILMod mod) {
        super(material);
        this.name = name;
        this.mod = mod;
        this.func_149663_c(mod.meta.modId + "_" + name);
        Property prop = mod.cfg.cfg().get("blocks", name, "true");
        prop.comment = "Enable the " + mod.format(this.func_149739_a() + ".name", new Object[0]) + " block";
        this.enabled = prop.getBoolean();
        if (this.enabled) {
            GameRegistry.registerBlock((Block)this, ItemBlockMeta.class, (String)name);
            GameRegistry.registerTileEntity(this.getTileClass(), (String)(mod.meta.modId + "_tile_" + name));
            this.func_149647_a(mod.tab);
            blocks.add(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getMetaBlocks(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int getMetaBlocks() {
        return 1;
    }

    public abstract Class<? extends TileEntityBasic> getTileClass();

    public void initModel() {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        mesher.func_178086_a(Item.func_150898_a((Block)this), 0, new ModelResourceLocation(this.mod.meta.modId + ":" + this.name));
    }

    public int func_149645_b() {
        return 3;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ((TileEntityBasic)world.func_175625_s(pos)).dropItems();
        super.func_180663_b(world, pos, state);
    }
}

