/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;

public class BlockMeta {
    public final Block block;
    public final int meta;
    public static final String NBT_META = "BLOCK_METADATA";
    public static final String NBT_BLOCK = "BLOCK_BLOCK";
    private static ArrayList<BlockMeta> blockMetaPool = new ArrayList();

    private BlockMeta(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        blockMetaPool.add(this);
    }

    public static BlockMeta get(Block block, int meta) {
        if (block == null || block == Blocks.field_150350_a) {
            return null;
        }
        for (BlockMeta bm : blockMetaPool) {
            if (!bm.block.equals(block) || bm.meta != meta) continue;
            return bm;
        }
        return new BlockMeta(block, meta);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + this.meta;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockMeta other = (BlockMeta)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        return this.meta == other.meta;
    }

    public String toString() {
        String toShow;
        try {
            toShow = this.block.func_149732_F() + ":" + this.meta;
        }
        catch (Throwable t) {
            toShow = this.block + ":" + this.meta;
        }
        return toShow;
    }

    public static BlockMeta readFromNBT(NBTTagCompound nbt) {
        return BlockMeta.get((Block)Block.field_149771_c.func_82594_a((Object)nbt.func_74779_i(NBT_BLOCK)), nbt.func_74762_e(NBT_META));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a(NBT_META, this.meta);
        nbt.func_74778_a(NBT_BLOCK, (String)Block.field_149771_c.func_177774_c((Object)this.block));
    }
}

