/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class FluidInfo {
    private static List<FluidInfo> fluids = new ArrayList<FluidInfo>();
    public final FluidType type;
    public final IBlockState block;

    public static FluidInfo getFluidInfo(FluidType type, IBlockState b) {
        for (FluidInfo fluid : fluids) {
            if (fluid.type != type || !fluid.block.equals(b)) continue;
            return fluid;
        }
        return new FluidInfo(type, b);
    }

    public static FluidInfo getFluidInfo(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        FluidType type = block == null ? FluidType.NONE : (block == Blocks.field_150356_k || block == Blocks.field_150353_l ? (FluidInfo.getLevel(block) == 0 ? FluidType.LAVA_SOURCE : FluidType.LAVA_FLOW) : (block == Blocks.field_150358_i || block == Blocks.field_150355_j ? (FluidInfo.getLevel(block) == 0 ? FluidType.WATER_SOURCE : FluidType.WATER_FLOW) : (block instanceof BlockLiquid ? FluidType.STATIONARY : FluidType.NONE)));
        for (FluidInfo fluid : fluids) {
            if (fluid.type != type || !fluid.block.equals(block)) continue;
            return fluid;
        }
        return new FluidInfo(type, block);
    }

    private static int getLevel(IBlockState state) {
        Comparable c = state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        return (Integer)c;
    }

    private FluidInfo(FluidType type, IBlockState b) {
        this.block = b;
        this.type = type;
        fluids.add(this);
    }

    public static enum FluidType {
        NONE,
        WATER_SOURCE,
        WATER_FLOW,
        LAVA_FLOW,
        LAVA_SOURCE,
        STATIONARY,
        FLUID_BLOCK;

    }
}

