/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.coremod;

import alexiil.mods.lib.AlexIILLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.config.Property;

public class ChatTextTime {
    private static Property doSecs;
    private static Property doSecsWhileMin;
    private static Property doTimeChar;
    private static Property preTimeChar;
    private static Property postTimeChar;

    public static void init() {
        doSecs = AlexIILLib.instance.cfg.getProp("textTime.doSecs.enabled", "true");
        doSecsWhileMin = AlexIILLib.instance.cfg.getProp("textTime.doSecs.whileMin", "true");
        doTimeChar = AlexIILLib.instance.cfg.getProp("textTime.timeChar.enabled", "true");
        preTimeChar = AlexIILLib.instance.cfg.getProp("textTime.timeChar.pre", "<");
        postTimeChar = AlexIILLib.instance.cfg.getProp("textTime.timeChar.post", ">");
    }

    private static String getUnformatedText(IChatComponent chat) {
        String formatted = chat.func_150254_d();
        String unformatted = "";
        for (int i = 0; i < formatted.length(); ++i) {
            if (167 == formatted.codePointAt(i)) {
                ++i;
                continue;
            }
            unformatted = unformatted + formatted.charAt(i);
        }
        return unformatted;
    }

    private static String getTime(int ticks) {
        WorldClient wc = Minecraft.func_71410_x().field_71441_e;
        long age = wc.func_82737_E() % 20L;
        if ((ticks = (int)((long)ticks - age)) < 20) {
            return "0s";
        }
        int secs = ticks / 20 % 60;
        int mins = ticks / 1200 % 60;
        int hours = ticks / 72000;
        String total = hours == 0 ? "" : hours + "h";
        total = total + (mins == 0 ? "" : mins + "m");
        if (doSecs.getBoolean() && (doSecsWhileMin.getBoolean() || mins <= 0)) {
            total = total + (secs == 0 ? "" : secs + "s");
        }
        return total;
    }

    private static String getPrePostChars(String time) {
        if (!doTimeChar.getBoolean()) {
            return time;
        }
        String pre = preTimeChar.getString();
        String post = postTimeChar.getString();
        return pre + time + post;
    }

    private static boolean shouldDoPlayerStuff(String unformatted) {
        if (unformatted == null || unformatted.length() == 0) {
            return false;
        }
        return unformatted.charAt(0) == '<';
    }

    public static String getTimeText(IChatComponent chatLine, int ticks) {
        if (!AlexIILLib.timeText.getBoolean()) {
            return chatLine.func_150254_d();
        }
        String unformatted = ChatTextTime.getUnformatedText(chatLine);
        if (!ChatTextTime.shouldDoPlayerStuff(unformatted)) {
            return chatLine.func_150254_d();
        }
        String time = ChatTextTime.getTime(ticks);
        return ChatTextTime.getPrePostChars(time) + chatLine.func_150254_d();
    }
}

