/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.lib.coremod;

import alexiil.mods.lib.AlexIILLib;
import alexiil.mods.lib.coremod.ChatTextTime;
import alexiil.mods.lib.coremod.LogHelperTransformer;
import alexiil.mods.lib.coremod.RoamingIPAddress;
import alexiil.mods.lib.coremod.VanillaMethods;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    public static Logger log = LogManager.getLogger((String)"alexiillib.classTransformer");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        try {
            if (transformedName.equals("net.minecraft.client.gui.GuiMultiplayer") && AlexIILLib.roamingIP.getBoolean()) {
                return this.transformGuiMultiplayer(basicClass, !transformedName.equals(name));
            }
            if (transformedName.equals("net.minecraft.client.gui.ServerListEntryNormal") && AlexIILLib.roamingIP.getBoolean()) {
                return this.transformServerListEntryNormal(basicClass, !name.equals(transformedName));
            }
            if (transformedName.equals("net.minecraft.client.renderer.InventoryEffectRenderer") && AlexIILLib.betterPotions.getBoolean()) {
                return this.transformInventoryEffectRenderer(basicClass, !name.equals(transformedName));
            }
            if (transformedName.equals("net.minecraft.client.gui.GuiNewChat") && AlexIILLib.timeText.getBoolean()) {
                return this.transformGuiNewChat(basicClass, !name.equals(transformedName));
            }
        }
        catch (Throwable t) {
            log.warn("Transforming class " + transformedName + " FAILIED! Returning the old version of the class to avoid crashes.");
            t.printStackTrace();
        }
        if ("alexiil.mods.lib.AlexIILLibLog".equals(name)) {
            return basicClass;
        }
        return LogHelperTransformer.transform(name, basicClass);
    }

    protected void showDiff(String className, byte[] input, byte[] output) {
        log.info("Finished Transforming " + className);
        if (input == null) {
            log.debug("input was null");
        }
        if (output == null) {
            log.debug("output was null");
        }
        if (input == null || output == null) {
            return;
        }
        log.info(input.length + " bytes to " + output.length + " bytes.");
    }

    private byte[] transformInventoryEffectRenderer(byte[] input, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(input);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("drawActivePotionEffects") && !m.name.equals("func_147044_g")) continue;
            int astores = 0;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode node = m.instructions.get(i);
                if (astores < 8 && node.getOpcode() == 58) {
                    ++astores;
                    continue;
                }
                if (astores == 8) {
                    ++astores;
                    continue;
                }
                if (astores != 9) continue;
                ++astores;
                VarInsnNode node1 = new VarInsnNode(25, 9);
                m.instructions.insert(node, (AbstractInsnNode)node1);
                node = node1;
                node1 = new VarInsnNode(25, 7);
                m.instructions.insert(node, (AbstractInsnNode)node1);
                node = node1;
                node1 = new MethodInsnNode(184, Type.getInternalName(VanillaMethods.class), "getEnchantmentLevel", "(Ljava/lang/String;" + Type.getDescriptor(PotionEffect.class) + ")Ljava/lang/String;", false);
                m.instructions.insert(node, (AbstractInsnNode)node1);
                node = node1;
                m.instructions.insert(node, (AbstractInsnNode)new VarInsnNode(58, 9));
            }
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        this.showDiff("InventoryEffectRenderer", input, cw.toByteArray());
        return cw.toByteArray();
    }

    private byte[] transformGuiNewChat(byte[] input, boolean obfs) {
        log.info("Transforming class GuiNewChat");
        ClassNode classNodeorig = new ClassNode();
        ClassReader rd = new ClassReader(input);
        rd.accept((ClassVisitor)classNodeorig, 0);
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(input);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("drawChat") && !m.name.equals("func_146230_a")) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode node = m.instructions.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.owner.equals(Type.getInternalName(ChatLine.class)) || !method.name.equals("getChatComponent") && !method.name.equals("func_151461_a")) continue;
                m.instructions.remove(method.getNext());
                m.instructions.insert((AbstractInsnNode)method, (AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(ChatTextTime.class), "getTimeText", "(" + Type.getDescriptor(IChatComponent.class) + "I)Ljava/lang/String;", false));
                m.instructions.insert((AbstractInsnNode)method, (AbstractInsnNode)new VarInsnNode(21, obfs ? 11 : 10));
            }
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        log.info("Transformed class GuiNewChat");
        this.showDiff("GuiNewChat", input, cw.toByteArray());
        return cw.toByteArray();
    }

    private byte[] transformServerListEntryNormal(byte[] input, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(input);
        reader.accept((ClassVisitor)classNode, 0);
        ClassNode classNodeorig = new ClassNode();
        new ClassReader(input).accept((ClassVisitor)classNodeorig, 0);
        String className = "net/minecraft/client/gui/ServerListEntryNormal";
        classNode.fields.add(new FieldNode(2, "roamingServer", Type.getDescriptor(ServerData.class), null, null));
        for (MethodNode m : classNode.methods) {
            if (m.name.equals("<init>")) {
                AbstractInsnNode before = null;
                int dups = 0;
                int aloads = 0;
                boolean done = false;
                AbstractInsnNode lastPutField = null;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode current = m.instructions.get(i);
                    if (current.getOpcode() == 25) {
                        ++aloads;
                    }
                    if (aloads == 5 && !done) {
                        m.instructions.insert(current, (AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(RoamingIPAddress.class), "getModifiedRoamingServerData", "(" + Type.getDescriptor(ServerData.class) + ")" + Type.getDescriptor(ServerData.class), false));
                        ++i;
                        done = true;
                    }
                    if (dups < 2 && m.instructions.get(i).getOpcode() == 89) {
                        ++dups;
                    } else if (dups == 2) {
                        m.instructions.remove(m.instructions.get(i));
                        --i;
                        dups = 3;
                    } else if (dups == 3) {
                        before = m.instructions.get(i);
                        log.warn(this.getInsn(before));
                        dups = 4;
                    } else if (dups == 4) {
                        log.warn(this.getInsn(current));
                        m.instructions.remove(m.instructions.get(i));
                        m.instructions.insert(before, (AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(StringBuilder.class), "<init>", "(Ljava/lang/String;)V", false));
                        dups = 5;
                    }
                    if (m.instructions.get(i).getOpcode() != 181) continue;
                    lastPutField = m.instructions.get(i);
                }
                m.instructions.insert(lastPutField, (AbstractInsnNode)new FieldInsnNode(181, className, "roamingServer", Type.getDescriptor(ServerData.class)));
                m.instructions.insert(lastPutField, (AbstractInsnNode)new VarInsnNode(25, 2));
                m.instructions.insert(lastPutField, (AbstractInsnNode)new VarInsnNode(25, 0));
                continue;
            }
            if (m.name.equals("drawEntry") || m.name.equals("func_180790_a")) {
                int getFields = 0;
                for (int i = 0; i < m.instructions.size(); ++i) {
                    AbstractInsnNode node = m.instructions.get(i);
                    if (node.getOpcode() != 180 || ++getFields != 13) continue;
                    m.instructions.insert(node, (AbstractInsnNode)new FieldInsnNode(180, className, "roamingServer", Type.getDescriptor(ServerData.class)));
                    m.instructions.remove(node);
                }
                continue;
            }
            if (!m.name.equals("getServerData") && !m.name.equals("func_148296_a")) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode node = m.instructions.get(i);
                if (m.instructions.get(i).getOpcode() != 180) continue;
                m.instructions.insert(node, (AbstractInsnNode)new FieldInsnNode(180, className, "roamingServer", Type.getDescriptor(ServerData.class)));
                m.instructions.remove(node);
            }
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        byte[] out = cw.toByteArray();
        this.showDiff("net.minecraft.client.gui.ServerListEntryNormal", input, out);
        return out;
    }

    private byte[] transformGuiMultiplayer(byte[] input, boolean obfuscated) {
        String targetmethodName = obfuscated ? "func_146791_a" : "connectToServer";
        ClassNode classNode = new ClassNode();
        ClassReader reader = new ClassReader(input);
        reader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(targetmethodName)) continue;
            AbstractInsnNode lastALOAD = null;
            for (int i = 0; i < m.instructions.size(); ++i) {
                AbstractInsnNode ins = m.instructions.get(i);
                if (ins.getOpcode() != 25) continue;
                lastALOAD = ins;
            }
            m.instructions.insert(lastALOAD, (AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(RoamingIPAddress.class), "getModifiedRoamingServerData", "(" + Type.getDescriptor(ServerData.class) + ")" + Type.getDescriptor(ServerData.class), false));
        }
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        byte[] out = cw.toByteArray();
        this.showDiff("net.minecraft.client.gui.GuiMultiplayer", input, out);
        return out;
    }

    protected void showMethod(MethodNode m, int from) {
        log.info("Showing Method...");
        for (int i = from; i < m.instructions.size() && i < from + 12; ++i) {
            log.info("  -" + this.getInsn(m.instructions.get(i)));
        }
    }

    protected void showMethodDiff(ClassNode node1, ClassNode node2, String methodName) {
        log.warn("---------------------------------------------------------------------------------------------------");
        log.warn("Showing Method Diffs of " + methodName + "----------------------------------------------------------------------------------");
        log.warn("---------------------------------------------------------------------------------------------------");
        MethodNode meth1 = this.getMethod(node1, methodName);
        MethodNode meth2 = this.getMethod(node2, methodName);
        for (int i = 0; i < meth1.instructions.size(); ++i) {
            if (this.getInsn(meth1.instructions.get(i)).equals(this.getInsn(meth2.instructions.get(i)))) continue;
            log.warn("Line " + i + ":" + this.getInsn(meth1.instructions.get(i)) + " -> " + this.getInsn(meth2.instructions.get(i)));
        }
    }

    protected MethodNode getMethod(ClassNode node, String name) {
        for (MethodNode m : node.methods) {
            if (!m.name.equals(name)) continue;
            return m;
        }
        return null;
    }

    protected String getInsn(AbstractInsnNode ins) {
        if (ins instanceof MethodInsnNode) {
            MethodInsnNode n = (MethodInsnNode)ins;
            return n.owner + "," + n.name + "," + n.desc;
        }
        if (ins instanceof FieldInsnNode) {
            FieldInsnNode n = (FieldInsnNode)ins;
            return n.owner + "," + n.name + "," + n.desc;
        }
        if (ins instanceof VarInsnNode) {
            VarInsnNode n = (VarInsnNode)ins;
            return n.getOpcode() + " " + n.var;
        }
        return ins.getOpcode() + ":" + ins.getClass().getSimpleName();
    }

    protected void showMethod(ClassNode classNode, String methodName) {
        log.warn("---------------------------------------------------------------------------------------------------");
        log.warn("Showing Method " + methodName + "----------------------------------------------------------------------------------");
        log.warn("---------------------------------------------------------------------------------------------------");
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName)) continue;
            for (int i = 0; i < m.instructions.size(); ++i) {
                log.warn("Line" + i + ":" + this.getInsn(m.instructions.get(i)));
            }
        }
    }
}

